/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.api.exception;

import java.util.Locale;
import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_ERROR_CODE;
import org.sdmxsource.sdmx.api.util.MessageResolver;

public class SdmxException
extends RuntimeException {
    private static Logger LOG = Logger.getLogger(SdmxException.class);
    private static final long serialVersionUID = 7230038232116051945L;
    private static MessageResolver messageResolver;
    private ExceptionCode code;
    private String codeStr;
    private Object[] args;
    private Throwable th;
    private SDMX_ERROR_CODE errorCode = SDMX_ERROR_CODE.INTERNAL_SERVER_ERRROR;

    public SdmxException(String errorMessage) {
        this(null, null, errorMessage);
    }

    public SdmxException(ExceptionCode code) {
        this(SDMX_ERROR_CODE.INTERNAL_SERVER_ERRROR, code, new Object[0]);
    }

    public SdmxException(String errorMessage, SDMX_ERROR_CODE errorCode) {
        this(null, errorCode, errorMessage);
    }

    public SdmxException(Throwable th, String str) {
        this(th, null, str);
    }

    public SdmxException(Throwable th, SDMX_ERROR_CODE errorCode, String message) {
        super(message, th);
        this.th = th;
        if (errorCode != null) {
            this.errorCode = errorCode;
        }
        if (th != null) {
            th.printStackTrace();
            if (errorCode == null && th instanceof SdmxException) {
                this.errorCode = ((SdmxException)th).getSdmxErrorCode();
            }
        } else {
            this.printStackTrace();
        }
        LOG.error((Object)this.getMessage(), (Throwable)this);
    }

    public SdmxException(Throwable th, ExceptionCode code, Object ... args) {
        this(th, null, code, args);
    }

    public SdmxException(SDMX_ERROR_CODE errorCode, ExceptionCode code, Object ... args) {
        this(null, errorCode, code, args);
    }

    public SdmxException(Throwable th, SDMX_ERROR_CODE errorCode, ExceptionCode code, Object ... args) {
        super(th);
        this.th = th;
        this.errorCode = errorCode;
        this.args = args;
        if (th != null) {
            th.printStackTrace();
            if (errorCode == null && th instanceof SdmxException) {
                this.errorCode = ((SdmxException)th).getSdmxErrorCode();
            }
        } else {
            this.printStackTrace();
        }
        if (code != null) {
            this.code = code;
            this.codeStr = code.getCode();
        }
        LOG.error((Object)this.getMessage(), (Throwable)this);
    }

    public SDMX_ERROR_CODE getSdmxErrorCode() {
        return this.errorCode;
    }

    public Integer getHttpRestErrorCode() {
        return this.errorCode.getHttpRestErrorCode();
    }

    @Override
    public String getMessage() {
        if (this.codeStr == null) {
            return super.getMessage();
        }
        return this.getMessage(this.th, this.codeStr, this.args);
    }

    public String getFullMessage() {
        if (this.codeStr == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(super.getMessage());
            if (this.getCause() != null) {
                sb.append("  - caused by " + System.getProperty("line.separator"));
                if (this.getCause() instanceof SdmxException) {
                    sb.append(((SdmxException)this.getCause()).getFullMessage());
                } else {
                    sb.append(this.getCause().getMessage());
                }
            }
            return sb.toString();
        }
        return this.getFullMessage(this.th, this.codeStr, this.args);
    }

    public String getMessage(Locale loc) {
        return this.getMessage(this.th, this.codeStr, this.args, loc);
    }

    public ExceptionCode getCode() {
        if (this.code == null && this.th != null && this.th instanceof SdmxException) {
            return ((SdmxException)this.th).getCode();
        }
        return this.code;
    }

    public String getMessage(Throwable th, String code, Object[] args) {
        String nestedMessage = "";
        if (code == null) {
            return nestedMessage;
        }
        return this.resolveMessage(code, args);
    }

    public String getFullMessage(Throwable th, String code, Object[] args) {
        String nestedMessage = "";
        if (th != null) {
            if (th instanceof SdmxException) {
                SdmxException ex = (SdmxException)th;
                nestedMessage = "Nested Message : " + ex.getFullMessage();
            } else {
                nestedMessage = "Nested Message : " + th.getMessage();
            }
        }
        if (code == null) {
            return nestedMessage;
        }
        if (nestedMessage != null && nestedMessage.length() > 0) {
            return this.resolveMessage(code, args) + "\n\n" + nestedMessage;
        }
        return this.resolveMessage(code, args);
    }

    public String getMessage(Throwable th, String code, Object[] args, Locale loc) {
        String nestedMessage = "";
        if (th != null) {
            if (th instanceof SdmxException) {
                nestedMessage = ((SdmxException)th).getMessage(loc);
            }
            nestedMessage = th.getMessage();
        }
        if (code == null) {
            return nestedMessage;
        }
        if (nestedMessage != null && nestedMessage.length() > 0) {
            return this.resolveMessage(code, args, loc) + "\n\n" + nestedMessage;
        }
        return this.resolveMessage(code, args, loc);
    }

    public String resolveMessage(String code, Object[] args) {
        if (messageResolver == null) {
            return code;
        }
        StringBuilder sb = new StringBuilder();
        Locale myLoc = null;
        myLoc = Locale.ENGLISH;
        sb.append(myLoc);
        sb.append("\n\n");
        String message = messageResolver.resolveMessage(code, myLoc, args);
        if (message != null && message.length() > 0) {
            return message;
        }
        return "Exception message could not be resolved for code : " + code + " the following locales were checked: " + sb.toString();
    }

    public String resolveMessage(String code, Object[] args, Locale loc) {
        if (messageResolver == null) {
            return code;
        }
        String message = messageResolver.resolveMessage(code, loc, args);
        if (message != null && message.length() > 0) {
            return message;
        }
        return "Exception message could not be resolved for code : " + code + " for the following locale " + loc;
    }

    public String getErrorType() {
        return "Sdmx Exception";
    }

    public static void setMessageResolver(MessageResolver messageResolver) {
        SdmxException.messageResolver = messageResolver;
    }
}

