/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.querybuilder.manager;

import org.sdmxsource.sdmx.api.builder.DataQueryBuilder;
import org.sdmxsource.sdmx.api.exception.SdmxUnauthorisedException;
import org.sdmxsource.sdmx.api.factory.DataQueryFactory;
import org.sdmxsource.sdmx.api.manager.query.DataQueryBuilderManager;
import org.sdmxsource.sdmx.api.model.data.query.DataQuery;
import org.sdmxsource.sdmx.api.model.format.DataQueryFormat;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service(value="dataQueryBuilderManager")
public class DataQueryBuilderManagerImpl
implements DataQueryBuilderManager,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    public <T> T buildDataQuery(DataQuery dataQuery, DataQueryFormat<T> dataQueryFormat) {
        for (DataQueryFactory currentFactory : this.applicationContext.getBeansOfType(DataQueryFactory.class).values()) {
            DataQueryBuilder builder = currentFactory.getDataQueryBuilder(dataQueryFormat);
            if (builder == null) continue;
            return (T)builder.buildDataQuery(dataQuery);
        }
        throw new SdmxUnauthorisedException("Unsupported DataQueryFormat: " + dataQueryFormat);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

