/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.opexecution;

import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecutionBuilder;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.gwtservice.shared.tr.normalization.NormalizationSession;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.operations.OperationsId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecution4Normalization
extends OpExecutionBuilder {
    protected static Logger logger = LoggerFactory.getLogger(OpExecution4Normalization.class);
    private TabularDataService service;
    private NormalizationSession normalizationSession;

    public OpExecution4Normalization(TabularDataService service, NormalizationSession normalizationSession) {
        this.service = service;
        this.normalizationSession = normalizationSession;
    }

    @Override
    public void buildOpEx() throws TDGWTServiceException {
        OperationExecution invocation = null;
        logger.debug(this.normalizationSession.toString());
        HashMap map = new HashMap();
        ArrayList<ColumnData> cols = this.normalizationSession.getColumns();
        logger.debug("Column To Set: " + cols);
        ArrayList<ColumnReference> columnReferences = new ArrayList<ColumnReference>();
        for (ColumnData col : cols) {
            ColumnLocalId cId = new ColumnLocalId(col.getColumnId());
            TRId trId = col.getTrId();
            logger.debug("trID: " + trId);
            long tabId = trId.isViewTable() ? new Long(trId.getReferenceTargetTableId()).longValue() : new Long(trId.getTableId()).longValue();
            TableId tId = new TableId(tabId);
            ColumnReference columnReference = new ColumnReference(tId, cId);
            columnReferences.add(columnReference);
        }
        String name = this.normalizationSession.getNormalizedColumnName();
        String value = this.normalizationSession.getValueColumnName();
        ImmutableLocalizedText nameText = new ImmutableLocalizedText(name);
        ImmutableLocalizedText valueText = new ImmutableLocalizedText(value);
        OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.Normalize.toString(), this.service);
        map.put("to_normalize", columnReferences);
        map.put("norm_label", nameText);
        map.put("quant_label", valueText);
        invocation = new OperationExecution(operationDefinition.getOperationId(), map);
        this.operationExecutionSpec.setOp(invocation);
    }
}

