/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.util.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.util.io.FileUtil;
import org.sdmxsource.util.io.StreamUtil;
import org.sdmxsource.util.io.URLUtil;

public class InMemoryReadableDataLocation
implements ReadableDataLocation {
    private static final long serialVersionUID = 971633373372917354L;
    private byte[] bytes;
    private String name;

    public InMemoryReadableDataLocation(byte[] bytes) {
        this(bytes, null);
    }

    public InMemoryReadableDataLocation(byte[] bytes, String name) {
        this.bytes = bytes;
        this.name = name;
    }

    public InMemoryReadableDataLocation(String uriStr) {
        if (uriStr == null) {
            throw new IllegalArgumentException("Can not create StreamSourceData - uriStr can not be null");
        }
        this.name = uriStr;
        try {
            URI uri = new URI(uriStr);
            if (uri.isAbsolute()) {
                if (!uri.getScheme().equals("file")) {
                    URL url = uri.toURL();
                    this.bytes = StreamUtil.toByteArray(URLUtil.getInputStream(url));
                } else {
                    this.bytes = FileUtil.readFileAsString(uri.getPath()).getBytes();
                }
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    public void close() {
        this.bytes = null;
    }
}

