/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.manager.impl;

import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.engine.SchemaWriterEngine;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.factory.SchemaWriterFactory;
import org.sdmxsource.sdmx.api.manager.output.SchemaWriterManager;
import org.sdmxsource.sdmx.api.model.format.SchemaFormat;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataStructureSuperBean;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class SchemaWriterManagerImpl
implements SchemaWriterManager,
ApplicationContextAware {
    private static Logger LOG = Logger.getLogger(SchemaWriterManagerImpl.class);
    private ApplicationContext applicationContext;

    public void generateSchema(OutputStream out, DataStructureSuperBean dsd, SchemaFormat outputFormat, String targetNamespace, Map<String, Set<String>> constraintsMap) {
        this.getSchemaWritingEngine(outputFormat).generateSchema(out, dsd, targetNamespace, constraintsMap);
    }

    public void generateCrossSectionalSchema(OutputStream out, DataStructureSuperBean dsd, SchemaFormat outputFormat, String targetNamespace, String crossSectionalDimensionId, Map<String, Set<String>> constraintsMap) {
        this.getSchemaWritingEngine(outputFormat).generateCrossSectionalSchema(out, dsd, targetNamespace, crossSectionalDimensionId, constraintsMap);
    }

    private SchemaWriterEngine getSchemaWritingEngine(SchemaFormat outputFormat) {
        for (SchemaWriterFactory factory : this.applicationContext.getBeansOfType(SchemaWriterFactory.class).values()) {
            SchemaWriterEngine engine = factory.getSchemaWriterEngine(outputFormat);
            if (engine == null) continue;
            return engine;
        }
        throw new SdmxNotImplementedException("Could not write schema out in format: " + outputFormat);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

