/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdwx.shared.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.portlets.user.tdwx.shared.model.ColumnDefinition;
import org.gcube.portlets.user.tdwx.shared.model.ColumnKey;
import org.gcube.portlets.user.tdwx.shared.model.TableId;

public class TableDefinition
implements Serializable {
    private static final long serialVersionUID = 6278293464659249512L;
    public static final String DEFAULT_JSON_ROWS_FIELD = "rows";
    public static final String DEFAULT_JSON_TOTAL_LENGTH_FIELD = "total";
    public static final String DEFAULT_JSON_OFFSET_FIELD = "offset";
    protected TableId id;
    protected String name;
    protected String jsonRowsField;
    protected String jsonTotalLengthField;
    protected String jsonOffsetField;
    protected String modelKeyColumnId;
    protected Map<String, ColumnDefinition> columns;
    protected List<ColumnKey> keys;
    protected int keySeed = 0;

    public TableDefinition() {
    }

    public TableDefinition(TableId id, String name) {
        this.id = id;
        this.name = name;
        this.jsonRowsField = DEFAULT_JSON_ROWS_FIELD;
        this.jsonTotalLengthField = DEFAULT_JSON_TOTAL_LENGTH_FIELD;
        this.jsonOffsetField = DEFAULT_JSON_OFFSET_FIELD;
        this.columns = new HashMap<String, ColumnDefinition>();
        this.keys = new ArrayList<ColumnKey>();
    }

    public TableDefinition(TableId id, String name, String jsonRowsField, String jsonTotalLengthField, String jsonOffsetField) {
        this(id, name);
        this.jsonRowsField = jsonRowsField;
        this.jsonTotalLengthField = jsonTotalLengthField;
        this.jsonOffsetField = jsonOffsetField;
    }

    public TableDefinition(TableId id, String name, String jsonRowsField, String jsonTotalLengthField, String jsonOffsetField, Map<String, ColumnDefinition> columns) {
        this(id, name, jsonRowsField, jsonTotalLengthField, jsonOffsetField);
        for (ColumnDefinition column : columns.values()) {
            this.addColumn(column);
        }
    }

    public TableDefinition(TableId id, String name, String jsonRowsField, String jsonTotalLengthField, String jsonOffsetField, List<ColumnDefinition> columns) {
        this(id, name, jsonRowsField, jsonTotalLengthField, jsonOffsetField);
        this.columns = new HashMap<String, ColumnDefinition>();
        this.keys = new ArrayList<ColumnKey>(columns.size());
        for (ColumnDefinition column : columns) {
            this.addColumn(column);
        }
    }

    public TableId getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getJsonRowsField() {
        return this.jsonRowsField;
    }

    public void setJsonRowsField(String jsonRowsField) {
        this.jsonRowsField = jsonRowsField;
    }

    public String getJsonTotalLengthField() {
        return this.jsonTotalLengthField;
    }

    public void setJsonTotalLengthField(String jsonTotalLengthField) {
        this.jsonTotalLengthField = jsonTotalLengthField;
    }

    public String getJsonOffsetField() {
        return this.jsonOffsetField;
    }

    public void setJsonOffsetField(String jsonOffsetField) {
        this.jsonOffsetField = jsonOffsetField;
    }

    public ColumnDefinition getModelKeyColumn() {
        return this.columns.get(this.modelKeyColumnId);
    }

    public void setModelKeyColumnId(String modelKeyColumnId) {
        this.modelKeyColumnId = modelKeyColumnId;
    }

    public Map<String, ColumnDefinition> getColumns() {
        return this.columns;
    }

    public List<ColumnDefinition> getColumnsAsList() {
        return new ArrayList<ColumnDefinition>(this.columns.values());
    }

    public void addColumn(ColumnDefinition column) {
        this.columns.put(column.getId(), column);
        column.setIndex(this.keySeed++);
        this.keys.add(column.getKey());
    }

    public List<ColumnKey> getKeys() {
        return this.keys;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TableDefinition [id=");
        builder.append(this.id);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", jsonRowsField=");
        builder.append(this.jsonRowsField);
        builder.append(", jsonOffsetField=");
        builder.append(this.jsonOffsetField);
        builder.append(", jsonTotalLengthField=");
        builder.append(this.jsonTotalLengthField);
        builder.append(", modelKeyColumnId=");
        builder.append(this.modelKeyColumnId);
        builder.append(", columns=");
        builder.append(this.columns);
        builder.append("]");
        return builder.toString();
    }
}

