/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.metadata.column;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.Validation;

@XmlRootElement(name="DataValidationMetadata")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DataValidationMetadata
implements ColumnMetadata {
    private static final long serialVersionUID = 5346249544710409540L;
    private Validation validation;
    private int invalidRowsCount;

    private DataValidationMetadata() {
    }

    public DataValidationMetadata(Validation validation, int invalidCount) {
        if (validation.isValid() && invalidCount > 0 || !validation.isValid() && invalidCount == 0) {
            throw new IllegalArgumentException("Validation flag and invalidCount are not coherent");
        }
        this.validation = validation;
        this.invalidRowsCount = invalidCount;
    }

    public boolean isValid() {
        return this.validation.isValid();
    }

    public String getDescription() {
        return this.validation.getDescription();
    }

    public int getConditionId() {
        return this.validation.getConditionId();
    }

    public int getInvalidRowsCount() {
        return this.invalidRowsCount;
    }

    @Override
    public boolean isInheritable() {
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.invalidRowsCount;
        result = 31 * result + (this.validation == null ? 0 : this.validation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataValidationMetadata other = (DataValidationMetadata)obj;
        if (this.invalidRowsCount != other.invalidRowsCount) {
            return false;
        }
        return !(this.validation == null ? other.validation != null : !this.validation.equals(other.validation));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DataValidationMetadata [validation=");
        builder.append(this.validation);
        builder.append(", invalidRowsCount=");
        builder.append(this.invalidRowsCount);
        builder.append("]");
        return builder.toString();
    }
}

