/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.parameters.leaves;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class IntegerParameter
extends LeafParameter<Integer> {
    private Integer min = Integer.MIN_VALUE;
    private Integer max = Integer.MAX_VALUE;

    @Override
    public Class<Integer> getParameterType() {
        return Integer.class;
    }

    private IntegerParameter() {
    }

    public IntegerParameter(String identifier, String name, String description, Cardinality cardinality) {
        super(identifier, name, description, cardinality);
    }

    public IntegerParameter(String identifier, String name, String description, Cardinality cardinality, Integer min, Integer max) {
        super(identifier, name, description, cardinality);
        this.min = min;
        this.max = max;
    }

    public Integer getMin() {
        return this.min;
    }

    public Integer getMax() {
        return this.max;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IntegerParameter [min=");
        builder.append(this.min);
        builder.append(", max=");
        builder.append(this.max);
        builder.append(", getIdentifier()=");
        builder.append(this.getIdentifier());
        builder.append(", getName()=");
        builder.append(this.getName());
        builder.append(", getDescription()=");
        builder.append(this.getDescription());
        builder.append(", getCardinality()=");
        builder.append(this.getCardinality());
        builder.append("]");
        return builder.toString();
    }

    @Override
    public void validateValue(Object valueObj) throws Exception {
        super.validateValue(valueObj);
        Integer value = (Integer)valueObj;
        if (value < this.min || value > this.max) {
            throw new Exception(String.format("Passed argument %s is not in allowed range %s..%s", value, this.min, this.max));
        }
    }
}

