/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.parameters.leaves;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetViewTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.GenericTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.HierarchicalCodelistTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.TimeCodelistTableType;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TargetTableParameter
extends LeafParameter<TableId> {
    private static final List<TableType> DEFAULT_ALLOWED_TABLE_TYPES = new ArrayList<TableType>();
    private List<TableType> allowedTableTypes = null;

    private TargetTableParameter() {
    }

    public TargetTableParameter(String identifier, String name, String description, Cardinality cardinality, List<TableType> allowedTableTypes) {
        super(identifier, name, description, cardinality);
        this.allowedTableTypes = allowedTableTypes;
    }

    public TargetTableParameter(String identifier, String name, String description, Cardinality cardinality) {
        this(identifier, name, description, cardinality, DEFAULT_ALLOWED_TABLE_TYPES);
    }

    public List<TableType> getAllowedTableTypes() {
        return this.allowedTableTypes;
    }

    @Override
    public Class<TableId> getParameterType() {
        return TableId.class;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.allowedTableTypes == null ? 0 : this.allowedTableTypes.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TargetTableParameter other = (TargetTableParameter)obj;
        return !(this.allowedTableTypes == null ? other.allowedTableTypes != null : !this.allowedTableTypes.equals(other.allowedTableTypes));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TargetTableParameter [getIdentifier()=");
        builder.append(this.getIdentifier());
        builder.append(", getName()=");
        builder.append(this.getName());
        builder.append(", getDescription()=");
        builder.append(this.getDescription());
        builder.append(", getCardinality()=");
        builder.append(this.getCardinality());
        builder.append(", getAllowedTableTypes()=");
        builder.append(this.getAllowedTableTypes());
        builder.append(", getParameterType()=");
        builder.append(this.getParameterType());
        builder.append("]");
        return builder.toString();
    }

    static {
        DEFAULT_ALLOWED_TABLE_TYPES.add((TableType)new CodelistTableType());
        DEFAULT_ALLOWED_TABLE_TYPES.add((TableType)new DatasetTableType());
        DEFAULT_ALLOWED_TABLE_TYPES.add((TableType)new DatasetViewTableType());
        DEFAULT_ALLOWED_TABLE_TYPES.add((TableType)new GenericTableType());
        DEFAULT_ALLOWED_TABLE_TYPES.add((TableType)new HierarchicalCodelistTableType());
        DEFAULT_ALLOWED_TABLE_TYPES.add((TableType)new TimeCodelistTableType());
    }
}

