/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.superbeans.base;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotableBean;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotationBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.superbeans.base.AnnotableSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.base.AnnotationSuperBean;
import org.sdmxsource.sdmx.sdmxbeans.model.superbeans.base.AnnotationSuperBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.superbeans.base.SuperBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public abstract class AnnotableSuperBeanImpl
extends SuperBeanImpl
implements AnnotableSuperBean {
    private static final long serialVersionUID = 1L;
    private Set<AnnotationSuperBean> annotations = new HashSet<AnnotationSuperBean>();
    private Map<String, AnnotationSuperBean> annotationByType = new HashMap<String, AnnotationSuperBean>();

    public AnnotableSuperBeanImpl(AnnotableBean annotableType) {
        super((SDMXBean)annotableType);
        if (annotableType != null && annotableType.getAnnotations() != null) {
            for (AnnotationBean currentAnnotation : annotableType.getAnnotations()) {
                AnnotationSuperBeanImpl annotation = new AnnotationSuperBeanImpl(currentAnnotation);
                this.annotations.add(annotation);
                if (!ObjectUtil.validString((String[])new String[]{annotation.getType()})) continue;
                this.annotationByType.put(annotation.getType(), annotation);
            }
        }
    }

    public Set<AnnotationSuperBean> getAnnotationByTitle(String title) {
        HashSet<AnnotationSuperBean> returnSet = new HashSet<AnnotationSuperBean>();
        if (this.hasAnnotations()) {
            for (AnnotationSuperBean currentAnnotation : this.annotations) {
                if (currentAnnotation.getTitle() == null || !currentAnnotation.getTitle().equals(title)) continue;
                returnSet.add(currentAnnotation);
            }
        }
        return returnSet;
    }

    public AnnotationSuperBean getAnnotationByType(String type) {
        return this.annotationByType.get(type);
    }

    public Set<AnnotationSuperBean> getAnnotationByUrl(String url) {
        HashSet<AnnotationSuperBean> returnSet = new HashSet<AnnotationSuperBean>();
        if (this.hasAnnotations()) {
            for (AnnotationSuperBean currentAnnotation : this.annotations) {
                if (currentAnnotation.getUri() == null || !currentAnnotation.getUri().toString().equals(url)) continue;
                returnSet.add(currentAnnotation);
            }
        }
        return returnSet;
    }

    public Set<AnnotationSuperBean> getAnnotations() {
        return new HashSet<AnnotationSuperBean>(this.annotations);
    }

    public boolean hasAnnotations() {
        return this.annotations != null && this.annotations.size() > 0;
    }
}

