/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.superbeans.impl;

import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.exception.CrossReferenceException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.superbeans.SuperBeans;
import org.sdmxsource.sdmx.api.model.superbeans.codelist.CodelistSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.conceptscheme.ConceptSuperBean;
import org.sdmxsource.sdmx.sdmxbeans.model.superbeans.conceptscheme.ConceptSuperBeanImpl;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.CodelistSuperBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.ComponentSuperBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.superbeans.impl.StructureBuilderImpl;
import org.sdmxsource.sdmx.structureretrieval.manager.InMemorySdmxSuperBeanRetrievalManager;
import org.sdmxsource.sdmx.util.beans.container.SuperBeansImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConceptSuperBeanBuilder
extends StructureBuilderImpl<ConceptSuperBean, ConceptBean> {
    private static final Logger LOG = Logger.getLogger(ComponentSuperBeanBuilder.class);
    @Autowired
    private CodelistSuperBeanBuilder codelistSuperBeanBuilder;

    public ConceptSuperBean build(ConceptBean buildFrom, SdmxBeanRetrievalManager retrievalManager, SuperBeans existingBeans) {
        if (existingBeans == null) {
            existingBeans = new SuperBeansImpl();
        }
        InMemorySdmxSuperBeanRetrievalManager superBeanRetrievalManager = new InMemorySdmxSuperBeanRetrievalManager(existingBeans);
        CodelistSuperBean codelistSuperBean = null;
        if (buildFrom.getCoreRepresentation() != null && buildFrom.getCoreRepresentation().getRepresentation() != null) {
            MaintainableRefBean codelistRef = buildFrom.getCoreRepresentation().getRepresentation().getMaintainableReference();
            LOG.debug((Object)("get codelist super bean : " + codelistRef));
            codelistSuperBean = superBeanRetrievalManager.getCodelistSuperBean(codelistRef);
            if (codelistSuperBean == null) {
                LOG.debug((Object)("no existing super bean found build new : " + codelistRef));
                CodelistBean codelist = (CodelistBean)retrievalManager.getMaintainableBean(CodelistBean.class, codelistRef);
                if (codelist == null) {
                    throw new CrossReferenceException(buildFrom.getCoreRepresentation().getRepresentation());
                }
                codelistSuperBean = this.codelistSuperBeanBuilder.build(codelist);
                LOG.debug((Object)"codelist super bean built");
                existingBeans.addCodelist(codelistSuperBean);
            }
        }
        return new ConceptSuperBeanImpl(buildFrom, codelistSuperBean);
    }

    public void setCodelistSuperBeanBuilder(CodelistSuperBeanBuilder codelistSuperBeanBuilder) {
        this.codelistSuperBeanBuilder = codelistSuperBeanBuilder;
    }
}

