/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl;

import org.apache.xmlbeans.XmlObject;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.message.StructureDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.ErrorDocument;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_ERROR_CODE;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.XmlBeanBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.QueryStructureResponseBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v2.QueryStructureResponseBuilderV2;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v21.ErrorResponseBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v1.StructureXmlBeanBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryStructureResponseBuilderImpl
extends XmlBeanBuilder
implements QueryStructureResponseBuilder {
    @Autowired
    private QueryStructureResponseBuilderV2 v2Builder;
    @Autowired
    private org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.StructureXmlBeanBuilder structv2Builder;
    @Autowired
    private StructureXmlBeanBuilder structv1Builder;
    @Autowired
    private org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.StructureXmlBeanBuilder structV2_1Builder;
    @Autowired
    private ErrorResponseBuilder errorResponseBuilder2_1;

    @Override
    public XmlObject buildErrorResponse(Throwable th, SDMX_SCHEMA schemaVersion) {
        ErrorDocument response = null;
        switch (schemaVersion) {
            case VERSION_TWO_POINT_ONE: {
                response = this.errorResponseBuilder2_1.buildErrorResponse(th);
                break;
            }
            case VERSION_TWO: {
                response = this.v2Builder.buildErrorResponse(th);
                break;
            }
            default: {
                throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{schemaVersion});
            }
        }
        super.writeSchemaLocation((XmlObject)response, schemaVersion);
        return response;
    }

    @Override
    public XmlObject buildSuccessResponse(SdmxBeans beans, SDMX_SCHEMA schemaVersion, boolean returnAsStructureMessage) {
        StructureDocument response = null;
        switch (schemaVersion) {
            case VERSION_TWO_POINT_ONE: {
                if (beans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]).size() == 0) {
                    response = this.errorResponseBuilder2_1.buildErrorResponse(SDMX_ERROR_CODE.NO_RESULTS_FOUND);
                    break;
                }
                response = this.structV2_1Builder.build(beans);
                break;
            }
            case VERSION_TWO: {
                if (returnAsStructureMessage) {
                    response = this.structv2Builder.build(beans);
                    break;
                }
                response = this.v2Builder.buildSuccessResponse(beans);
                break;
            }
            case VERSION_ONE: {
                response = this.structv1Builder.build(beans);
                break;
            }
            default: {
                throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{schemaVersion});
            }
        }
        super.writeSchemaLocation((XmlObject)response, schemaVersion);
        return response;
    }
}

