/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.workspace.impl;

import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.sdmxsource.sdmx.api.builder.SuperBeansBuilder;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.constants.STRUCTURE_OUTPUT_FORMAT;
import org.sdmxsource.sdmx.api.manager.output.StructureWriterManager;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.StructureWorkspace;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.format.StructureFormat;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.api.model.superbeans.SuperBeans;
import org.sdmxsource.sdmx.sdmxbeans.model.SdmxStructureFormat;
import org.sdmxsource.sdmx.structureretrieval.engine.impl.CrossReferenceResolverEngineImpl;
import org.sdmxsource.sdmx.util.beans.MaintainableUtil;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.aspectj.AbstractDependencyInjectionAspect;
import org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect;
import org.springframework.beans.factory.aspectj.ConfigurableObject;

@Configurable(preConstruction=true)
public class StructureWorkspaceImpl
implements StructureWorkspace,
ConfigurableObject {
    @Autowired
    private SuperBeansBuilder superBeansBuilder;
    @Autowired
    private StructureWriterManager structureWritingManager;
    private HeaderBean header;
    private SdmxBeans beans;
    private Map<IdentifiableBean, Set<IdentifiableBean>> crossReferencedBeans;
    private SdmxBeans allBeans;
    private SuperBeans superBeans;
    private SdmxBeanRetrievalManager retrievalManager;
    private boolean retrieveCrossRefefences;
    private boolean retrieveAgencies;
    private int resolutionDepth;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    private StructureWorkspaceImpl(SdmxBeans beans, Map<IdentifiableBean, Set<IdentifiableBean>> crossReferencedBeans) {
        SdmxBeans sdmxBeans = beans;
        Map<IdentifiableBean, Set<IdentifiableBean>> map = crossReferencedBeans;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, this, this, sdmxBeans, map);
        JoinPoint joinPoint2 = Factory.makeJP(ajc$tjp_0, this, this);
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && AnnotationBeanConfigurerAspect.ajc$if$bb0(this.getClass().getAnnotation(Configurable.class))) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$before$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$1$e854fa65(this);
        }
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && (this == null || !this.getClass().isAnnotationPresent(Configurable.class) || !AnnotationBeanConfigurerAspect.ajc$if$bb0(this.getClass().getAnnotation(Configurable.class))) && AbstractDependencyInjectionAspect.ajc$if$6f1(joinPoint2)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c(this);
        }
        if (beans == null) {
            throw new IllegalArgumentException("Cannot instantiate a StructureWorkspace with beans as a null reference.");
        }
        this.beans = beans;
        this.crossReferencedBeans = crossReferencedBeans;
        this.init();
        if (!AnnotationBeanConfigurerAspect.ajc$if$bb0(this.getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1(joinPoint)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    public StructureWorkspaceImpl(SdmxBeans beans) {
        void resolutionDepth;
        void retrieveAgencies;
        void retrieveCrossRefefences;
        void retrievalManager;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Object var4_5 = null;
        SdmxBeans beans2 = beans;
        StructureWorkspaceImpl ajc$aspectInstance = this;
        SdmxBeans sdmxBeans = beans;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_3, (Object)this, (Object)this, sdmxBeans);
        JoinPoint joinPoint2 = Factory.makeJP(ajc$tjp_1, ajc$aspectInstance, ajc$aspectInstance);
        if (ajc$aspectInstance != null && ajc$aspectInstance.getClass().isAnnotationPresent(Configurable.class) && AnnotationBeanConfigurerAspect.ajc$if$bb0(ajc$aspectInstance.getClass().getAnnotation(Configurable.class))) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$before$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$1$e854fa65(ajc$aspectInstance);
        }
        if (ajc$aspectInstance != null && ajc$aspectInstance.getClass().isAnnotationPresent(Configurable.class) && (ajc$aspectInstance == null || !ajc$aspectInstance.getClass().isAnnotationPresent(Configurable.class) || !AnnotationBeanConfigurerAspect.ajc$if$bb0(ajc$aspectInstance.getClass().getAnnotation(Configurable.class))) && AbstractDependencyInjectionAspect.ajc$if$6f1(joinPoint2)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c(ajc$aspectInstance);
        }
        if (beans2 == null) {
            throw new IllegalArgumentException("Cannot instantiate a StructureWorkspace with beans as a null reference.");
        }
        ajc$aspectInstance.beans = beans2;
        ajc$aspectInstance.retrievalManager = retrievalManager;
        ajc$aspectInstance.retrieveCrossRefefences = retrieveCrossRefefences;
        ajc$aspectInstance.retrieveAgencies = retrieveAgencies;
        ajc$aspectInstance.resolutionDepth = resolutionDepth;
        ajc$aspectInstance.init();
        if (!AnnotationBeanConfigurerAspect.ajc$if$bb0(this.getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1(joinPoint)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c(this);
        }
    }

    public StructureWorkspaceImpl(SdmxBeans beans, SdmxBeanRetrievalManager retrievalManager, boolean retrieveCrossRefefences, boolean retrieveAgencies, int resolutionDepth) {
        SdmxBeans sdmxBeans = beans;
        SdmxBeanRetrievalManager sdmxBeanRetrievalManager = retrievalManager;
        boolean bl = retrieveCrossRefefences;
        boolean bl2 = retrieveAgencies;
        int n = resolutionDepth;
        Object[] objectArray = new Object[]{sdmxBeans, sdmxBeanRetrievalManager, Conversions.booleanObject(bl), Conversions.booleanObject(bl2), Conversions.intObject(n)};
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_4, (Object)this, (Object)this, objectArray);
        JoinPoint joinPoint2 = Factory.makeJP(ajc$tjp_1, this, this);
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && AnnotationBeanConfigurerAspect.ajc$if$bb0(this.getClass().getAnnotation(Configurable.class))) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$before$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$1$e854fa65(this);
        }
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && (this == null || !this.getClass().isAnnotationPresent(Configurable.class) || !AnnotationBeanConfigurerAspect.ajc$if$bb0(this.getClass().getAnnotation(Configurable.class))) && AbstractDependencyInjectionAspect.ajc$if$6f1(joinPoint2)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c(this);
        }
        if (beans == null) {
            throw new IllegalArgumentException("Cannot instantiate a StructureWorkspace with beans as a null reference.");
        }
        this.beans = beans;
        this.retrievalManager = retrievalManager;
        this.retrieveCrossRefefences = retrieveCrossRefefences;
        this.retrieveAgencies = retrieveAgencies;
        this.resolutionDepth = resolutionDepth;
        this.init();
        if (!AnnotationBeanConfigurerAspect.ajc$if$bb0(this.getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1(joinPoint)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c(this);
        }
    }

    public void writeStructures(SDMX_SCHEMA structureType, OutputStream out, boolean includeCrossReferences) {
        STRUCTURE_OUTPUT_FORMAT outputFormat = null;
        switch (structureType) {
            case CSV: {
                outputFormat = STRUCTURE_OUTPUT_FORMAT.CSV;
                break;
            }
            case EDI: {
                outputFormat = STRUCTURE_OUTPUT_FORMAT.EDI;
                break;
            }
            case VERSION_ONE: {
                outputFormat = STRUCTURE_OUTPUT_FORMAT.SDMX_V1_STRUCTURE_DOCUMENT;
                break;
            }
            case VERSION_TWO: {
                outputFormat = STRUCTURE_OUTPUT_FORMAT.SDMX_V2_STRUCTURE_DOCUMENT;
                break;
            }
            case VERSION_TWO_POINT_ONE: {
                outputFormat = STRUCTURE_OUTPUT_FORMAT.SDMX_V21_STRUCTURE_DOCUMENT;
            }
        }
        if (includeCrossReferences) {
            this.structureWritingManager.writeStructures(this.allBeans, (StructureFormat)new SdmxStructureFormat(outputFormat), out);
        } else {
            this.structureWritingManager.writeStructures(this.beans, (StructureFormat)new SdmxStructureFormat(outputFormat), out);
        }
    }

    private void init() {
        if (this.superBeansBuilder == null) {
            throw new RuntimeException("Required dependancy 'superBeansBuilder' is null, StructureWorkspaceImpl is @Configurable and requires '<context:spring-configured />' to be set, and aspectJ to be on");
        }
        if (this.structureWritingManager == null) {
            throw new RuntimeException("Required dependancy 'structureWritingManager' is null, StructureWorkspaceImpl is @Configurable and requires '<context:spring-configured />' to be set");
        }
        if (this.retrieveCrossRefefences) {
            CrossReferenceResolverEngineImpl crossRefResolver = new CrossReferenceResolverEngineImpl();
            this.crossReferencedBeans = crossRefResolver.resolveReferences(this.beans, this.retrieveAgencies, this.resolutionDepth, this.retrievalManager);
        }
        this.allBeans = new SdmxBeansImpl(new SdmxBeans[]{this.beans});
        if (this.crossReferencedBeans != null) {
            for (Set<IdentifiableBean> currentBeanSet : this.crossReferencedBeans.values()) {
                for (IdentifiableBean currentBean : currentBeanSet) {
                    this.allBeans.addIdentifiable(currentBean);
                }
            }
        }
    }

    public HeaderBean getHeader() {
        return this.header;
    }

    public Map<IdentifiableBean, Set<IdentifiableBean>> getCrossReferences() {
        return this.crossReferencedBeans;
    }

    public SdmxBeans getStructureBeans(boolean includeCrossReferences) {
        if (includeCrossReferences && this.crossReferencedBeans != null) {
            return this.allBeans;
        }
        return this.beans;
    }

    public SuperBeans getSuperBeans() {
        if (this.superBeans == null) {
            this.superBeans = (SuperBeans)this.superBeansBuilder.build((Object)this.allBeans);
        }
        return this.superBeans;
    }

    public StructureWorkspace getSubsetWorkspace(StructureReferenceBean ... query) {
        HashSet maintainablesSubset = new HashSet();
        HashMap<IdentifiableBean, Set<IdentifiableBean>> crossReferencedSubset = new HashMap<IdentifiableBean, Set<IdentifiableBean>>();
        int i = 0;
        while (i < query.length) {
            StructureReferenceBean currentQuery = query[i];
            Set maintainableForStructure = this.beans.getMaintainables(currentQuery.getMaintainableStructureType());
            Set maintainableMatches = MaintainableUtil.findMatches((Collection)maintainableForStructure, (StructureReferenceBean)currentQuery);
            maintainablesSubset.addAll(maintainableMatches);
            for (MaintainableBean currentMatch : maintainableMatches) {
                HashSet identifiables;
                Set<Object> set = identifiables = this.crossReferencedBeans == null ? new HashSet() : this.crossReferencedBeans.get(currentMatch);
                if (identifiables == null) continue;
                crossReferencedSubset.put((IdentifiableBean)currentMatch, identifiables);
            }
            ++i;
        }
        SdmxBeansImpl beansSubset = new SdmxBeansImpl(this.beans.getHeader(), maintainablesSubset);
        return new StructureWorkspaceImpl((SdmxBeans)beansSubset, crossReferencedSubset);
    }

    public void mergeWorkspace(StructureWorkspace workspace) {
        this.allBeans = new SdmxBeansImpl(new SdmxBeans[]{this.allBeans, workspace.getStructureBeans(true)});
        this.beans = new SdmxBeansImpl(new SdmxBeans[]{this.beans, workspace.getStructureBeans(false)});
        this.superBeans = null;
        Map localCrossReferencedBeans = workspace.getCrossReferences();
        if (localCrossReferencedBeans != null) {
            for (IdentifiableBean currentKey : localCrossReferencedBeans.keySet()) {
                Set<Object> currentSet = null;
                if (this.crossReferencedBeans.containsKey(currentKey)) {
                    currentSet = this.crossReferencedBeans.get(currentKey);
                } else {
                    currentSet = new HashSet();
                    this.crossReferencedBeans.put(currentKey, currentSet);
                }
                currentSet.addAll((Collection)localCrossReferencedBeans.get(currentKey));
            }
        }
    }

    static {
        StructureWorkspaceImpl.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("StructureWorkspaceImpl.java", StructureWorkspaceImpl.class);
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.springframework.beans.factory.aspectj.ConfigurableObject", "", "", ""), 80);
        ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.springframework.beans.factory.aspectj.ConfigurableObject", "", "", ""), 104);
        ajc$tjp_2 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("2", "org.sdmxsource.sdmx.structureparser.workspace.impl.StructureWorkspaceImpl", "org.sdmxsource.sdmx.api.model.beans.SdmxBeans:java.util.Map", "beans:crossReferencedBeans", ""), 80);
        ajc$tjp_3 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.sdmxsource.sdmx.structureparser.workspace.impl.StructureWorkspaceImpl", "org.sdmxsource.sdmx.api.model.beans.SdmxBeans", "beans", ""), 94);
        ajc$tjp_4 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.sdmxsource.sdmx.structureparser.workspace.impl.StructureWorkspaceImpl", "org.sdmxsource.sdmx.api.model.beans.SdmxBeans:org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager:boolean:boolean:int", "beans:retrievalManager:retrieveCrossRefefences:retrieveAgencies:resolutionDepth", ""), 104);
    }
}

