/*
 * Decompiled with CFR 0.152.
 */
package net.sf.csv4j;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sf.csv4j.AbstractLineToFieldMapAdapter;
import net.sf.csv4j.CSVLineProcessor;
import net.sf.csv4j.CSVSortedFieldMapProcessor;

class LineToSortedFieldMapAdapter
extends AbstractLineToFieldMapAdapter
implements CSVLineProcessor {
    private final CSVSortedFieldMapProcessor processor;
    private Comparator<String> comparator;

    public LineToSortedFieldMapAdapter(CSVSortedFieldMapProcessor processor) {
        this.processor = processor;
    }

    @Override
    public void processHeaderLine(int linenumber, List<String> fieldNames) {
        super.processHeaderLine(linenumber, fieldNames);
        this.comparator = new FieldOrderComparator(this.header);
    }

    @Override
    public boolean continueProcessing() {
        return this.processor.continueProcessing();
    }

    @Override
    protected Map<String, String> createMap() {
        return new TreeMap<String, String>(this.comparator);
    }

    @Override
    protected void processDataLine(int lineNumber, Map<String, String> fields) {
        this.processor.processDataLine(lineNumber, (SortedMap)fields);
    }

    static class FieldOrderComparator
    implements Comparator<String> {
        private final Map<String, Integer> fieldMap;

        public FieldOrderComparator(List<String> fields) {
            this.fieldMap = new HashMap<String, Integer>(fields.size());
            int pos = 0;
            for (String field : fields) {
                this.fieldMap.put(field, pos);
                ++pos;
            }
        }

        @Override
        public int compare(String fieldName1, String fieldName2) {
            Integer pos2;
            if (fieldName1.equals(fieldName2)) {
                return 0;
            }
            Integer pos1 = this.fieldMap.get(fieldName1);
            if (pos1 == (pos2 = this.fieldMap.get(fieldName2))) {
                return 0;
            }
            if (pos1 == null) {
                return 1;
            }
            if (pos2 == null) {
                return -1;
            }
            if (pos1 < pos2) {
                return -1;
            }
            if (pos1 > pos2) {
                return 1;
            }
            return 0;
        }
    }
}

