/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.querybuilder.builder;

import org.sdmxsource.sdmx.api.builder.StructureQueryBuilder;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.query.RESTStructureQuery;
import org.sdmxsource.sdmx.api.model.query.StructureQueryMetadata;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.stereotype.Service;

@Service
public class StructureQueryBuilderRest
implements StructureQueryBuilder<String> {
    public String buildStructureQuery(RESTStructureQuery sQuery) {
        if (sQuery == null) {
            throw new IllegalArgumentException("StructureQueryBuilderRest.buildStructureQuery StructureQuery is required, null was passed");
        }
        String returnUrl = "";
        StructureReferenceBean sRef = sQuery.getStructureReference();
        returnUrl = sRef.getMaintainableStructureType() == SDMX_STRUCTURE_TYPE.ANY ? returnUrl + "structure/" : returnUrl + sRef.getMaintainableStructureType().getUrnClass() + "/";
        MaintainableRefBean mRef = sRef.getMaintainableReference();
        returnUrl = ObjectUtil.validString((String[])new String[]{mRef.getAgencyId()}) ? returnUrl + mRef.getAgencyId() + "/" : returnUrl + "ALL/";
        returnUrl = ObjectUtil.validString((String[])new String[]{mRef.getMaintainableId()}) ? returnUrl + mRef.getMaintainableId() + "/" : returnUrl + "ALL/";
        StructureQueryMetadata sQueryMetadata = sQuery.getStructureQueryMetadata();
        returnUrl = sQueryMetadata.isReturnLatest() ? returnUrl + "LATEST/" : (ObjectUtil.validString((String[])new String[]{mRef.getVersion()}) ? returnUrl + mRef.getVersion() + "/" : returnUrl + "ALL/");
        String concat = "?";
        if (sQueryMetadata.getSpecificStructureReference() != null) {
            returnUrl = returnUrl + concat + "references=" + sQueryMetadata.getSpecificStructureReference().getUrnClass().toLowerCase();
            concat = "&";
        } else if (sQueryMetadata.getStructureReferenceDetail() != null) {
            returnUrl = returnUrl + concat + "references=" + sQueryMetadata.getStructureReferenceDetail().toString();
            concat = "&";
        }
        if (sQueryMetadata.getStructureQueryDetail() != null) {
            returnUrl = returnUrl + concat + "detail=" + sQueryMetadata.getStructureQueryDetail().toString();
            concat = "&";
        }
        return returnUrl;
    }
}

