/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v2;

import java.util.Set;
import org.sdmx.resources.sdmxml.schemas.v20.common.TextType;
import org.sdmx.resources.sdmxml.schemas.v20.message.HeaderType;
import org.sdmx.resources.sdmxml.schemas.v20.message.RegistryInterfaceDocument;
import org.sdmx.resources.sdmxml.schemas.v20.message.RegistryInterfaceType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.CategorySchemeRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.CodelistRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.ConceptSchemeRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.DataflowRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.HierarchicalCodelistRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.KeyFamilyRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.MetadataStructureRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.MetadataflowRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.OrganisationSchemeRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.ProcessRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.ReportingTaxonomyRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.StatusMessageType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.StatusType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.StructureSetRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.SubmissionResultType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.SubmitStructureResponseType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.SubmittedStructureType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v2.AbstractResponseBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v2.V2Helper;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.StructureHeaderXmlBeanBuilder;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SubmitStructureResponseBuilderV2
extends AbstractResponseBuilder {
    @Autowired
    private StructureHeaderXmlBeanBuilder headerXmlBeansBuilder;

    private SubmitStructureResponseBuilderV2() {
    }

    public RegistryInterfaceDocument buildErrorResponse(Throwable th, StructureReferenceBean errorBean) throws SdmxException {
        RegistryInterfaceDocument responseType = RegistryInterfaceDocument.Factory.newInstance();
        RegistryInterfaceType regInterface = responseType.addNewRegistryInterface();
        SubmitStructureResponseType returnType = regInterface.addNewSubmitStructureResponse();
        V2Helper.setHeader(regInterface);
        this.processMaintainable(returnType, errorBean, th);
        return responseType;
    }

    public RegistryInterfaceDocument buildSuccessResponse(SdmxBeans beans) throws SdmxException {
        RegistryInterfaceDocument responseType = RegistryInterfaceDocument.Factory.newInstance();
        RegistryInterfaceType regInterface = responseType.addNewRegistryInterface();
        SubmitStructureResponseType returnType = regInterface.addNewSubmitStructureResponse();
        HeaderType headerType = null;
        if (beans.getHeader() != null) {
            headerType = this.headerXmlBeansBuilder.build(beans.getHeader());
            regInterface.setHeader(headerType);
        } else {
            headerType = regInterface.addNewHeader();
            V2Helper.setHeader(headerType, beans);
        }
        this.processMaintainables(returnType, beans.getAllMaintainables(new SDMX_STRUCTURE_TYPE[0]));
        return responseType;
    }

    private void processMaintainables(SubmitStructureResponseType returnType, Set<MaintainableBean> maints) {
        for (MaintainableBean maint : maints) {
            this.processMaintainable(returnType, maint.asReference(), null);
        }
    }

    private void processMaintainable(SubmitStructureResponseType returnType, StructureReferenceBean sRef, Throwable th) {
        if (sRef == null) {
            this.addNewOrganisationSchemeRefSubmissionResult(returnType, sRef, th);
        }
        switch (sRef.getTargetReference()) {
            case AGENCY_SCHEME: {
                this.addNewOrganisationSchemeRefSubmissionResult(returnType, sRef, th);
                break;
            }
            case DATA_PROVIDER_SCHEME: {
                this.addNewOrganisationSchemeRefSubmissionResult(returnType, sRef, th);
                break;
            }
            case DATA_CONSUMER_SCHEME: {
                this.addNewOrganisationSchemeRefSubmissionResult(returnType, sRef, th);
                break;
            }
            case CATEGORY_SCHEME: {
                this.addNewCategorySchemeRefSubmissionResult(returnType, sRef, th);
                break;
            }
            case DATAFLOW: {
                this.addNewDataflowRefSubmissionResult(returnType, sRef, th);
                break;
            }
            case METADATA_FLOW: {
                this.addNewMetadataflowRefSubmissionResult(returnType, sRef, th);
                break;
            }
            case CODE_LIST: {
                this.addNewCodelistRefSubmissionResult(returnType, sRef, th);
                break;
            }
            case HIERARCHICAL_CODELIST: {
                this.addNewHierarchicalCodelistRefSubmissionResult(returnType, sRef, th);
                break;
            }
            case CONCEPT_SCHEME: {
                this.addNewConceptSchemeRefSubmissionResult(returnType, sRef, th);
                break;
            }
            case ORGANISATION_UNIT_SCHEME: {
                this.addNewOrganisationSchemeRefSubmissionResult(returnType, sRef, th);
                break;
            }
            case DSD: {
                this.addNewDataStructureRefSubmissionResult(returnType, sRef, th);
                break;
            }
            case MSD: {
                this.addNewMetadataStructureRefSubmissionResult(returnType, sRef, th);
                break;
            }
            case PROCESS: {
                this.addNewProcessRefSubmissionResult(returnType, sRef, th);
                break;
            }
            case STRUCTURE_SET: {
                this.addNewStructureSetRefSubmissionResult(returnType, sRef, th);
                break;
            }
            case REPORTING_TAXONOMY: {
                this.addNewReportingTaxonomySetRefSubmissionResult(returnType, sRef, th);
            }
        }
    }

    private void addNewReportingTaxonomySetRefSubmissionResult(SubmitStructureResponseType returnType, StructureReferenceBean sRef, Throwable th) {
        SubmissionResultType result = this.getNewSubmissionResultType(returnType, th);
        SubmittedStructureType submittedStructure = result.addNewSubmittedStructure();
        ReportingTaxonomyRefType refType = submittedStructure.addNewReportingTaxonomyRef();
        MaintainableRefBean mRef = sRef.getMaintainableReference();
        refType.setAgencyID(mRef.getAgencyId());
        refType.setReportingTaxonomyID(mRef.getMaintainableId());
        if (ObjectUtil.validString((String[])new String[]{sRef.getMaintainableUrn()})) {
            refType.setURN(sRef.getMaintainableUrn());
        }
        if (ObjectUtil.validString((String[])new String[]{mRef.getVersion()})) {
            refType.setVersion(mRef.getVersion());
        }
    }

    private void addNewStructureSetRefSubmissionResult(SubmitStructureResponseType returnType, StructureReferenceBean sRef, Throwable th) {
        SubmissionResultType result = this.getNewSubmissionResultType(returnType, th);
        SubmittedStructureType submittedStructure = result.addNewSubmittedStructure();
        StructureSetRefType refType = submittedStructure.addNewStructureSetRef();
        MaintainableRefBean mRef = sRef.getMaintainableReference();
        refType.setAgencyID(mRef.getAgencyId());
        refType.setStructureSetID(mRef.getMaintainableId());
        if (ObjectUtil.validString((String[])new String[]{sRef.getMaintainableUrn()})) {
            refType.setURN(sRef.getMaintainableUrn());
        }
        if (ObjectUtil.validString((String[])new String[]{mRef.getVersion()})) {
            refType.setVersion(mRef.getVersion());
        }
    }

    private void addNewProcessRefSubmissionResult(SubmitStructureResponseType returnType, StructureReferenceBean sRef, Throwable th) {
        SubmissionResultType result = this.getNewSubmissionResultType(returnType, th);
        SubmittedStructureType submittedStructure = result.addNewSubmittedStructure();
        ProcessRefType refType = submittedStructure.addNewProcessRef();
        MaintainableRefBean mRef = sRef.getMaintainableReference();
        refType.setAgencyID(mRef.getAgencyId());
        refType.setProcessID(mRef.getMaintainableId());
        if (ObjectUtil.validString((String[])new String[]{sRef.getMaintainableUrn()})) {
            refType.setURN(sRef.getMaintainableUrn());
        }
        if (ObjectUtil.validString((String[])new String[]{mRef.getVersion()})) {
            refType.setVersion(mRef.getVersion());
        }
    }

    private void addNewMetadataStructureRefSubmissionResult(SubmitStructureResponseType returnType, StructureReferenceBean sRef, Throwable th) {
        SubmissionResultType result = this.getNewSubmissionResultType(returnType, th);
        SubmittedStructureType submittedStructure = result.addNewSubmittedStructure();
        MetadataStructureRefType refType = submittedStructure.addNewMetadataStructureRef();
        MaintainableRefBean mRef = sRef.getMaintainableReference();
        refType.setAgencyID(mRef.getAgencyId());
        refType.setMetadataStructureID(mRef.getMaintainableId());
        if (ObjectUtil.validString((String[])new String[]{sRef.getMaintainableUrn()})) {
            refType.setURN(sRef.getMaintainableUrn());
        }
        if (ObjectUtil.validString((String[])new String[]{mRef.getVersion()})) {
            refType.setVersion(mRef.getVersion());
        }
    }

    private void addNewDataStructureRefSubmissionResult(SubmitStructureResponseType returnType, StructureReferenceBean sRef, Throwable th) {
        SubmissionResultType result = this.getNewSubmissionResultType(returnType, th);
        SubmittedStructureType submittedStructure = result.addNewSubmittedStructure();
        KeyFamilyRefType refType = submittedStructure.addNewKeyFamilyRef();
        MaintainableRefBean mRef = sRef.getMaintainableReference();
        refType.setAgencyID(mRef.getAgencyId());
        refType.setKeyFamilyID(mRef.getMaintainableId());
        if (ObjectUtil.validString((String[])new String[]{sRef.getMaintainableUrn()})) {
            refType.setURN(sRef.getMaintainableUrn());
        }
        if (ObjectUtil.validString((String[])new String[]{mRef.getVersion()})) {
            refType.setVersion(mRef.getVersion());
        }
    }

    private void addNewOrganisationSchemeRefSubmissionResult(SubmitStructureResponseType returnType, StructureReferenceBean sRef, Throwable th) {
        SubmissionResultType result = this.getNewSubmissionResultType(returnType, th);
        SubmittedStructureType submittedStructure = result.addNewSubmittedStructure();
        OrganisationSchemeRefType refType = submittedStructure.addNewOrganisationSchemeRef();
        if (sRef == null) {
            refType.setAgencyID("NOT_APPLICABLE");
        } else {
            MaintainableRefBean mRef = sRef.getMaintainableReference();
            refType.setAgencyID(mRef.getAgencyId());
            refType.setOrganisationSchemeID(mRef.getMaintainableId());
            if (ObjectUtil.validString((String[])new String[]{sRef.getMaintainableUrn()})) {
                refType.setURN(sRef.getMaintainableUrn());
            }
            if (ObjectUtil.validString((String[])new String[]{mRef.getVersion()})) {
                refType.setVersion(mRef.getVersion());
            }
        }
    }

    private void addNewConceptSchemeRefSubmissionResult(SubmitStructureResponseType returnType, StructureReferenceBean sRef, Throwable th) {
        SubmissionResultType result = this.getNewSubmissionResultType(returnType, th);
        SubmittedStructureType submittedStructure = result.addNewSubmittedStructure();
        ConceptSchemeRefType refType = submittedStructure.addNewConceptSchemeRef();
        MaintainableRefBean mRef = sRef.getMaintainableReference();
        refType.setAgencyID(mRef.getAgencyId());
        refType.setConceptSchemeID(mRef.getMaintainableId());
        if (ObjectUtil.validString((String[])new String[]{sRef.getMaintainableUrn()})) {
            refType.setURN(sRef.getMaintainableUrn());
        }
        if (ObjectUtil.validString((String[])new String[]{mRef.getVersion()})) {
            refType.setVersion(mRef.getVersion());
        }
    }

    private void addNewHierarchicalCodelistRefSubmissionResult(SubmitStructureResponseType returnType, StructureReferenceBean sRef, Throwable th) {
        SubmissionResultType result = this.getNewSubmissionResultType(returnType, th);
        SubmittedStructureType submittedStructure = result.addNewSubmittedStructure();
        HierarchicalCodelistRefType refType = submittedStructure.addNewHierarchicalCodelistRef();
        MaintainableRefBean mRef = sRef.getMaintainableReference();
        refType.setAgencyID(mRef.getAgencyId());
        refType.setHierarchicalCodelistID(mRef.getMaintainableId());
        if (ObjectUtil.validString((String[])new String[]{sRef.getMaintainableUrn()})) {
            refType.setURN(sRef.getMaintainableUrn());
        }
        if (ObjectUtil.validString((String[])new String[]{mRef.getVersion()})) {
            refType.setVersion(mRef.getVersion());
        }
    }

    private void addNewCodelistRefSubmissionResult(SubmitStructureResponseType returnType, StructureReferenceBean sRef, Throwable th) {
        SubmissionResultType result = this.getNewSubmissionResultType(returnType, th);
        SubmittedStructureType submittedStructure = result.addNewSubmittedStructure();
        CodelistRefType refType = submittedStructure.addNewCodelistRef();
        MaintainableRefBean mRef = sRef.getMaintainableReference();
        refType.setAgencyID(mRef.getAgencyId());
        refType.setCodelistID(mRef.getMaintainableId());
        if (ObjectUtil.validString((String[])new String[]{sRef.getMaintainableUrn()})) {
            refType.setURN(sRef.getMaintainableUrn());
        }
        if (ObjectUtil.validString((String[])new String[]{mRef.getVersion()})) {
            refType.setVersion(mRef.getVersion());
        }
    }

    private void addNewMetadataflowRefSubmissionResult(SubmitStructureResponseType returnType, StructureReferenceBean sRef, Throwable th) {
        SubmissionResultType result = this.getNewSubmissionResultType(returnType, th);
        SubmittedStructureType submittedStructure = result.addNewSubmittedStructure();
        MetadataflowRefType refType = submittedStructure.addNewMetadataflowRef();
        MaintainableRefBean mRef = sRef.getMaintainableReference();
        refType.setAgencyID(mRef.getAgencyId());
        refType.setMetadataflowID(mRef.getMaintainableId());
        if (ObjectUtil.validString((String[])new String[]{sRef.getMaintainableUrn()})) {
            refType.setURN(sRef.getMaintainableUrn());
        }
        if (ObjectUtil.validString((String[])new String[]{mRef.getVersion()})) {
            refType.setVersion(mRef.getVersion());
        }
    }

    private void addNewDataflowRefSubmissionResult(SubmitStructureResponseType returnType, StructureReferenceBean sRef, Throwable th) {
        SubmissionResultType result = this.getNewSubmissionResultType(returnType, th);
        SubmittedStructureType submittedStructure = result.addNewSubmittedStructure();
        DataflowRefType refType = submittedStructure.addNewDataflowRef();
        MaintainableRefBean mRef = sRef.getMaintainableReference();
        refType.setAgencyID(mRef.getAgencyId());
        refType.setDataflowID(mRef.getMaintainableId());
        if (ObjectUtil.validString((String[])new String[]{sRef.getMaintainableUrn()})) {
            refType.setURN(sRef.getMaintainableUrn());
        }
        if (ObjectUtil.validString((String[])new String[]{mRef.getVersion()})) {
            refType.setVersion(mRef.getVersion());
        }
    }

    private void addNewCategorySchemeRefSubmissionResult(SubmitStructureResponseType returnType, StructureReferenceBean sRef, Throwable th) {
        SubmissionResultType result = this.getNewSubmissionResultType(returnType, th);
        SubmittedStructureType submittedStructure = result.addNewSubmittedStructure();
        CategorySchemeRefType refType = submittedStructure.addNewCategorySchemeRef();
        MaintainableRefBean mRef = sRef.getMaintainableReference();
        refType.setAgencyID(mRef.getAgencyId());
        refType.setCategorySchemeID(mRef.getMaintainableId());
        if (ObjectUtil.validString((String[])new String[]{sRef.getMaintainableUrn()})) {
            refType.setURN(sRef.getMaintainableUrn());
        }
        if (ObjectUtil.validString((String[])new String[]{mRef.getVersion()})) {
            refType.setVersion(mRef.getVersion());
        }
    }

    private SubmissionResultType getNewSubmissionResultType(SubmitStructureResponseType returnType, Throwable th) {
        SubmissionResultType submissionResult = returnType.addNewSubmissionResult();
        StatusMessageType statusMessage = submissionResult.addNewStatusMessage();
        if (th == null) {
            statusMessage.setStatus(StatusType.SUCCESS);
        } else {
            statusMessage.setStatus(StatusType.FAILURE);
            TextType tt = statusMessage.addNewMessageText();
            if (th instanceof SdmxException) {
                tt.setStringValue(((SdmxException)th).getFullMessage());
            } else {
                tt.setStringValue(th.getMessage());
            }
        }
        return submissionResult;
    }
}

