/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.engine.reversion;

import java.util.List;
import java.util.Map;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.process.InputOutputMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.process.ProcessMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.process.ProcessStepMutableBean;
import org.sdmxsource.sdmx.structureparser.engine.ProcessCrossReferenceUpdater;
import org.springframework.stereotype.Service;

@Service
public class ProcessCrossReferenceUpdaterImpl
implements ProcessCrossReferenceUpdater {
    @Override
    public ProcessBean updateReferences(ProcessBean maintianable, Map<StructureReferenceBean, StructureReferenceBean> updateReferences, String newVersionNumber) {
        ProcessMutableBean processMutableBean = maintianable.getMutableInstance();
        processMutableBean.setVersion(newVersionNumber);
        this.updateProcessSteps(processMutableBean.getProcessSteps(), updateReferences);
        return processMutableBean.getImmutableInstance();
    }

    private void updateProcessSteps(List<ProcessStepMutableBean> processSteps, Map<StructureReferenceBean, StructureReferenceBean> updateReferences) {
        if (processSteps != null) {
            for (ProcessStepMutableBean currentProcessStep : processSteps) {
                this.updateProcessSteps(currentProcessStep.getProcessSteps(), updateReferences);
                this.updateInputOutput(currentProcessStep.getInput(), updateReferences);
                this.updateInputOutput(currentProcessStep.getOutput(), updateReferences);
            }
        }
    }

    private void updateInputOutput(List<InputOutputMutableBean> inputOutput, Map<StructureReferenceBean, StructureReferenceBean> updateReferences) {
        if (inputOutput != null) {
            for (InputOutputMutableBean currentInputOutput : inputOutput) {
                StructureReferenceBean updateTo = updateReferences.get(currentInputOutput.getStructureReference());
                if (updateTo == null) continue;
                currentInputOutput.setStructureReference(updateTo);
            }
        }
    }
}

