/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.engine.reversion;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sdmxsource.sdmx.api.model.beans.mapping.StructureSetBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.base.SchemeMapMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.mapping.RelatedStructuresMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.mapping.StructureSetMutableBean;
import org.sdmxsource.sdmx.structureparser.engine.StructureSetCrossReferenceUpdaterEngine;
import org.springframework.stereotype.Service;

@Service
public class StructureSetCrossReferenceUpdaterEngineImpl
implements StructureSetCrossReferenceUpdaterEngine {
    @Override
    public StructureSetBean updateReferences(StructureSetBean maintianable, Map<StructureReferenceBean, StructureReferenceBean> updateReferences, String newVersionNumber) {
        StructureSetMutableBean ss = maintianable.getMutableInstance();
        ss.setVersion(newVersionNumber);
        this.updateSchemeMap(ss.getCategorySchemeMapList(), updateReferences);
        this.updateSchemeMap(ss.getCodelistMapList(), updateReferences);
        this.updateSchemeMap(ss.getConceptSchemeMapList(), updateReferences);
        this.updateSchemeMap(ss.getOrganisationSchemeMapList(), updateReferences);
        this.updateSchemeMap(ss.getStructureMapList(), updateReferences);
        if (ss.getRelatedStructures() != null) {
            RelatedStructuresMutableBean relatedStructures = ss.getRelatedStructures();
            relatedStructures.setCategorySchemeRef(this.updateRelatedStructures(relatedStructures.getCategorySchemeRef(), updateReferences));
            relatedStructures.setConceptSchemeRef(this.updateRelatedStructures(relatedStructures.getConceptSchemeRef(), updateReferences));
            relatedStructures.setHierCodelistRef(this.updateRelatedStructures(relatedStructures.getHierCodelistRef(), updateReferences));
            relatedStructures.setDataStructureRef(this.updateRelatedStructures(relatedStructures.getDataStructureRef(), updateReferences));
            relatedStructures.setMetadataStructureRef(this.updateRelatedStructures(relatedStructures.getMetadataStructureRef(), updateReferences));
            relatedStructures.setOrgSchemeRef(this.updateRelatedStructures(relatedStructures.getOrgSchemeRef(), updateReferences));
        }
        return ss.getImmutableInstance();
    }

    private List<StructureReferenceBean> updateRelatedStructures(List<StructureReferenceBean> sRefList, Map<StructureReferenceBean, StructureReferenceBean> updateReferences) {
        ArrayList<StructureReferenceBean> newReferences = new ArrayList<StructureReferenceBean>();
        if (sRefList != null) {
            for (StructureReferenceBean currentSRef : sRefList) {
                StructureReferenceBean updatedRef = updateReferences.get(currentSRef);
                if (updatedRef != null) {
                    newReferences.add(updatedRef);
                    continue;
                }
                newReferences.add(currentSRef);
            }
        }
        return newReferences;
    }

    private void updateSchemeMap(List<? extends SchemeMapMutableBean> schemeMaps, Map<StructureReferenceBean, StructureReferenceBean> updateReferences) {
        if (schemeMaps != null) {
            for (SchemeMapMutableBean schemeMapMutableBean : schemeMaps) {
                StructureReferenceBean newTarget = updateReferences.get(schemeMapMutableBean.getSourceRef());
                if (newTarget != null) {
                    schemeMapMutableBean.setSourceRef(newTarget);
                }
                if ((newTarget = updateReferences.get(schemeMapMutableBean.getTargetRef())) == null) continue;
                schemeMapMutableBean.setTargetRef(newTarget);
            }
        }
    }
}

