/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.factory;

import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.message.StructureDocument;
import org.sdmx.resources.sdmxml.schemas.v20.message.RegistryInterfaceDocument;
import org.sdmx.resources.sdmxml.schemas.v20.message.StructureDocument;
import org.sdmx.resources.sdmxml.schemas.v21.message.StructureDocument;
import org.sdmxsource.sdmx.api.constants.ARTIFACT_TYPE;
import org.sdmxsource.sdmx.api.constants.MESSAGE_TYPE;
import org.sdmxsource.sdmx.api.constants.REGISTRY_MESSAGE_TYPE;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.factory.StructureParserFactory;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.structureparser.builder.sdmxbeans.SdmxBeansBuilder;
import org.sdmxsource.sdmx.structureparser.manager.parsing.ProvisionParsingManager;
import org.sdmxsource.sdmx.structureparser.manager.parsing.RegistrationParsingManager;
import org.sdmxsource.sdmx.structureparser.manager.parsing.SubscriptionParsingManager;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;
import org.sdmxsource.sdmx.util.sdmx.SdmxMessageUtil;
import org.sdmxsource.springutil.xml.XMLParser;
import org.sdmxsource.util.io.StreamUtil;
import org.sdmxsource.util.log.LoggingUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SdmxStructureParserFactory
implements StructureParserFactory {
    private static final Logger LOG = Logger.getLogger(SdmxStructureParserFactory.class);
    @Autowired
    private SdmxBeansBuilder sdmxBeansBuilder;
    @Autowired
    private ProvisionParsingManager provisionParsingManager;
    @Autowired
    private RegistrationParsingManager registrationParsingManager;
    @Autowired
    private SubscriptionParsingManager subscriptionParsingManager;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$sdmxsource$sdmx$api$constants$ARTIFACT_TYPE;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SdmxBeans getSdmxBeans(ReadableDataLocation dataLocation) {
        SdmxBeans sdmxBeans;
        SDMX_SCHEMA schemaVersion = null;
        try {
            schemaVersion = SdmxMessageUtil.getSchemaVersion((ReadableDataLocation)dataLocation);
        }
        catch (Throwable throwable) {
            return null;
        }
        LOG.debug((Object)("Schema Version : " + schemaVersion));
        if (schemaVersion == SDMX_SCHEMA.EDI) {
            return null;
        }
        MESSAGE_TYPE messageType = SdmxMessageUtil.getMessageType((ReadableDataLocation)dataLocation);
        LOG.debug((Object)("Message type: " + messageType));
        if (schemaVersion.isXmlFormat()) {
            LOG.debug((Object)"Validate XML");
            XMLParser.validateXML((ReadableDataLocation)dataLocation, (SDMX_SCHEMA)schemaVersion, (ReadableDataLocation[])new ReadableDataLocation[0]);
            LoggingUtil.debug((Logger)LOG, (String)"XML VALID");
        }
        REGISTRY_MESSAGE_TYPE registryMessage = null;
        if (messageType == MESSAGE_TYPE.REGISTRY_INTERFACE) {
            registryMessage = SdmxMessageUtil.getRegistryMessageType((ReadableDataLocation)dataLocation);
            return this.processRegistryInterfaceDocument(dataLocation, registryMessage, schemaVersion);
        }
        InputStream stream = dataLocation.getInputStream();
        try {
            sdmxBeans = this.parseSdmxStructureMessage(dataLocation.getInputStream(), schemaVersion, messageType);
        }
        catch (XmlException e) {
            try {
                throw new SdmxException((Throwable)e, "Error while attempting to process SDMX-ML Structure file");
                catch (IOException e2) {
                    throw new SdmxException((Throwable)e2, "Error while attempting to process SDMX-ML Structure file");
                }
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream((InputStream[])new InputStream[]{stream});
                throw throwable;
            }
        }
        StreamUtil.closeStream((InputStream[])new InputStream[]{stream});
        return sdmxBeans;
    }

    private SdmxBeans parseSdmxStructureMessage(InputStream stream, SDMX_SCHEMA schemaVersion, MESSAGE_TYPE messageType) throws XmlException, IOException {
        switch (schemaVersion) {
            case VERSION_ONE: {
                StructureDocument sdV1 = StructureDocument.Factory.parse((InputStream)stream);
                return this.sdmxBeansBuilder.build(sdV1);
            }
            case VERSION_TWO: {
                switch (messageType) {
                    case STRUCTURE: {
                        org.sdmx.resources.sdmxml.schemas.v20.message.StructureDocument sdV2 = StructureDocument.Factory.parse((InputStream)stream);
                        return this.sdmxBeansBuilder.build(sdV2);
                    }
                    case REGISTRY_INTERFACE: {
                        RegistryInterfaceDocument rid = RegistryInterfaceDocument.Factory.parse((InputStream)stream);
                        return this.sdmxBeansBuilder.build(rid);
                    }
                }
                throw new IllegalArgumentException("StructureParsingManagerImpl can not parse document '" + messageType + "' was expecting Structure document or RegistryInterface document");
            }
            case VERSION_TWO_POINT_ONE: {
                switch (messageType) {
                    case STRUCTURE: {
                        org.sdmx.resources.sdmxml.schemas.v21.message.StructureDocument sdV2_1 = StructureDocument.Factory.parse((InputStream)stream);
                        return this.sdmxBeansBuilder.build(sdV2_1);
                    }
                    case ERROR: {
                        return new SdmxBeansImpl();
                    }
                }
                throw new IllegalArgumentException("StructureParsingManagerImpl can not parse document '" + messageType + "' was expecting Structure document or Error document");
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private SdmxBeans processRegistryInterfaceDocument(ReadableDataLocation dataLocation, REGISTRY_MESSAGE_TYPE registryMessage, SDMX_SCHEMA schemaVersion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 11[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$sdmxsource$sdmx$api$constants$ARTIFACT_TYPE() {
        if ($SWITCH_TABLE$org$sdmxsource$sdmx$api$constants$ARTIFACT_TYPE != null) {
            return $SWITCH_TABLE$org$sdmxsource$sdmx$api$constants$ARTIFACT_TYPE;
        }
        int[] nArray = new int[ARTIFACT_TYPE.values().length];
        try {
            nArray[ARTIFACT_TYPE.DATA.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ARTIFACT_TYPE.METADATA.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ARTIFACT_TYPE.NOTIFICATION.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ARTIFACT_TYPE.PROVISION.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ARTIFACT_TYPE.REGISTRATION.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ARTIFACT_TYPE.STRUCTURE.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ARTIFACT_TYPE.SUBSCRIPTION.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$sdmxsource$sdmx$api$constants$ARTIFACT_TYPE = nArray;
        return nArray;
    }
}

