/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.file;

import org.apache.commons.fileupload.ProgressListener;
import org.gcube.portlets.user.td.gwtservice.shared.file.FileUploadMonitor;
import org.gcube.portlets.user.td.gwtservice.shared.file.FileUploadState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadListener
implements ProgressListener {
    protected Logger logger = LoggerFactory.getLogger(FileUploadListener.class);
    protected FileUploadMonitor fileUploadMonitor;
    private long num100Ks = 0L;
    private long theBytesRead = 0L;
    private long theContentLength = -1L;
    private int whichItem = 0;
    private int percentDone = 0;
    private boolean contentLengthKnown = false;

    public FileUploadListener(FileUploadMonitor fileUploadMonitor) {
        this.fileUploadMonitor = fileUploadMonitor;
    }

    public void update(long bytesRead, long contentLength, int items) {
        if (contentLength > -1L) {
            this.contentLengthKnown = true;
        }
        this.theBytesRead = bytesRead;
        this.theContentLength = contentLength;
        this.whichItem = items;
        long nowNum100Ks = bytesRead / 100000L;
        if (nowNum100Ks > this.num100Ks) {
            this.num100Ks = nowNum100Ks;
            if (this.contentLengthKnown) {
                this.percentDone = (int)Math.round(100.0 * (double)bytesRead / (double)contentLength);
            }
        }
        this.fileUploadMonitor.setTotalLenght(contentLength);
        this.fileUploadMonitor.setElaboratedLenght(bytesRead);
        this.fileUploadMonitor.setPercentDone(Float.valueOf(this.percentDone).floatValue() / 100.0f);
        this.fileUploadMonitor.setState(FileUploadState.INPROGRESS);
    }

    public String toString() {
        return "FileUploadListener [fileUploadMonitor=" + this.fileUploadMonitor + ", num100Ks=" + this.num100Ks + ", theBytesRead=" + this.theBytesRead + ", theContentLength=" + this.theContentLength + ", whichItem=" + this.whichItem + ", percentDone=" + this.percentDone + ", contentLengthKnown=" + this.contentLengthKnown + "]";
    }
}

