/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.opexecution;

import java.util.HashMap;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDNumeric;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecutionBuilder;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.geospatial.GeospatialCreateCoordinatesSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.operations.OperationsId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecution4GeospatialCreateCoordinates
extends OpExecutionBuilder {
    protected static Logger logger = LoggerFactory.getLogger(OpExecution4GeospatialCreateCoordinates.class);
    private TabularDataService service;
    private GeospatialCreateCoordinatesSession geospatialCreateCoordinatesSession;
    private ASLSession aslSession;

    public OpExecution4GeospatialCreateCoordinates(ASLSession aslSession, TabularDataService service, GeospatialCreateCoordinatesSession geospatialCreateCoordinatesSession) {
        this.service = service;
        this.geospatialCreateCoordinatesSession = geospatialCreateCoordinatesSession;
        this.aslSession = aslSession;
    }

    @Override
    public void buildOpEx() throws TDGWTServiceException {
        OperationExecution invocation = null;
        logger.debug(this.geospatialCreateCoordinatesSession.toString());
        HashMap<String, Object> map = new HashMap<String, Object>();
        TRId trId = this.geospatialCreateCoordinatesSession.getTrId();
        logger.debug("trID: " + trId);
        if (trId == null) {
            logger.error("Error Creating Geospatial Coordinates: trId is null");
            throw new TDGWTServiceException("No tabular resource set");
        }
        long tabId = trId.isViewTable() ? new Long(trId.getReferenceTargetTableId()).longValue() : new Long(trId.getTableId()).longValue();
        TableId tId = new TableId(tabId);
        ColumnData latitudeColumn = this.geospatialCreateCoordinatesSession.getLatitude();
        logger.debug("Latitude Column: " + latitudeColumn);
        if (latitudeColumn == null) {
            logger.error("Error Creating Geospatial Coordinates: Latitude Column is null");
            throw new TDGWTServiceException("No latitude column set");
        }
        ColumnLocalId latitudeId = new ColumnLocalId(latitudeColumn.getColumnId());
        ColumnReference latitudeColumnReference = new ColumnReference(tId, latitudeId);
        ColumnData longitudeColumn = this.geospatialCreateCoordinatesSession.getLongitude();
        logger.debug("Longitude Column: " + longitudeColumn);
        if (longitudeColumn == null) {
            logger.error("Error Creating Geospatial Coordinates: Longitude Column is null");
            throw new TDGWTServiceException("No longitude column set");
        }
        ColumnLocalId longitudeId = new ColumnLocalId(longitudeColumn.getColumnId());
        ColumnReference longitudeColumnReference = new ColumnReference(tId, longitudeId);
        OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.EnhanceLatLong.toString(), this.service);
        map.put("latitude", latitudeColumnReference);
        map.put("longitude", longitudeColumnReference);
        map.put("user", this.aslSession.getUsername());
        map.put("resolution", new TDNumeric(this.geospatialCreateCoordinatesSession.getResolution()));
        switch (this.geospatialCreateCoordinatesSession.getType()) {
            case C_SQUARE: {
                map.put("feature", this.geospatialCreateCoordinatesSession.getType().getId());
                break;
            }
            case OCEAN_AREA: {
                map.put("feature", this.geospatialCreateCoordinatesSession.getType().getId());
                if (!this.geospatialCreateCoordinatesSession.isHasQuadrant()) break;
                ColumnData quadrantColumn = this.geospatialCreateCoordinatesSession.getQuadrant();
                logger.debug("Quadrant Column: " + quadrantColumn);
                if (quadrantColumn == null) {
                    logger.error("Error Creating Geospatial Coordinates: Quadrant Column is null");
                    throw new TDGWTServiceException("No quadrant column set");
                }
                ColumnLocalId quadrantId = new ColumnLocalId(quadrantColumn.getColumnId());
                ColumnReference quadrantColumnReference = new ColumnReference(tId, quadrantId);
                map.put("quadrant", quadrantColumnReference);
                break;
            }
        }
        invocation = new OperationExecution(operationDefinition.getOperationId(), map);
        this.operationExecutionSpec.setOp(invocation);
    }
}

