/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.opexecution;

import java.util.HashMap;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecutionBuilder;
import org.gcube.portlets.user.td.gwtservice.server.trservice.ExpressionGenerator;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.ReplaceColumnByExpressionSession;
import org.gcube.portlets.user.td.widgetcommonevent.shared.operations.OperationsId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecution4ReplaceColumnByExpression
extends OpExecutionBuilder {
    protected static Logger logger = LoggerFactory.getLogger(OpExecution4ReplaceColumnByExpression.class);
    private TabularDataService service;
    private ReplaceColumnByExpressionSession replaceColumnByExpressionSession;
    private Expression conditionExpression;
    private Expression replaceExpression;

    public OpExecution4ReplaceColumnByExpression(TabularDataService service, ReplaceColumnByExpressionSession replaceColumnByExpressionSession, Expression conditionExpression, Expression replaceExpression) {
        this.service = service;
        this.replaceColumnByExpressionSession = replaceColumnByExpressionSession;
        this.conditionExpression = conditionExpression;
        this.replaceExpression = replaceExpression;
    }

    @Override
    public void buildOpEx() throws TDGWTServiceException {
        OperationExecution invocation = null;
        logger.debug(this.replaceColumnByExpressionSession.toString());
        HashMap<String, Expression> map = new HashMap<String, Expression>();
        logger.debug("Is a Replace of basic column");
        OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.ReplaceColumnByExpression.toString(), this.service);
        if (this.replaceColumnByExpressionSession.isReplaceByValue()) {
            Expression value = ExpressionGenerator.genReplaceValueParameterValue(this.replaceColumnByExpressionSession);
            if (!this.replaceColumnByExpressionSession.isAllRows()) {
                map.put("condition", this.conditionExpression);
            }
            map.put("value", value);
        } else {
            if (!this.replaceColumnByExpressionSession.isAllRows()) {
                map.put("condition", this.conditionExpression);
            }
            map.put("value", this.replaceExpression);
        }
        invocation = new OperationExecution(this.replaceColumnByExpressionSession.getColumn().getColumnId(), operationDefinition.getOperationId(), map);
        this.operationExecutionSpec.setOp(invocation);
    }
}

