/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.mapping;

import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.ValidationException;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ComponentMapType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.ComponentMapBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.RepresentationMapRefBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.StructureMapBean;
import org.sdmxsource.sdmx.api.model.mutable.base.AnnotableMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.mapping.ComponentMapMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.AnnotableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.mapping.RepresentationMapRefBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class ComponentMapBeanImpl
extends AnnotableBeanImpl
implements ComponentMapBean {
    private static final long serialVersionUID = 1L;
    private String mapConceptRef;
    private String mapTargetConceptRef;
    private RepresentationMapRefBean repMapRef;

    protected ComponentMapBeanImpl(ComponentMapMutableBean compMap, SdmxStructureBean parent) {
        super((AnnotableMutableBean)compMap, parent);
        if (compMap.getMapConceptRef() != null) {
            this.mapConceptRef = compMap.getMapConceptRef();
        }
        if (compMap.getMapTargetConceptRef() != null) {
            this.mapTargetConceptRef = compMap.getMapTargetConceptRef();
        }
        if (compMap.getRepMapRef() != null) {
            this.repMapRef = new RepresentationMapRefBeanImpl(compMap.getRepMapRef(), (SdmxStructureBean)this);
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, new Object[]{this});
        }
    }

    protected ComponentMapBeanImpl(ComponentMapType compMap, StructureMapBean parent) {
        super(compMap, SDMX_STRUCTURE_TYPE.COMPONENT_MAP, (SdmxStructureBean)parent);
        this.mapConceptRef = compMap.getSource().getRef().getId();
        this.mapTargetConceptRef = compMap.getTarget().getRef().getId();
        if (compMap.getRepresentationMapping() != null) {
            this.repMapRef = new RepresentationMapRefBeanImpl(compMap.getRepresentationMapping(), (SdmxStructureBean)this);
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, new Object[]{this});
        }
    }

    protected ComponentMapBeanImpl(org.sdmx.resources.sdmxml.schemas.v20.structure.ComponentMapType compMap, StructureMapBean parent) {
        super(null, SDMX_STRUCTURE_TYPE.CATEGORY_MAP, (SdmxStructureBean)parent);
        throw new SdmxNotImplementedException("ComponentMapBeanImpl at version 2.0");
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            ComponentMapBean that = (ComponentMapBean)bean;
            if (!ObjectUtil.equivalent((Object)this.mapConceptRef, (Object)that.getMapConceptRef())) {
                return false;
            }
            if (!ObjectUtil.equivalent((Object)this.mapTargetConceptRef, (Object)that.getMapTargetConceptRef())) {
                return false;
            }
            if (!super.equivalent((SDMXBean)this.repMapRef, (SDMXBean)that.getRepMapRef(), includeFinalProperties)) {
                return false;
            }
            return super.deepEqualsInternal((AnnotableBean)that, includeFinalProperties);
        }
        return false;
    }

    private void validate() throws ValidationException {
        if (!ObjectUtil.validObject((Object[])new Object[]{this.mapConceptRef})) {
            throw new SdmxSemmanticException("Component Map missing source component");
        }
        if (!ObjectUtil.validObject((Object[])new Object[]{this.mapTargetConceptRef})) {
            throw new SdmxSemmanticException("Component Map missing target component");
        }
        HashSet<SDMX_STRUCTURE_TYPE> allowedTypes = new HashSet<SDMX_STRUCTURE_TYPE>();
        allowedTypes.add(SDMX_STRUCTURE_TYPE.ATTRIBUTE_DESCRIPTOR);
        allowedTypes.add(SDMX_STRUCTURE_TYPE.CONSTRAINT_CONTENT_TARGET);
        allowedTypes.add(SDMX_STRUCTURE_TYPE.DATASET_TARGET);
        allowedTypes.add(SDMX_STRUCTURE_TYPE.DIMENSION);
        allowedTypes.add(SDMX_STRUCTURE_TYPE.DIMENSION_DESCRIPTOR_VALUES_TARGET);
        allowedTypes.add(SDMX_STRUCTURE_TYPE.IDENTIFIABLE_OBJECT_TARGET);
        allowedTypes.add(SDMX_STRUCTURE_TYPE.MEASURE_DIMENSION);
        allowedTypes.add(SDMX_STRUCTURE_TYPE.METADATA_ATTRIBUTE);
        allowedTypes.add(SDMX_STRUCTURE_TYPE.PRIMARY_MEASURE);
        allowedTypes.add(SDMX_STRUCTURE_TYPE.TIME_DIMENSION);
        allowedTypes.add(SDMX_STRUCTURE_TYPE.REPORT_PERIOD_TARGET);
    }

    public String getMapConceptRef() {
        return this.mapConceptRef;
    }

    public String getMapTargetConceptRef() {
        return this.mapTargetConceptRef;
    }

    public RepresentationMapRefBean getRepMapRef() {
        return this.repMapRef;
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        Set<SDMXBean> composites = super.getCompositesInternal();
        super.addToCompositeSet((SDMXBean)this.repMapRef, composites);
        return composites;
    }
}

