/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.ValidationException;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ProcessStepType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.InputOutputType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.TransitionType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.NameableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.beans.process.ComputationBean;
import org.sdmxsource.sdmx.api.model.beans.process.InputOutputBean;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessStepBean;
import org.sdmxsource.sdmx.api.model.beans.process.TransitionBean;
import org.sdmxsource.sdmx.api.model.mutable.base.NameableMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.TransitionMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.process.InputOutputMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.process.ProcessStepMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.NameableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.process.ComputationBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.process.InputOutputBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.process.TransitionBeanImpl;

public class ProcessStepBeanImpl
extends NameableBeanImpl
implements ProcessStepBean {
    private static final long serialVersionUID = 1L;
    private static Logger LOG = Logger.getLogger(ProcessStepBeanImpl.class);
    private List<InputOutputBean> input = new ArrayList<InputOutputBean>();
    private List<InputOutputBean> output = new ArrayList<InputOutputBean>();
    private List<TransitionBean> transitions = new ArrayList<TransitionBean>();
    private List<ProcessStepBean> processSteps = new ArrayList<ProcessStepBean>();
    private ComputationBean computation;

    public ProcessStepBeanImpl(IdentifiableBean parent, ProcessStepMutableBean processBean) {
        super((NameableMutableBean)processBean, parent);
        if (processBean.getInput() != null) {
            for (InputOutputMutableBean currentIo : processBean.getInput()) {
                this.input.add(new InputOutputBeanImpl((IdentifiableBean)this, currentIo));
            }
        }
        if (processBean.getOutput() != null) {
            for (InputOutputMutableBean currentIo : processBean.getOutput()) {
                this.output.add(new InputOutputBeanImpl((IdentifiableBean)this, currentIo));
            }
        }
        if (processBean.getComputation() != null) {
            this.computation = new ComputationBeanImpl((IdentifiableBean)this, processBean.getComputation());
        }
        if (processBean.getTransitions() != null) {
            for (TransitionMutableBean mutable : processBean.getTransitions()) {
                this.transitions.add(new TransitionBeanImpl(mutable, (SdmxStructureBean)this));
            }
        }
        if (processBean.getProcessSteps() != null) {
            for (TransitionMutableBean mutable : processBean.getProcessSteps()) {
                this.processSteps.add(new ProcessStepBeanImpl(this, (ProcessStepMutableBean)mutable));
            }
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, new Object[]{this});
        }
    }

    public ProcessStepBeanImpl(NameableBean parent, org.sdmx.resources.sdmxml.schemas.v21.structure.ProcessStepType processBean) {
        super(processBean, SDMX_STRUCTURE_TYPE.PROCESS_STEP, (IdentifiableBean)parent);
        if (processBean.getInputList() != null) {
            for (InputOutputType currentIo : processBean.getInputList()) {
                this.input.add(new InputOutputBeanImpl((IdentifiableBean)this, currentIo));
            }
        }
        if (processBean.getOutputList() != null) {
            for (InputOutputType currentIo : processBean.getOutputList()) {
                this.output.add(new InputOutputBeanImpl((IdentifiableBean)this, currentIo));
            }
        }
        if (processBean.getComputation() != null) {
            this.computation = new ComputationBeanImpl((IdentifiableBean)this, processBean.getComputation());
        }
        if (processBean.getProcessStepList() != null) {
            for (org.sdmx.resources.sdmxml.schemas.v21.structure.ProcessStepType processStep : processBean.getProcessStepList()) {
                this.processSteps.add(new ProcessStepBeanImpl((NameableBean)this, processStep));
            }
        }
        if (processBean.getTransitionList() != null) {
            for (TransitionType trans : processBean.getTransitionList()) {
                TransitionBeanImpl tRef = new TransitionBeanImpl(trans, (SdmxStructureBean)this);
                this.transitions.add(tRef);
            }
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, new Object[]{this});
        }
    }

    public ProcessStepBeanImpl(NameableBean parent, ProcessStepType processBean) {
        super((XmlObject)processBean, SDMX_STRUCTURE_TYPE.PROCESS_STEP, processBean.getId(), "", processBean.getNameList(), processBean.getDescriptionList(), processBean.getAnnotations(), (IdentifiableBean)parent);
        if (processBean.getInputList() != null) {
            LOG.warn((Object)"Input items not supported for SDMX V2.0. These items will be discarded");
        }
        if (processBean.getOutputList() != null) {
            LOG.warn((Object)"Input items not supported for SDMX V2.0. These items will be discarded");
        }
        if (processBean.getComputationList() != null) {
            this.computation = new ComputationBeanImpl((IdentifiableBean)this, processBean);
        }
        if (processBean.getProcessStepList() != null) {
            for (ProcessStepType processStep : processBean.getProcessStepList()) {
                this.processSteps.add(new ProcessStepBeanImpl((NameableBean)this, processStep));
            }
        }
        if (processBean.getTransitionList() != null) {
            for (org.sdmx.resources.sdmxml.schemas.v20.structure.TransitionType trans : processBean.getTransitionList()) {
                TransitionBeanImpl tRef = new TransitionBeanImpl(trans, (SdmxStructureBean)this);
                this.transitions.add(tRef);
            }
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, new Object[]{this});
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            ProcessStepBean that = (ProcessStepBean)bean;
            if (!super.equivalent(this.input, that.getInput(), includeFinalProperties)) {
                return false;
            }
            if (!super.equivalent(this.output, that.getOutput(), includeFinalProperties)) {
                return false;
            }
            if (!super.equivalent(this.transitions, that.getTransitions(), includeFinalProperties)) {
                return false;
            }
            if (!super.equivalent(this.processSteps, that.getProcessSteps(), includeFinalProperties)) {
                return false;
            }
            if (!super.equivalent((SDMXBean)this.computation, (SDMXBean)that.getComputation(), includeFinalProperties)) {
                return false;
            }
            return super.deepEqualsInternal((NameableBean)that, includeFinalProperties);
        }
        return false;
    }

    private void validate() throws ValidationException {
    }

    public ComputationBean getComputation() {
        return this.computation;
    }

    @Override
    public List<TextTypeWrapper> getAllTextTypes() {
        List<TextTypeWrapper> allTextTypes = super.getAllTextTypes();
        if (this.computation != null) {
            allTextTypes.addAll(this.computation.getDescription());
        }
        return allTextTypes;
    }

    public List<InputOutputBean> getInput() {
        return new ArrayList<InputOutputBean>(this.input);
    }

    public List<InputOutputBean> getOutput() {
        return new ArrayList<InputOutputBean>(this.output);
    }

    public List<TransitionBean> getTransitions() {
        return new ArrayList<TransitionBean>(this.transitions);
    }

    public List<ProcessStepBean> getProcessSteps() {
        return new ArrayList<ProcessStepBean>(this.processSteps);
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        Set<SDMXBean> composites = super.getCompositesInternal();
        super.addToCompositeSet(this.input, composites);
        super.addToCompositeSet(this.output, composites);
        super.addToCompositeSet(this.transitions, composites);
        super.addToCompositeSet(this.processSteps, composites);
        super.addToCompositeSet((SDMXBean)this.computation, composites);
        return composites;
    }
}

