/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.mutable.base;

import java.util.Date;
import java.util.Map;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.TERTIARY_BOOL;
import org.sdmxsource.sdmx.api.model.SdmxReader;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.NameableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.MaintainableMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxDateImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.NameableMutableBeanImpl;
import org.sdmxsource.util.ObjectUtil;
import org.sdmxsource.util.VersionableUtil;

public abstract class MaintainableMutableBeanImpl
extends NameableMutableBeanImpl
implements MaintainableMutableBean {
    private static final long serialVersionUID = 1L;
    private Date endDate;
    private Date startDate;
    private String version;
    private String agencyId;
    private TERTIARY_BOOL isFinalStructure;
    private TERTIARY_BOOL isExternalReference;
    private boolean isStub;
    private String serviceURL;
    private String structureURL;

    public MaintainableMutableBeanImpl(SDMX_STRUCTURE_TYPE structureType) {
        super(structureType);
    }

    public MaintainableMutableBeanImpl(MaintainableBean bean) {
        super((NameableBean)bean);
        this.setAgencyId(bean.getAgencyId());
        if (bean.getStartDate() != null) {
            this.setStartDate(bean.getStartDate().getDate());
        }
        if (bean.getEndDate() != null) {
            this.setEndDate(bean.getEndDate().getDate());
        }
        if (bean.getServiceURL() != null) {
            this.serviceURL = bean.getServiceURL().toString();
        }
        if (bean.getStructureURL() != null) {
            this.structureURL = bean.getStructureURL().toString();
        }
        this.setFinalStructure(bean.isFinal());
        this.setVersion(bean.getVersion());
        this.setExternalReference(bean.isExternalReference());
    }

    protected void buildMaintainableAttributes(SdmxReader reader) {
        super.buildIdentifiableAttributes(reader);
        Map attributes = reader.getAttributes();
        this.version = (String)attributes.get("version");
        this.agencyId = (String)attributes.get("agencyID");
        if (attributes.containsKey("validFrom")) {
            this.startDate = new SdmxDateImpl((String)attributes.get("validFrom")).getDate();
        }
        if (attributes.containsKey("validTo")) {
            this.endDate = new SdmxDateImpl((String)attributes.get("validTo")).getDate();
        }
        if (attributes.containsKey("serviceURL")) {
            this.setServiceURL((String)attributes.get("serviceURL"));
        }
        if (attributes.containsKey("structureURL")) {
            this.setStructureURL((String)attributes.get("structureURL"));
        }
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public void setVersion(String version) {
        if (!ObjectUtil.validString((String[])new String[]{version})) {
            version = "1.0";
        }
        if (!VersionableUtil.validVersion((String)version)) {
            throw new IllegalArgumentException("Version invalid : " + version);
        }
        this.version = VersionableUtil.formatVersion((String)version);
    }

    public void setAgencyId(String agencyId) {
        this.agencyId = agencyId;
    }

    public TERTIARY_BOOL getFinalStructure() {
        return this.isFinalStructure;
    }

    public void setFinalStructure(TERTIARY_BOOL isFinalStructure) {
        this.isFinalStructure = isFinalStructure;
    }

    public void setExternalReference(TERTIARY_BOOL isExternalReference) {
        this.isExternalReference = isExternalReference;
    }

    public String getAgencyId() {
        return this.agencyId;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public String getVersion() {
        return this.version;
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public void setServiceURL(String serviceURL) {
        this.serviceURL = serviceURL;
    }

    public void setStructureURL(String structureURL) {
        this.structureURL = structureURL;
    }

    public String getStructureURL() {
        return this.structureURL;
    }

    public TERTIARY_BOOL getExternalReference() {
        return this.isExternalReference;
    }

    public boolean isStub() {
        return this.isStub;
    }

    public void setStub(boolean isStub) {
        this.isStub = isStub;
    }

    public int compareTo(MaintainableBean maintainableBean) {
        return VersionableUtil.isHigherVersion((String)this.version, (String)maintainableBean.getVersion()) ? -1 : 1;
    }
}

