/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.mutable.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.SdmxReader;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.NameableBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.mutable.base.NameableMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.TextTypeWrapperMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.IdentifiableMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.TextTypeWrapperMutableBeanImpl;

public abstract class NameableMutableBeanImpl
extends IdentifiableMutableBeanImpl
implements NameableMutableBean {
    private static final long serialVersionUID = 1L;
    private List<TextTypeWrapperMutableBean> names;
    private List<TextTypeWrapperMutableBean> descriptions;

    public NameableMutableBeanImpl(SDMX_STRUCTURE_TYPE structureType) {
        super(structureType);
    }

    public NameableMutableBeanImpl(NameableBean bean) {
        super((IdentifiableBean)bean);
        if (bean.getName() != null) {
            this.names = new ArrayList<TextTypeWrapperMutableBean>();
            for (TextTypeWrapper currentTextType : bean.getNames()) {
                this.names.add(new TextTypeWrapperMutableBeanImpl(currentTextType));
            }
        }
        if (bean.getDescription() != null) {
            this.descriptions = new ArrayList<TextTypeWrapperMutableBean>();
            for (TextTypeWrapper currentTextType : bean.getDescriptions()) {
                this.descriptions.add(new TextTypeWrapperMutableBeanImpl(currentTextType));
            }
        }
    }

    @Override
    protected boolean processReader(SdmxReader reader) {
        if (super.processReader(reader)) {
            return true;
        }
        if (reader.getCurrentElement().equals("Name")) {
            String lang = reader.getAttributeValue("lang", false);
            this.addName(lang, reader.getCurrentElementValue());
            return true;
        }
        if (reader.getCurrentElement().equals("Description")) {
            String lang = reader.getAttributeValue("lang", false);
            this.addDescription(lang, reader.getCurrentElementValue());
            return true;
        }
        return false;
    }

    public void addDescription(String locale, String name) {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<TextTypeWrapperMutableBean>();
        }
        for (TextTypeWrapperMutableBean currentTT : this.descriptions) {
            if (!currentTT.getLocale().equals(locale)) continue;
            currentTT.setValue(name);
            return;
        }
        TextTypeWrapperMutableBeanImpl tt = new TextTypeWrapperMutableBeanImpl();
        tt.setLocale(locale);
        tt.setValue(name);
        this.descriptions.add(tt);
    }

    public void addName(String locale, String name) {
        if (this.names == null) {
            this.names = new ArrayList<TextTypeWrapperMutableBean>();
        }
        for (TextTypeWrapperMutableBean currentTT : this.names) {
            if (!currentTT.getLocale().equals(locale)) continue;
            currentTT.setValue(name);
            return;
        }
        TextTypeWrapperMutableBeanImpl tt = new TextTypeWrapperMutableBeanImpl();
        tt.setLocale(locale);
        tt.setValue(name);
        this.names.add(tt);
    }

    public String getName(boolean defaultIfNull) {
        Iterator<TextTypeWrapperMutableBean> i$ = this.getNames().iterator();
        if (i$.hasNext()) {
            TextTypeWrapperMutableBean mutable = i$.next();
            return mutable.getValue();
        }
        return null;
    }

    public List<TextTypeWrapperMutableBean> getNames() {
        return this.names;
    }

    public void setNames(List<TextTypeWrapperMutableBean> names) {
        this.names = names;
    }

    public List<TextTypeWrapperMutableBean> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<TextTypeWrapperMutableBean> description) {
        this.descriptions = description;
    }
}

