/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdwx.shared;

import java.io.Serializable;
import java.util.ArrayList;
import org.gcube.portlets.user.tdwx.shared.FilterInformation;
import org.gcube.portlets.user.tdwx.shared.SortInformation;
import org.gcube.portlets.user.tdwx.shared.StaticFilterInformation;

public class RequestData
implements Serializable {
    private static final long serialVersionUID = -7854462973039253712L;
    private String offset;
    private String limit;
    private ArrayList<SortInformation> sorts;
    private ArrayList<FilterInformation> filters;
    private ArrayList<StaticFilterInformation> staticFilters;

    public String getOffset() {
        return this.offset;
    }

    public void setOffset(String offset) {
        this.offset = offset;
    }

    public String getLimit() {
        return this.limit;
    }

    public void setLimit(String limit) {
        this.limit = limit;
    }

    public ArrayList<SortInformation> getSorts() {
        return this.sorts;
    }

    public void setSorts(ArrayList<SortInformation> sorts) {
        this.sorts = sorts;
    }

    public ArrayList<FilterInformation> getFilters() {
        return this.filters;
    }

    public void setFilters(ArrayList<FilterInformation> filters) {
        this.filters = filters;
    }

    public ArrayList<StaticFilterInformation> getStaticFilters() {
        return this.staticFilters;
    }

    public void setStaticFilters(ArrayList<StaticFilterInformation> staticFilters) {
        this.staticFilters = staticFilters;
    }

    public String toString() {
        return "RequestData [offset=" + this.offset + ", limit=" + this.limit + ", sorts=" + this.sorts + ", filters=" + this.filters + ", staticFilters=" + this.staticFilters + "]";
    }

    public String toJsonObject() {
        boolean first;
        StringBuilder json = new StringBuilder();
        json.append("{ \"limit\": \"" + this.limit + "\"," + " \"offset\": \"" + this.offset + "\"");
        if (this.sorts != null && !this.sorts.isEmpty()) {
            json.append(",");
            json.append(" \"sorts\": [");
            first = true;
            for (SortInformation sort : this.sorts) {
                if (first) {
                    first = false;
                } else {
                    json.append(",");
                }
                json.append("{ \"sortDir\":\"" + sort.getSortDir() + "\" ," + "\"sortField\": \"" + sort.getSortField() + "\" }");
            }
            json.append("]");
        }
        if (this.filters != null && !this.filters.isEmpty()) {
            json.append(",");
            json.append(" \"filters\": [");
            first = true;
            for (FilterInformation filter : this.filters) {
                if (first) {
                    first = false;
                } else {
                    json.append(",");
                }
                json.append("{ \"filterField\":\"" + filter.getFilterField() + "\" ," + "\"filterType\":\"" + filter.getFilterType() + "\" ," + "\"filterComparison\":\"" + filter.getFilterComparison() + "\" ," + "\"filterValue\": \"" + filter.getFilterValue() + "\" }");
            }
            json.append("]");
        }
        if (this.staticFilters != null && !this.staticFilters.isEmpty()) {
            json.append(",");
            json.append(" \"staticFilters\": [");
            first = true;
            for (StaticFilterInformation staticFilter : this.staticFilters) {
                if (first) {
                    first = false;
                } else {
                    json.append(",");
                }
                json.append("{ \"columnName\":\"" + staticFilter.getColumnName() + "\" ," + "\"columnLocalId\":\"" + staticFilter.getColumnLocalId() + "\" ," + "\"filterValue\": \"" + staticFilter.getFilterValue() + "\" }");
            }
            json.append("]");
        }
        json.append("}");
        return json.toString();
    }
}

