/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.engine.impl;

import org.sdmxsource.sdmx.api.engine.DataReaderEngine;
import org.sdmxsource.sdmx.api.manager.retrieval.ConstraintRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.base.ConstrainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ContentConstraintBean;
import org.sdmxsource.sdmx.api.model.data.Keyable;
import org.sdmxsource.sdmx.api.model.data.Observation;
import org.sdmxsource.sdmx.dataparser.engine.impl.AbstractDataValidationEngine;
import org.sdmxsource.sdmx.dataparser.model.ContentConstraintModel;

public class ConstraintValidationEngine
extends AbstractDataValidationEngine {
    private ContentConstraintModel constraintModel;
    private ConstraintRetrievalManager constraintRetrievalManager;
    private SdmxBeanRetrievalManager beanRetrievalManager;

    public ConstraintValidationEngine(DataReaderEngine dataReaderEngine, ConstraintRetrievalManager constraintRetrievalManager, SdmxBeanRetrievalManager beanRetrievalManager) {
        super(dataReaderEngine);
        if (constraintRetrievalManager == null) {
            throw new IllegalArgumentException("ConstraintValidationEngine can not be constructucted: ConstraintRetrievalManager can not be null");
        }
        if (beanRetrievalManager == null) {
            throw new IllegalArgumentException("ConstraintValidationEngine can not be constructucted: SdmxBeanRetrievalManager can not be null");
        }
        this.constraintRetrievalManager = constraintRetrievalManager;
        this.beanRetrievalManager = beanRetrievalManager;
    }

    @Override
    protected void processDataset(DataReaderEngine dre) {
        super.processDataset(dre);
        StructureReferenceBean sRef = dre.getProvisionAgreement() != null ? dre.getProvisionAgreement().asReference() : (dre.getDataFlow() != null ? dre.getDataFlow().asReference() : dre.getDataStructure().asReference());
        MaintainableBean maint = this.beanRetrievalManager.getMaintainableBean(sRef);
        ContentConstraintBean constraintBean = null;
        if (maint instanceof ConstrainableBean) {
            constraintBean = this.constraintRetrievalManager.getConstraintDefiningAllowedData((ConstrainableBean)maint);
        }
        if (constraintBean != null) {
            this.constraintModel = new ContentConstraintModel(constraintBean, dre.getDataStructure());
            super.processDataset(dre);
        }
    }

    @Override
    protected void validateSeriesKey(Keyable key) {
        if (this.constraintModel != null) {
            this.constraintModel.isValidKey(key);
        }
    }

    @Override
    protected void validateObservation(Observation obs) {
        if (this.constraintModel != null) {
            this.constraintModel.isValidObservation(obs);
        }
    }
}

