/*
 * Decompiled with CFR 0.152.
 */
package com.wutka.dtd;

import com.wutka.dtd.DTDAttribute;
import com.wutka.dtd.DTDItem;
import com.wutka.dtd.DTDOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;

public class DTDElement
implements DTDOutput {
    public String name;
    public Hashtable attributes;
    public DTDItem content;

    public DTDElement() {
        this.attributes = new Hashtable();
    }

    public DTDElement(String aName) {
        this.name = aName;
        this.attributes = new Hashtable();
    }

    public void write(PrintWriter out) throws IOException {
        out.print("<!ELEMENT ");
        out.print(this.name);
        out.print(" ");
        if (this.content != null) {
            this.content.write(out);
        } else {
            out.print("ANY");
        }
        out.println(">");
        out.println();
    }

    public boolean equals(Object ob) {
        if (ob == this) {
            return true;
        }
        if (!(ob instanceof DTDElement)) {
            return false;
        }
        DTDElement other = (DTDElement)ob;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        return !(this.content == null ? other.content != null : !this.content.equals(other.content));
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getName() {
        return this.name;
    }

    public void setAttribute(String attrName, DTDAttribute attr) {
        this.attributes.put(attrName, attr);
    }

    public DTDAttribute getAttribute(String attrName) {
        return (DTDAttribute)this.attributes.get(attrName);
    }

    public void setContent(DTDItem theContent) {
        this.content = theContent;
    }

    public DTDItem getContent() {
        return this.content;
    }
}

