/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.util.beans;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.superbeans.base.MaintainableSuperBean;
import org.sdmxsource.sdmx.util.beans.reference.MaintainableRefBeanImpl;
import org.sdmxsource.util.ObjectUtil;
import org.sdmxsource.util.VersionableUtil;

public class SuperBeanRefUtil<T extends MaintainableSuperBean> {
    public static MaintainableSuperBean resolveReference(Collection<? extends MaintainableSuperBean> maintianables, MaintainableRefBean ref) {
        if (ref == null) {
            throw new IllegalArgumentException("Ref is null");
        }
        if (!ref.hasAgencyId()) {
            throw new IllegalArgumentException("Ref is mising AgencyId");
        }
        if (!ref.hasMaintainableId()) {
            throw new IllegalArgumentException("Ref is mising Id");
        }
        MaintainableSuperBean latestVersion = null;
        if (maintianables != null) {
            for (MaintainableSuperBean maintainableSuperBean : maintianables) {
                if (!maintainableSuperBean.getAgencyId().equals(ref.getAgencyId()) || !maintainableSuperBean.getId().equals(ref.getMaintainableId())) continue;
                if (!ref.hasVersion()) {
                    if (latestVersion != null && !VersionableUtil.isHigherVersion(maintainableSuperBean.getVersion(), latestVersion.getVersion())) continue;
                    latestVersion = maintainableSuperBean;
                    continue;
                }
                if (!maintainableSuperBean.getVersion().equals(ref.getVersion())) continue;
                return maintainableSuperBean;
            }
        }
        return latestVersion;
    }

    public Set<T> resolveReferences(Collection<T> maintianables, MaintainableRefBean ref) {
        HashSet<MaintainableSuperBean> returnSet = new HashSet<MaintainableSuperBean>();
        if (ref == null) {
            ref = new MaintainableRefBeanImpl();
        }
        boolean hasAgencyFilter = ObjectUtil.validString(ref.getAgencyId());
        boolean hasIdFilter = ObjectUtil.validString(ref.getMaintainableId());
        boolean hasVersionFilter = ObjectUtil.validString(ref.getVersion());
        String agencyId = ref.getAgencyId();
        String id = ref.getMaintainableId();
        String version = ref.getVersion();
        if (maintianables != null) {
            for (MaintainableSuperBean currentMaintainable : maintianables) {
                if (hasAgencyFilter && !agencyId.equals(currentMaintainable.getAgencyId()) || hasIdFilter && !id.equals(currentMaintainable.getId()) || hasVersionFilter && !version.equals(currentMaintainable.getVersion())) continue;
                returnSet.add(currentMaintainable);
            }
        }
        return returnSet;
    }
}

