/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.opexecution;

import java.util.HashMap;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.datapublishing.sdmx.api.model.SDMXRegistryInterfaceType;
import org.gcube.datapublishing.sdmx.impl.model.GCubeSDMXRegistryDescriptor;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecutionBuilder;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.sdmx.SDMXImportSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.type.Codelist;
import org.gcube.portlets.user.td.widgetcommonevent.shared.operations.OperationsId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecution4SDMXCodelistImport
extends OpExecutionBuilder {
    protected static Logger logger = LoggerFactory.getLogger(OpExecution4SDMXCodelistImport.class);
    private TabularDataService service;
    private SDMXImportSession sdmxImportSession;

    public OpExecution4SDMXCodelistImport(TabularDataService service, SDMXImportSession sdmxImportSession) {
        this.service = service;
        this.sdmxImportSession = sdmxImportSession;
    }

    @Override
    public void buildOpEx() throws TDGWTServiceException {
        logger.debug(this.sdmxImportSession.toString());
        OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.SDMXCodelistImport.toString(), this.service);
        HashMap<String, String> map = new HashMap<String, String>();
        Codelist codelist = this.sdmxImportSession.getSelectedCodelist();
        map.put("agency", codelist.getAgencyId());
        map.put("id", codelist.getId());
        map.put("version", codelist.getVersion());
        GCubeSDMXRegistryDescriptor descriptor = new GCubeSDMXRegistryDescriptor();
        map.put("registryBaseUrl", descriptor.getUrl(SDMXRegistryInterfaceType.RESTV2_1));
        OperationExecution invocation = new OperationExecution(operationDefinition.getOperationId(), map);
        this.operationExecutionSpec.setOp(invocation);
    }
}

