/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.opexecution;

import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecutionBuilder;
import org.gcube.portlets.user.td.gwtservice.server.trservice.ColumnDataTypeMap;
import org.gcube.portlets.user.td.gwtservice.server.trservice.ColumnTypeCodeMap;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.column.SplitColumnSession;
import org.gcube.portlets.user.td.widgetcommonevent.shared.operations.OperationsId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecution4SplitColumn
extends OpExecutionBuilder {
    protected static Logger logger = LoggerFactory.getLogger(OpExecution4SplitColumn.class);
    private TabularDataService service;
    private SplitColumnSession splitColumnSession;

    public OpExecution4SplitColumn(TabularDataService service, SplitColumnSession splitColumnSession) {
        this.service = service;
        this.splitColumnSession = splitColumnSession;
    }

    @Override
    public void buildOpEx() throws TDGWTServiceException {
        ArrayList<OperationExecution> invocations = new ArrayList<OperationExecution>();
        logger.debug(this.splitColumnSession.toString());
        OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.AddColumn.toString(), this.service);
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        ArrayList<Expression> expressions = this.splitColumnSession.getExpressions();
        if (expressions == null || expressions.size() <= 1) {
            throw new TDGWTServiceException("No valid expressions in splitColumnSession");
        }
        map1.put("columnType", ColumnTypeCodeMap.getColumnType(this.splitColumnSession.getFirstSplitColumnType()));
        map1.put("dataType", ColumnDataTypeMap.map(this.splitColumnSession.getFirstSplitColumnDataType()));
        map1.put("label", new ImmutableLocalizedText(this.splitColumnSession.getLabel1()));
        map1.put("value", expressions.get(0));
        invocations.add(new OperationExecution(operationDefinition.getOperationId(), map1));
        map2.put("columnType", ColumnTypeCodeMap.getColumnType(this.splitColumnSession.getSecondSplitColumnType()));
        map2.put("dataType", ColumnDataTypeMap.map(this.splitColumnSession.getSecondSplitColumnDataType()));
        map2.put("label", new ImmutableLocalizedText(this.splitColumnSession.getLabel2()));
        map2.put("value", expressions.get(1));
        invocations.add(new OperationExecution(operationDefinition.getOperationId(), map2));
        if (this.splitColumnSession.isDeleteColumn()) {
            OperationDefinition operationDefinitionRemoveColumn = OperationDefinitionMap.map(OperationsId.RemoveColumn.toString(), this.service);
            HashMap mapRemoveColumn = new HashMap();
            OperationExecution invocationRemoveColumn = null;
            invocationRemoveColumn = new OperationExecution(this.splitColumnSession.getColumnData().getColumnId(), operationDefinitionRemoveColumn.getOperationId(), mapRemoveColumn);
            invocations.add(invocationRemoveColumn);
        }
        this.operationExecutionSpec.setOps(invocations);
    }
}

