/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.opexecution;

import java.util.HashMap;
import java.util.Map;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecutionBuilder;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.statistical.StatisticalOperationSession;
import org.gcube.portlets.user.td.widgetcommonevent.shared.operations.OperationsId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecution4StatisticalOperation
extends OpExecutionBuilder {
    protected static Logger logger = LoggerFactory.getLogger(OpExecution4StatisticalOperation.class);
    private TabularDataService service;
    private ASLSession aslSession;
    private StatisticalOperationSession statisticalOperationSession;

    public OpExecution4StatisticalOperation(TabularDataService service, ASLSession aslSession, StatisticalOperationSession statisticalOperationSession) {
        this.service = service;
        this.aslSession = aslSession;
        this.statisticalOperationSession = statisticalOperationSession;
    }

    @Override
    public void buildOpEx() throws TDGWTServiceException {
        OperationExecution invocation = null;
        logger.debug(this.statisticalOperationSession.toString());
        HashMap<String, Object> map = new HashMap<String, Object>();
        OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.StatisticalOperation.toString(), this.service);
        map.put("user", this.aslSession.getUsername());
        map.put("algorithm", this.statisticalOperationSession.getOperatorId());
        HashMap<String, String> params = new HashMap<String, String>();
        Map<String, String> parameters = this.statisticalOperationSession.getParameters();
        for (String key : parameters.keySet()) {
            params.put(key.toString(), parameters.get(key));
        }
        map.put("smEntries", params);
        map.put("description", this.statisticalOperationSession.getDescription());
        map.put("title", this.statisticalOperationSession.getTitle());
        invocation = new OperationExecution(operationDefinition.getOperationId(), map);
        this.operationExecutionSpec.setOp(invocation);
    }
}

