/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.rconnector.client;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.xml.ws.EndpointReference;
import org.gcube.data.analysis.rconnector.client.GcubeService;
import org.gcube.data.analysis.rconnector.client.JaxRSEndpointReference;
import org.gcube.data.analysis.rconnector.client.JaxRSRequestFilter;
import org.gcube.data.analysis.rconnector.client.TargetFactoryDSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetFactory
implements TargetFactoryDSL.AtClause {
    private static Logger log = LoggerFactory.getLogger(TargetFactory.class);
    private GcubeService target;

    public static TargetFactory stubFor(GcubeService target) {
        return new TargetFactory(target);
    }

    private TargetFactory(GcubeService target) {
        this.target = target;
    }

    @Override
    public WebTarget at(String address) {
        try {
            Client client = ClientBuilder.newClient();
            String resourceAddress = address.substring(0, address.indexOf("/service"));
            WebTarget resourcetarget = client.target(resourceAddress).path("/resource/");
            int status = resourcetarget.request().get().getStatus();
            if (status != 200) {
                throw new Exception();
            }
            WebTarget webTarget = client.target(address);
            webTarget.path(this.target.path());
            webTarget.register((Object)new JaxRSRequestFilter(this.target));
            return webTarget;
        }
        catch (Exception e) {
            log.error("error building service", (Throwable)e);
            throw new RuntimeException("error building service", e);
        }
    }

    public WebTarget at(EndpointReference endpoint) {
        return this.at(new JaxRSEndpointReference((EndpointReference)endpoint).address);
    }
}

