/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.base;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sdmx.resources.sdmxml.schemas.v20.common.AnnotationType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotationBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.mutable.base.AnnotationMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.MutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.TextTypeWrapperMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SDMXBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.TextTypeWrapperImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.TextTypeUtil;
import org.sdmxsource.sdmx.util.beans.ValidationUtil;
import org.sdmxsource.util.ObjectUtil;

public class AnnotationBeanImpl
extends SDMXBeanImpl
implements AnnotationBean {
    private static final long serialVersionUID = 1L;
    private String id;
    private String title;
    private String type;
    private URI uri;
    private List<TextTypeWrapper> text = new ArrayList<TextTypeWrapper>();

    public AnnotationBeanImpl(AnnotationMutableBean annotationMutable, SDMXBean parent) {
        super((MutableBean)annotationMutable, parent);
        this.id = annotationMutable.getId();
        this.title = annotationMutable.getTitle();
        this.type = annotationMutable.getType();
        if (annotationMutable.getText() != null) {
            for (TextTypeWrapperMutableBean mutable : annotationMutable.getText()) {
                if (!ObjectUtil.validString((String[])new String[]{mutable.getValue()})) continue;
                this.text.add(new TextTypeWrapperImpl(mutable, (SDMXBean)this));
            }
        }
        this.setURI(annotationMutable.getUri());
        try {
            this.validate();
        }
        catch (SdmxException ex) {
            throw new SdmxException((Throwable)ex, "Annotation is not valid");
        }
        catch (Throwable th) {
            throw new SdmxException(th, "Annotation is not valid");
        }
    }

    public AnnotationBeanImpl(org.sdmx.resources.sdmxml.schemas.v21.common.AnnotationType annotation, SDMXBean parent) {
        super(SDMX_STRUCTURE_TYPE.ANNOTATION, parent);
        this.title = annotation.getAnnotationTitle();
        this.type = annotation.getAnnotationType();
        this.id = annotation.getId();
        this.text = TextTypeUtil.wrapTextTypeV21(annotation.getAnnotationTextList(), this);
        this.setURI(annotation.getAnnotationURL());
        try {
            this.validate();
        }
        catch (SdmxException ex) {
            throw new SdmxException((Throwable)ex, "Annotation is not valid");
        }
        catch (Throwable th) {
            throw new SdmxException(th, "Annotation is not valid");
        }
    }

    public AnnotationBeanImpl(AnnotationType annotation, SDMXBean parent) {
        super(SDMX_STRUCTURE_TYPE.ANNOTATION, parent);
        this.title = annotation.getAnnotationTitle();
        this.type = annotation.getAnnotationType();
        this.text = TextTypeUtil.wrapTextTypeV2(annotation.getAnnotationTextList(), this);
        this.setURI(annotation.getAnnotationURL());
        try {
            this.validate();
        }
        catch (SdmxException ex) {
            throw new SdmxException((Throwable)ex, "Annotation is not valid");
        }
        catch (Throwable th) {
            throw new SdmxException(th, "Annotation is not valid");
        }
    }

    public AnnotationBeanImpl(org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.common.AnnotationType annotation, SDMXBean parent) {
        super(SDMX_STRUCTURE_TYPE.ANNOTATION, parent);
        this.title = annotation.getAnnotationTitle();
        this.type = annotation.getAnnotationType();
        this.text = TextTypeUtil.wrapTextTypeV1(annotation.getAnnotationTextList(), this);
        this.setURI(annotation.getAnnotationURL());
        try {
            this.validate();
        }
        catch (SdmxException ex) {
            throw new SdmxException((Throwable)ex, "Annotation is not valid");
        }
        catch (Throwable th) {
            throw new SdmxException(th, "Could not create Annotation as it did not validate");
        }
    }

    private void setURI(String serviceURIStr) {
        if (serviceURIStr == null) {
            this.uri = null;
            return;
        }
        try {
            this.uri = new URI(serviceURIStr);
        }
        catch (SdmxException ex) {
            throw new SdmxException((Throwable)ex, "Could not create attribute 'annotationURL' with value '" + serviceURIStr + "'");
        }
        catch (Throwable th) {
            throw new SdmxException(th, "Could not create attribute 'annotationURL' with value '" + serviceURIStr + "'");
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (!includeFinalProperties) {
            return true;
        }
        return this.equals(bean);
    }

    public int hashCode() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id + this.title + this.type);
        if (this.uri != null) {
            sb.append(this.uri.toString());
        }
        for (TextTypeWrapper tt : this.text) {
            sb.append(tt.getLocale() + ":" + tt.getValue());
        }
        return sb.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AnnotationBean) {
            AnnotationBean annotation = (AnnotationBean)obj;
            if (!ObjectUtil.equivalent((Object)this.id, (Object)annotation.getId())) {
                return false;
            }
            if (!ObjectUtil.equivalent((Object)this.title, (Object)annotation.getTitle())) {
                return false;
            }
            if (!ObjectUtil.equivalent((Object)this.type, (Object)annotation.getType())) {
                return false;
            }
            if (!ObjectUtil.equivalent((Object)this.uri, (Object)annotation.getUri())) {
                return false;
            }
            return super.equivalent(this.text, annotation.getText(), true);
        }
        return false;
    }

    private void validate() {
        ValidationUtil.validateTextType(this.text, null);
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        HashSet<SDMXBean> composites = new HashSet<SDMXBean>();
        super.addToCompositeSet(this.text, composites);
        return composites;
    }

    public String getTitle() {
        return this.title;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public URI getUri() {
        return this.uri;
    }

    public List<TextTypeWrapper> getText() {
        return new ArrayList<TextTypeWrapper>(this.text);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Title:" + this.getTitle());
        sb.append("Type:" + this.getType());
        sb.append("URI:" + this.getUri());
        return sb.toString();
    }
}

