/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.registry;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.sdmx.resources.sdmxml.schemas.v21.common.DistinctKeyType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ConstraintType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.DataKeySetType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.MetadataKeySetType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ConstraintAttachmentBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ConstraintDataKeySetBean;
import org.sdmxsource.sdmx.api.model.mutable.base.MaintainableMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.registry.ConstraintMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.MaintainableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.registry.ConstraintAttachmentBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.registry.ConstraintDataKeySetBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public abstract class ConstraintBeanImpl
extends MaintainableBeanImpl
implements ConstraintBean {
    private static final long serialVersionUID = 1L;
    private ConstraintDataKeySetBean includedSeriesKeys;
    private ConstraintDataKeySetBean excludedSeriesKeys;
    private ConstraintDataKeySetBean includedMetadataKeys;
    private ConstraintDataKeySetBean excludedMetadataKeys;
    private ConstraintAttachmentBean constraintAttachment;

    public ConstraintBeanImpl(MaintainableBean bean, URL actualLocation, boolean isServiceUrl) {
        super(bean, actualLocation, isServiceUrl);
    }

    public ConstraintBeanImpl(ConstraintMutableBean bean) {
        super((MaintainableMutableBean)bean);
        if (bean.getIncludedSeriesKeys() != null && bean.getIncludedSeriesKeys().getConstrainedDataKeys() != null && bean.getIncludedSeriesKeys().getConstrainedDataKeys().size() > 0) {
            this.includedSeriesKeys = new ConstraintDataKeySetBeanImpl(bean.getIncludedSeriesKeys(), (ConstraintBean)this);
        }
        if (bean.getExcludedSeriesKeys() != null && bean.getExcludedSeriesKeys().getConstrainedDataKeys() != null && bean.getExcludedSeriesKeys().getConstrainedDataKeys().size() > 0) {
            this.excludedSeriesKeys = new ConstraintDataKeySetBeanImpl(bean.getExcludedSeriesKeys(), (ConstraintBean)this);
        }
        if (bean.getIncludedMetadataKeys() != null && bean.getIncludedMetadataKeys().getConstrainedDataKeys() != null && bean.getIncludedMetadataKeys().getConstrainedDataKeys().size() > 0) {
            this.includedMetadataKeys = new ConstraintDataKeySetBeanImpl(bean.getIncludedSeriesKeys(), (ConstraintBean)this);
        }
        if (bean.getExcludedMetadataKeys() != null && bean.getExcludedMetadataKeys().getConstrainedDataKeys() != null && bean.getExcludedMetadataKeys().getConstrainedDataKeys().size() > 0) {
            this.excludedMetadataKeys = new ConstraintDataKeySetBeanImpl(bean.getExcludedSeriesKeys(), (ConstraintBean)this);
        }
        if (bean.getConstraintAttachment() != null) {
            this.constraintAttachment = new ConstraintAttachmentBeanImpl(bean.getConstraintAttachment(), (ConstraintBean)this);
        }
        this.validate();
    }

    public ConstraintBeanImpl(ConstraintType createdFrom, SDMX_STRUCTURE_TYPE structureType) {
        super(createdFrom, structureType);
        if (ObjectUtil.validCollection(createdFrom.getDataKeySetList())) {
            DataKeySetType includedKeySet = DataKeySetType.Factory.newInstance();
            DataKeySetType excludedKeySet = DataKeySetType.Factory.newInstance();
            this.populateKeySets(createdFrom.getDataKeySetList(), includedKeySet, excludedKeySet);
            if (includedKeySet.getKeyList().size() > 0) {
                this.includedSeriesKeys = new ConstraintDataKeySetBeanImpl(includedKeySet, (ConstraintBean)this);
            }
            if (excludedKeySet.getKeyList().size() > 0) {
                this.excludedSeriesKeys = new ConstraintDataKeySetBeanImpl(excludedKeySet, (ConstraintBean)this);
            }
        }
        if (ObjectUtil.validCollection(createdFrom.getMetadataKeySetList())) {
            DataKeySetType includedMetadataKeySet = DataKeySetType.Factory.newInstance();
            DataKeySetType excludedMetadataKeySet = DataKeySetType.Factory.newInstance();
            this.populateMetadataKeySets(createdFrom.getMetadataKeySetList(), includedMetadataKeySet, excludedMetadataKeySet);
            if (includedMetadataKeySet.getKeyList().size() > 0) {
                this.includedMetadataKeys = new ConstraintDataKeySetBeanImpl(includedMetadataKeySet, (ConstraintBean)this);
            }
            if (excludedMetadataKeySet.getKeyList().size() > 0) {
                this.excludedMetadataKeys = new ConstraintDataKeySetBeanImpl(excludedMetadataKeySet, (ConstraintBean)this);
            }
        }
        if (createdFrom.getConstraintAttachment() != null) {
            this.constraintAttachment = new ConstraintAttachmentBeanImpl(createdFrom.getConstraintAttachment(), (ConstraintBean)this);
        }
        this.validate();
    }

    private void populateMetadataKeySets(List<MetadataKeySetType> allKeys, DataKeySetType includedKeySet, DataKeySetType excludedKeySet) {
        for (MetadataKeySetType currentDataKeySet : allKeys) {
            if (currentDataKeySet.getIsIncluded()) {
                for (DistinctKeyType currentKey : currentDataKeySet.getKeyList()) {
                    if (currentKey.isSetInclude() && !currentKey.getInclude()) {
                        excludedKeySet.getKeyList().add(currentKey);
                        continue;
                    }
                    includedKeySet.getKeyList().add(currentKey);
                }
                continue;
            }
            for (DistinctKeyType currentKey : currentDataKeySet.getKeyList()) {
                if (currentKey.isSetInclude() && !currentKey.getInclude()) {
                    excludedKeySet.getKeyList().add(currentKey);
                    continue;
                }
                includedKeySet.getKeyList().add(currentKey);
            }
        }
    }

    private void populateKeySets(List<DataKeySetType> allKeys, DataKeySetType includedKeySet, DataKeySetType excludedKeySet) {
        for (DataKeySetType currentDataKeySet : allKeys) {
            if (currentDataKeySet.getIsIncluded()) {
                for (DistinctKeyType currentKey : currentDataKeySet.getKeyList()) {
                    if (currentKey.isSetInclude() && !currentKey.getInclude()) {
                        excludedKeySet.getKeyList().add(currentKey);
                        continue;
                    }
                    includedKeySet.getKeyList().add(currentKey);
                }
                continue;
            }
            for (DistinctKeyType currentKey : currentDataKeySet.getKeyList()) {
                if (currentKey.isSetInclude() && !currentKey.getInclude()) {
                    includedKeySet.getKeyList().add(currentKey);
                    continue;
                }
                excludedKeySet.getKeyList().add(currentKey);
            }
        }
    }

    protected boolean deepEqualsInternal(ConstraintBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            ConstraintBean that = bean;
            if (!super.equivalent((SDMXBean)this.includedSeriesKeys, (SDMXBean)that.getIncludedSeriesKeys(), includeFinalProperties)) {
                return false;
            }
            if (!super.equivalent((SDMXBean)this.excludedSeriesKeys, (SDMXBean)that.getExcludedSeriesKeys(), includeFinalProperties)) {
                return false;
            }
            if (!super.equivalent((SDMXBean)this.constraintAttachment, (SDMXBean)that.getConstraintAttachment(), includeFinalProperties)) {
                return false;
            }
            return super.deepEqualsInternal((MaintainableBean)that, includeFinalProperties);
        }
        return false;
    }

    private void validate() {
        if (this.includedSeriesKeys != null && !ObjectUtil.validCollection((Collection)this.includedSeriesKeys.getConstrainedDataKeys())) {
            this.includedSeriesKeys = null;
        }
        if (this.excludedSeriesKeys != null && !ObjectUtil.validCollection((Collection)this.excludedSeriesKeys.getConstrainedDataKeys())) {
            this.excludedSeriesKeys = null;
        }
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        Set<SDMXBean> composites = super.getCompositesInternal();
        super.addToCompositeSet((SDMXBean)this.includedSeriesKeys, composites);
        super.addToCompositeSet((SDMXBean)this.excludedSeriesKeys, composites);
        super.addToCompositeSet((SDMXBean)this.includedMetadataKeys, composites);
        super.addToCompositeSet((SDMXBean)this.excludedMetadataKeys, composites);
        super.addToCompositeSet((SDMXBean)this.constraintAttachment, composites);
        return composites;
    }

    public ConstraintAttachmentBean getConstraintAttachment() {
        return this.constraintAttachment;
    }

    public ConstraintDataKeySetBean getIncludedSeriesKeys() {
        return this.includedSeriesKeys;
    }

    public ConstraintDataKeySetBean getExcludedSeriesKeys() {
        return this.excludedSeriesKeys;
    }

    public ConstraintDataKeySetBean getIncludedMetadataKeys() {
        return this.includedMetadataKeys;
    }

    public ConstraintDataKeySetBean getExcludedMetadataKeys() {
        return this.excludedMetadataKeys;
    }
}

