package org.gcube.portlets.user.td.mainboxwidget.client;

import org.gcube.portlets.user.td.mainboxwidget.client.rpc.TabularDataServiceAsync;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.UIStateEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.UIStateType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.tr.TabResourceType;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.web.bindery.event.shared.EventBus;
import com.google.web.bindery.event.shared.SimpleEventBus;
import com.sencha.gxt.widget.core.client.container.Viewport;

/**
 * 
 * @author giancarlo
 * email: <a href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a> 
 *
 */
public class MainBoxEntry implements EntryPoint {
	protected static final String JSP_TAG_ID = "tdp";
	
	
	public void onModuleLoad() {

		TabularDataServiceAsync.INSTANCE.hello(new AsyncCallback<String>() {

			@Override
			public void onSuccess(String result) {
				loadDataView();

			}

			@Override
			public void onFailure(Throwable caught) {
				caught.printStackTrace();

			}
		});

	}

	protected void loadDataView() {
		// For example Tabular Resource 7 and table 402
		TRId trId1 = new TRId("220", TabResourceType.STANDARD, "3555");
		TRId trId2 = new TRId("219", TabResourceType.STANDARD, "3507");
		TRId trId3 = new TRId("168", TabResourceType.STANDARD, "2165");

		EventBus eventBus = new SimpleEventBus();

		try {
			MainBoxPanel mainBoxPanel = new MainBoxPanel("MainBoxPanel",
					eventBus);
			
			startInDevMode(mainBoxPanel);
			

			UIStateEvent uiStateEvent1 = new UIStateEvent(UIStateType.TR_OPEN);
			uiStateEvent1.setTrId(trId1);
			eventBus.fireEvent(uiStateEvent1);

			UIStateEvent uiStateEvent2 = new UIStateEvent(UIStateType.TR_OPEN);
			uiStateEvent2.setTrId(trId2);
			eventBus.fireEvent(uiStateEvent2);

			UIStateEvent uiStateEvent3 = new UIStateEvent(UIStateType.TR_OPEN);
			uiStateEvent3.setTrId(trId3);
			eventBus.fireEvent(uiStateEvent3);

			Log.info("MainBoxPanel Added:" + mainBoxPanel);
		} catch (Throwable e) {
			e.printStackTrace();
		}
	}
	
	protected void startInDevMode(MainBoxPanel mainWidget) {
		try {
			RootPanel root = RootPanel.get(JSP_TAG_ID);
			Log.info("Root Panel: " + root);
			if (root == null) {
				Log.info("Div with id " + JSP_TAG_ID
						+ " not found, starting in dev mode");
				Viewport viewport = new Viewport();
				viewport.setWidget(mainWidget);
				viewport.onResize();
				RootPanel.get().add(viewport);
			} else {
				Log.info("Application div with id " + JSP_TAG_ID
						+ " found, starting in portal mode");
				/*PortalViewport viewport = new PortalViewport();
				Log.info("Created Viewport");
				viewport.setEnableScroll(false);
				viewport.setWidget(mainWidget);
				Log.info("Set Widget");
				Log.info("getOffsetWidth(): " + viewport.getOffsetWidth());
				Log.info("getOffsetHeight(): " + viewport.getOffsetHeight());
				viewport.onResize();
				root.add(viewport);
				Log.info("Added viewport to root");*/
			}
		} catch (Exception e) {
			e.printStackTrace();
			Log.error("Error in attach viewport:" + e.getLocalizedMessage());
		}
	}
}
