package org.gcube.portlets.user.td.toolboxwidget.client;


import org.gcube.portlets.user.td.widgetcommonevent.client.event.RibbonEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.UIStateEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.WidgetRequestEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.UIStateType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.WidgetRequestType;

import com.allen_sauer.gwt.log.client.Log;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.widget.core.client.ContentPanel;


public class ToolBoxPanel extends ContentPanel {
	
	protected EventBus eventBus;
	protected ToolBox toolBox;
	protected ToolBoxPanelState state;
	protected UIStateType uiStateType;
	protected WidgetRequestType widgetRequestType;
	
	
	public ToolBoxPanel(String name, EventBus eventBus) {
		super();
		Log.debug("Open ToolBoxPanel");
		this.eventBus=eventBus;
		setId(name);
	    setWidth(310);
		setHeaderVisible(false);
		setResize(true);
		setBodyBorder(false);
		setBorders(false);
		toolBox = new ToolBox("ToolBox",eventBus,this);
		add(toolBox);
		startPanel();
		bindToEvents();
		
	}
	
	protected void bindToEvents() {
		eventBus.addHandler(RibbonEvent.TYPE,
				new RibbonEvent.RibbonEventHandler() {

					
					public void onRibbon(RibbonEvent event) {
						manageRibbonEvents(event);

					}
		});
		
		eventBus.addHandler(WidgetRequestEvent.TYPE,
				new WidgetRequestEvent.WidgetRequestEventHandler() {

					
					public void onWidgetRequest(WidgetRequestEvent event) {
						manageWidgetRequestEvents(event);

					}
		});
		
		
		eventBus.addHandler(
				UIStateEvent.TYPE,
				new UIStateEvent.UIStateHandler() {
					
					
					public void onUIState(UIStateEvent event) {
						manageUIStateEvents(event);
						
					}
	    });
	}
	
	protected void manageRibbonEvents(RibbonEvent event){
		Log.debug("ToolBox recieved event: "+event.getRibbonType().toString());
		switch (event.getRibbonType()){
		case PROPERTIES:
			doPropertiesOpenTab();
			break;
		case HELP:
			doHelpTab();
		default:
			break;
		}
	}
	
	protected void manageUIStateEvents(UIStateEvent event){
		Log.debug("ToolBox recieved event: "+event.getUIStateType().toString());
		uiStateType = event.getUIStateType();
		switch (event.getUIStateType()){
		case START:
			break;
		case TR_CLOSE:
			//this.enable();
			closePanel();
			break;
		case TR_OPEN:
			//this.enable();
			updatePanel();
			break;
		case WIZARD_OPEN:
			//this.disable();
			break;
		default:
			break;
		
		}
	}
	

	protected void manageWidgetRequestEvents(WidgetRequestEvent event){
		Log.debug("ToolBox recieved event: "+event.getWidgetRequestType().toString());
		widgetRequestType = event.getWidgetRequestType();
		switch (event.getWidgetRequestType()){
		case CHANGECOLUMNTYPEPANEL:
			doColumnTypeChangeTab(event);
			break;
		case DELETECOLUMNPANEL:
			doDeleteColumnTab(event);
			break;
		case LABELCOLUNPANEL:
			doLabelColumnTab(event);
			break;	
			
		default:
			break;
		
		}
	}
	
	protected void doColumnTypeChangeTab(WidgetRequestEvent event){
		Log.debug("WidgetRequestEvent.CHANGECOLUMNTYPEPANEL : ["+event.getTrId()+" ,columnName: "+event.getColumnName()+"]");
		if (uiStateType == UIStateType.TR_OPEN) {
			if (state == ToolBoxPanelState.OPENED) {
				toolBox.openColumnTypeChangeTab(event.getTrId(), event.getColumnName());
				Log.debug("ToolBoxPanelSTate.OPENED Add Tabs");
			} else {
				enable();
				expand();
				state = ToolBoxPanelState.OPENED;
				toolBox.openColumnTypeChangeTab(event.getTrId(), event.getColumnName());
			}
		} else {
			Log.debug("ToolBoxPanel No table open");
		}
	}
	
	protected void doDeleteColumnTab(WidgetRequestEvent event){
		Log.debug("WidgetRequestEvent.DeleteColumnPanel : ["+event.getTrId()+" ,columnName: "+event.getColumnName()+"]");
		if (uiStateType == UIStateType.TR_OPEN) {
			if (state == ToolBoxPanelState.OPENED) {
				toolBox.openDeleteColumnTab(event.getTrId(), event.getColumnName());
				Log.debug("ToolBoxPanelSTate.OPENED Add Tabs");
			} else {
				enable();
				expand();
				state = ToolBoxPanelState.OPENED;
				toolBox.openDeleteColumnTab(event.getTrId(), event.getColumnName());
			}
		} else {
			Log.debug("ToolBoxPanel No table open");
		}
	}
	
	protected void doLabelColumnTab(WidgetRequestEvent event){
		Log.debug("WidgetRequestEvent.LabelColumnPanel : ["+event.getTrId()+" ,columnName: "+event.getColumnName()+"]");
		if (uiStateType == UIStateType.TR_OPEN) {
			if (state == ToolBoxPanelState.OPENED) {
				toolBox.openLabelColumnTab(event.getTrId(), event.getColumnName());
				Log.debug("ToolBoxPanelSTate.OPENED Add Tabs");
			} else {
				enable();
				expand();
				state = ToolBoxPanelState.OPENED;
				toolBox.openLabelColumnTab(event.getTrId(), event.getColumnName());
			}
		} else {
			Log.debug("ToolBoxPanel No table open");
		}
	}
	
	
	
	protected void doPropertiesOpenTab(){
		if (uiStateType == UIStateType.TR_OPEN) {
			if (state == ToolBoxPanelState.OPENED) {
				toolBox.openPropertiesTab();
				Log.debug("ToolBoxPanelSTate.OPENED Add Tabs");
			} else {
				enable();
				expand();
				state = ToolBoxPanelState.OPENED;
				toolBox.openPropertiesTab();
			}
		} else {
			Log.debug("ToolBoxPanel No table open");
		}
	
	
	}
	
	protected void doHelpTab(){
		Log.debug("ToolBoxPanel show help tab");
		enable();
		expand();
		toolBox.showHelpTab();
	}
	
	
	public void closePanelOnly(){
		collapse();
		disable();
		state=ToolBoxPanelState.CLOSED;
	}
	
	public void closePanel(){
		toolBox.closePropertiesTabs();
		toolBox.closeChangeColumnTypePanel();
		toolBox.closeDeleteColumnPanel();
		toolBox.closeLabelColumnPanel();
		Log.debug("ToolBoxPanel Closed");
	}
	
	public void startPanel(){
		enable();
		expand();
		state = ToolBoxPanelState.OPENED;
		toolBox.startTabs();

	}
	
	
	public void updatePanel(){
		if (state == ToolBoxPanelState.OPENED) {	
			toolBox.updateTabs();
			Log.debug("ToolBoxPanel Updated");
		}
	}
	
}
