package org.gcube.portlets.user.td.toolboxwidget.client;


import org.gcube.portlets.user.td.widgetcommonevent.client.event.RibbonEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.UIStateEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.WidgetRequestEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.UIStateType;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.WidgetRequestType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;

import com.allen_sauer.gwt.log.client.Log;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.widget.core.client.ContentPanel;


public class ToolBoxPanel extends ContentPanel {
	
	protected EventBus eventBus;
	protected ToolBox toolBox;
	protected ToolBoxPanelState state;
	protected UIStateType uiStateType;
	protected WidgetRequestType widgetRequestType;
	
	public ToolBoxPanel(String name, EventBus eventBus) {
		super();
		Log.debug("Open ToolBoxPanel");
		this.eventBus=eventBus;
		setId(name);
	    setWidth(310);
		setHeaderVisible(false);
		setResize(true);
		setBodyBorder(false);
		setBorders(false);
		toolBox = new ToolBox("ToolBox",eventBus,this);
		add(toolBox);
		startPanel();
		bindToEvents();
		
	}
	
	protected void bindToEvents() {
		eventBus.addHandler(RibbonEvent.TYPE,
				new RibbonEvent.RibbonEventHandler() {

					
					public void onRibbon(RibbonEvent event) {
						manageRibbonEvents(event);

					}
		});
		
		eventBus.addHandler(WidgetRequestEvent.TYPE,
				new WidgetRequestEvent.WidgetRequestEventHandler() {

					
					public void onWidgetRequest(WidgetRequestEvent event) {
						manageWidgetRequestEvents(event);

					}
		});
		
		
		eventBus.addHandler(
				UIStateEvent.TYPE,
				new UIStateEvent.UIStateHandler() {
					
					
					public void onUIState(UIStateEvent event) {
						manageUIStateEvents(event);
						
					}
	    });
	}
	
	protected void manageRibbonEvents(RibbonEvent event){
		Log.debug("ToolBox recieved event: "+event.getRibbonType().toString());
		switch (event.getRibbonType()){
		case PROPERTIES:
			doPropertiesOpenTab();
			break;
		case HELP:
			doHelpTab();
			break;
		case HISTORY:
			doHistoryTab();	
			break;
			
		default:
			break;
		}
	}
	
	protected void manageUIStateEvents(UIStateEvent event){
		Log.debug("ToolBox recieved event: "+event.getUIStateType().toString());
		uiStateType = event.getUIStateType();
		switch (event.getUIStateType()){
		case START:
			break;
		case TR_CLOSE:
			//this.enable();
			closePanel();
			break;
		case TR_OPEN:
			//this.enable();
			updateForOpenPanel();
			break;
		case TABLECURATION:
			updateForCurationPanel(event.getTrId());
			break;
		case TABLEUPDATE:
			updatePanel();
			break;
		case TR_READONLY:
			break;
		case WIZARD_OPEN:
			//this.disable();
			break;
		default:
			break;
		
		}
	}
	

	protected void manageWidgetRequestEvents(WidgetRequestEvent event){
		Log.debug("ToolBox recieved event: "+event.getWidgetRequestType().toString());
		widgetRequestType = event.getWidgetRequestType();
		switch (event.getWidgetRequestType()){
		case CHANGECOLUMNTYPEPANEL:
			doColumnTypeChangeTab(event);
			break;
		case ADDCOLUMNPANEL:
			doAddColumnTab(event);
			break;
		case DELETECOLUMNPANEL:
			doDeleteColumnTab(event);
			break;
		case SPLITCOLUMNPANEL:
			doSplitColumnTab(event);
			break;	
		case MERGECOLUMNPANEL:
			doMergeColumnTab(event);
			break;
		case LABELCOLUNPANEL:
			doLabelColumnTab(event);
			break;	
		case CHANGETABLETYPEPANEL:
			doChangeTableTypeTab(event);
			break;	
		case DUPLICATESROWSPANEL:
			doDuplicatesRowsTab(event);
			break;	
		case VALIDATIONSTASKSPANEL:
			doValidationsTasksTab(event);
		default:
			break;
		
		}
	}
	
	protected void doHistoryTab(){
		if (uiStateType == UIStateType.TR_OPEN
				|| uiStateType == UIStateType.TABLECURATION
				|| uiStateType == UIStateType.TABLEUPDATE) {
			if (state == ToolBoxPanelState.OPENED) {
				toolBox.openHistoryTab();
				Log.debug("ToolBoxPanelSTate.OPENED Add Tabs");
			} else {
				enable();
				expand();
				state = ToolBoxPanelState.OPENED;
				toolBox.openHistoryTab();
			}
		} else {
			Log.debug("ToolBoxPanel No table open");
		}
	}
	
	
	
	protected void doColumnTypeChangeTab(WidgetRequestEvent event){
		Log.debug("WidgetRequestEvent.CHANGECOLUMNTYPEPANEL : ["+event.getTrId()+" ,columnName: "+event.getColumnName()+"]");
		if (uiStateType == UIStateType.TR_OPEN
				|| uiStateType == UIStateType.TABLECURATION
				|| uiStateType == UIStateType.TABLEUPDATE) {
			if (state == ToolBoxPanelState.OPENED) {
				toolBox.openColumnTypeChangeTab(event.getTrId(), event.getColumnName());
				Log.debug("ToolBoxPanelSTate.OPENED Add Tabs");
			} else {
				enable();
				expand();
				state = ToolBoxPanelState.OPENED;
				toolBox.openColumnTypeChangeTab(event.getTrId(), event.getColumnName());
			}
		} else {
			Log.debug("ToolBoxPanel No table open");
		}
	}
	
	protected void doAddColumnTab(WidgetRequestEvent event){
		Log.debug("WidgetRequestEvent.AddColumnPanel : ["+event.getTrId()+"]");
		if (uiStateType == UIStateType.TR_OPEN
				|| uiStateType == UIStateType.TABLECURATION
				|| uiStateType == UIStateType.TABLEUPDATE) {
			if (state == ToolBoxPanelState.OPENED) {
				toolBox.openAddColumnTab(event.getTrId());
				Log.debug("ToolBoxPanelSTate.OPENED Add Tabs");
			} else {
				enable();
				expand();
				state = ToolBoxPanelState.OPENED;
				toolBox.openAddColumnTab(event.getTrId());
			}
		} else {
			Log.debug("ToolBoxPanel No table open");
		}
	}
	
	
	protected void doDeleteColumnTab(WidgetRequestEvent event){
		Log.debug("WidgetRequestEvent.DeleteColumnPanel : ["+event.getTrId()+" ,columnName: "+event.getColumnName()+"]");
		if (uiStateType == UIStateType.TR_OPEN
				|| uiStateType == UIStateType.TABLECURATION
				|| uiStateType == UIStateType.TABLEUPDATE) {
			if (state == ToolBoxPanelState.OPENED) {
				toolBox.openDeleteColumnTab(event.getTrId(), event.getColumnName());
				Log.debug("ToolBoxPanelSTate.OPENED Add Tabs");
			} else {
				enable();
				expand();
				state = ToolBoxPanelState.OPENED;
				toolBox.openDeleteColumnTab(event.getTrId(), event.getColumnName());
			}
		} else {
			Log.debug("ToolBoxPanel No table open");
		}
	}
	
	protected void doSplitColumnTab(WidgetRequestEvent event){
		Log.debug("WidgetRequestEvent.SplitColumnPanel : ["+event.getTrId()+" ,columnName: "+event.getColumnName()+"]");
		if (uiStateType == UIStateType.TR_OPEN
				|| uiStateType == UIStateType.TABLECURATION
				|| uiStateType == UIStateType.TABLEUPDATE) {
			if (state == ToolBoxPanelState.OPENED) {
				toolBox.openSplitColumnTab(event.getTrId(), event.getColumnName());
				Log.debug("ToolBoxPanelSTate.OPENED Add Tabs");
			} else {
				enable();
				expand();
				state = ToolBoxPanelState.OPENED;
				toolBox.openLabelColumnTab(event.getTrId(), event.getColumnName());
			}
		} else {
			Log.debug("ToolBoxPanel No table open");
		}
	}
	
	
	protected void doMergeColumnTab(WidgetRequestEvent event){
		Log.debug("WidgetRequestEvent.MergeColumnPanel : ["+event.getTrId()+" ,columnName: "+event.getColumnName()+"]");
		if (uiStateType == UIStateType.TR_OPEN
				|| uiStateType == UIStateType.TABLECURATION
				|| uiStateType == UIStateType.TABLEUPDATE) {
			if (state == ToolBoxPanelState.OPENED) {
				toolBox.openMergeColumnTab(event.getTrId(), event.getColumnName());
				Log.debug("ToolBoxPanelSTate.OPENED Add Tabs");
			} else {
				enable();
				expand();
				state = ToolBoxPanelState.OPENED;
				toolBox.openLabelColumnTab(event.getTrId(), event.getColumnName());
			}
		} else {
			Log.debug("ToolBoxPanel No table open");
		}
	}
	
	
	
	protected void doLabelColumnTab(WidgetRequestEvent event){
		Log.debug("WidgetRequestEvent.LabelColumnPanel : ["+event.getTrId()+" ,columnName: "+event.getColumnName()+"]");
		if (uiStateType == UIStateType.TR_OPEN
				|| uiStateType == UIStateType.TABLECURATION
				|| uiStateType == UIStateType.TABLEUPDATE) {
			if (state == ToolBoxPanelState.OPENED) {
				toolBox.openLabelColumnTab(event.getTrId(), event.getColumnName());
				Log.debug("ToolBoxPanelSTate.OPENED Add Tabs");
			} else {
				enable();
				expand();
				state = ToolBoxPanelState.OPENED;
				toolBox.openLabelColumnTab(event.getTrId(), event.getColumnName());
			}
		} else {
			Log.debug("ToolBoxPanel No table open");
		}
	}
	
	
	protected void doChangeTableTypeTab(WidgetRequestEvent event){
		Log.debug("WidgetRequestEvent.ChangeTableTypePanel : ["+event.getTrId()+"]");
		if (uiStateType == UIStateType.TR_OPEN
				|| uiStateType == UIStateType.TABLECURATION
				|| uiStateType == UIStateType.TABLEUPDATE) {
			if (state == ToolBoxPanelState.OPENED) {
				toolBox.openChangeTableTypeTab(event.getTrId());
				Log.debug("ToolBoxPanelSTate.OPENED Add Tabs");
			} else {
				enable();
				expand();
				state = ToolBoxPanelState.OPENED;
				toolBox.openChangeTableTypeTab(event.getTrId());
			}
		} else {
			Log.debug("ToolBoxPanel No table open");
		}
	}
	
	
	protected void doDuplicatesRowsTab(WidgetRequestEvent event){
		Log.debug("WidgetRequestEvent.DuplicateRowsPanel : ["+event.getTrId()+"]");
		if (uiStateType == UIStateType.TR_OPEN
				|| uiStateType == UIStateType.TABLECURATION
				|| uiStateType == UIStateType.TABLEUPDATE) {
			if (state == ToolBoxPanelState.OPENED) {
				toolBox.openDuplicatesRowsTab(event.getTrId());
				Log.debug("ToolBoxPanelSTate.OPENED Add Tabs");
			} else {
				enable();
				expand();
				state = ToolBoxPanelState.OPENED;
				toolBox.openDuplicatesRowsTab(event.getTrId());
			}
		} else {
			Log.debug("ToolBoxPanel No table open");
		}
	}
	
	protected void doValidationsTableTab(WidgetRequestEvent event){
		Log.debug("WidgetRequestEvent.ValidationsTablePanel : ["+event.getTrId()+"]");
		if (uiStateType == UIStateType.TR_OPEN
				|| uiStateType == UIStateType.TABLECURATION
				|| uiStateType == UIStateType.TABLEUPDATE) {
			if (state == ToolBoxPanelState.OPENED) {
				toolBox.openValidationsTableTab(event.getTrId());
				Log.debug("ToolBoxPanelSTate.OPENED Add Tabs");
			} else {
				enable();
				expand();
				state = ToolBoxPanelState.OPENED;
				toolBox.openValidationsTableTab(event.getTrId());
			}
		} else {
			Log.debug("ToolBoxPanel No table open");
		}
	}
	
	
	protected void doValidationsTasksTab(WidgetRequestEvent event){
		Log.debug("WidgetRequestEvent.ValidationsTasksPanel : ["+event.getTrId()+"]");
		if (uiStateType == UIStateType.TR_OPEN
				|| uiStateType == UIStateType.TABLECURATION
				|| uiStateType == UIStateType.TABLEUPDATE) {
			if (state == ToolBoxPanelState.OPENED) {
				toolBox.openValidationsTasksTab(event.getTrId());
				Log.debug("ToolBoxPanelSTate.OPENED Add Tabs");
			} else {
				enable();
				expand();
				state = ToolBoxPanelState.OPENED;
				toolBox.openValidationsTasksTab(event.getTrId());
			}
		} else {
			Log.debug("ToolBoxPanel No table open");
		}
	}
	
	
	
	protected void doPropertiesOpenTab(){
		if (uiStateType == UIStateType.TR_OPEN
				|| uiStateType == UIStateType.TABLECURATION
				|| uiStateType == UIStateType.TABLEUPDATE) {
			if (state == ToolBoxPanelState.OPENED) {
				toolBox.openPropertiesTab();
				Log.debug("ToolBoxPanelSTate.OPENED Add Tabs");
			} else {
				enable();
				expand();
				state = ToolBoxPanelState.OPENED;
				toolBox.openPropertiesTab();
			}
		} else {
			Log.debug("ToolBoxPanel No table open");
		}
	
	
	}
	
	protected void doHelpTab(){
		Log.debug("ToolBoxPanel show help tab");
		enable();
		expand();
		toolBox.showHelpTab();
	}
	
	
	public void closePanelOnly(){
		collapse();
		disable();
		state=ToolBoxPanelState.CLOSED;
	}
	
	public void closePanel(){
		toolBox.closePropertiesTabs();
		toolBox.closeHistoryPanel();
		toolBox.closeChangeColumnTypePanel();
		toolBox.closeAddColumnPanel();
		toolBox.closeDeleteColumnPanel();
		toolBox.closeSplitColumnPanel();
		toolBox.closeMergeColumnPanel();
		toolBox.closeLabelColumnPanel();
		toolBox.closeChangeTableTypePanel();
		toolBox.closeDuplicatesRowsPanel();
		toolBox.closeValidationsTablePanel();
		toolBox.closeValidationsTasksPanel();
		Log.debug("ToolBoxPanel Closed");
	}
	
	public void startPanel(){
		enable();
		expand();
		state = ToolBoxPanelState.OPENED;
		toolBox.startTabs();

	}
	
	
	public void updatePanel(){
		if (state == ToolBoxPanelState.OPENED) {	
			toolBox.updateTabs();
			Log.debug("ToolBoxPanel Updated");
		}
	}
	
	public void updateForOpenPanel(){
		if (state == ToolBoxPanelState.OPENED) {	
			toolBox.updateTabs();
			toolBox.openPropertiesTab();
			Log.debug("ToolBoxPanel Updated For Table");
		} else {
			enable();
			expand();
			state = ToolBoxPanelState.OPENED;
			toolBox.updateTabs();
			toolBox.openPropertiesTab();
			Log.debug("ToolBoxPanel Updated For Table");
		}
	}
	
	public void updateForCurationPanel(TRId trId){
		if (state == ToolBoxPanelState.OPENED) {
			toolBox.updateTabs();
			toolBox.openValidationsTasksTab(trId);
			Log.debug("ToolBoxPanel Updated For Curation");
		} else {
			enable();
			expand();
			state = ToolBoxPanelState.OPENED;
			toolBox.updateTabs();
			toolBox.openValidationsTasksTab(trId);
			Log.debug("ToolBoxPanel Updated For Curation");
		}
	}
	
}
