package org.gcube.portlets.user.td.toolboxwidget.client;

import org.gcube.portlets.user.td.columnwidget.client.ChangeColumnTypePanel;
import org.gcube.portlets.user.td.columnwidget.client.DeleteColumnPanel;
import org.gcube.portlets.user.td.columnwidget.client.LabelColumnPanel;
import org.gcube.portlets.user.td.columnwidget.client.create.AddColumnPanel;
import org.gcube.portlets.user.td.informationwidget.client.TabularResourceProperties;
import org.gcube.portlets.user.td.tablewidget.client.ChangeTableTypePanel;
import org.gcube.portlets.user.td.tablewidget.client.history.HistoryPanel;
import org.gcube.portlets.user.td.tablewidget.client.rows.DuplicatesRowsPanel;
import org.gcube.portlets.user.td.tablewidget.client.validation.ValidationsTablePanel;
import org.gcube.portlets.user.td.tablewidget.client.validation.ValidationsTasksPanel;
import org.gcube.portlets.user.td.toolboxwidget.client.help.HelpPanel;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.tdcolumnoperation.client.MergeColumnPanel;
import org.gcube.portlets.user.tdcolumnoperation.client.SplitColumnPanel;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.ui.Widget;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.TabItemConfig;
import com.sencha.gxt.widget.core.client.TabPanel;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.event.BeforeCloseEvent;
import com.sencha.gxt.widget.core.client.event.BeforeCloseEvent.BeforeCloseHandler;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
//import org.gcube.portlets.user.td.taskswidget.client.TdTaskController;

public class ToolBox extends TabPanel {

	protected EventBus eventBus;
	protected TabularResourceProperties trProperties;
	protected ToolBoxPanel toolBoxPanel;
	protected HelpPanel helpPanel;
	protected ChangeColumnTypePanel changeColumnTypePanel;
	protected AddColumnPanel addColumnPanel;
	protected DeleteColumnPanel deleteColumnPanel;
	protected LabelColumnPanel labelColumnPanel;
	protected ChangeTableTypePanel changeTableTypePanel;
	protected ValidationsTablePanel validationsTablePanel;
	protected ValidationsTasksPanel validationsTasksPanel;
	protected DuplicatesRowsPanel duplicatesRowsPanel;
	protected HistoryPanel historyPanel;
	protected SplitColumnPanel splitColumnPanel;
	protected MergeColumnPanel mergeColumnPanel;
	
	// protected TdTaskController tdTaskController;
	// protected DialogBox tdTaskMainWindow;
	protected FramedPanel taskPanel;

	public ToolBox(String name, EventBus eventBus, ToolBoxPanel toolBoxPanel) {
		super();
		Log.debug("Create ToolBox");
		this.eventBus = eventBus;
		this.toolBoxPanel = toolBoxPanel;
		setId(name);
		setBodyBorder(false);
		setBorders(false);
		setAnimScroll(true);
		setTabScroll(true);
		setCloseContextMenu(true);

		// setResizeTabs(true);

	}

	public void startTabs() {
		Log.debug("Start ToolBox Tabs");
		addHelpPanel();
		setActiveWidget(getWidget(0));

	}
	
	public void showHelpTab(){
		Log.debug("Show Help Tab");
		setActiveWidget(helpPanel);
	}
	
	public void openPropertiesTab() {
		Log.debug("Open Properties Tab");
		if (trProperties == null) {
			addTrProperties();
		}
		setActiveWidget(trProperties);

	}
	
	public void openHistoryTab() {
		Log.debug("Open History Tab");
		if (historyPanel == null) {
			addHistoryPanel();
		} 
		setActiveWidget(historyPanel);

	}
	
	public void openColumnTypeChangeTab(TRId trId, String columnName) {
		Log.debug("Open Column Type Change Tab");
		if (changeColumnTypePanel == null) {
			addChangeColumnTypePanel(trId, columnName);
		} else {
			changeColumnTypePanel.update(trId, columnName);
		}
		setActiveWidget(changeColumnTypePanel);

	}
	
	public void openAddColumnTab(TRId trId) {
		Log.debug("Open Add Column Tab");
		if (addColumnPanel == null) {
			addAddColumnPanel(trId);
		} else {
			addColumnPanel.update(trId);
		}
		setActiveWidget(addColumnPanel);

	}
	
	
	public void openDeleteColumnTab(TRId trId, String columnName) {
		Log.debug("Open Delete Column Tab");
		if (deleteColumnPanel == null) {
			addDeleteColumnPanel(trId, columnName);
		} else {
			deleteColumnPanel.update(trId, columnName);
		}
		setActiveWidget(deleteColumnPanel);

	}
	
	public void openSplitColumnTab(TRId trId, String columnName) {
		Log.debug("Open Split Column Tab");
		if (splitColumnPanel == null) {
			addSplitColumnPanel(trId, columnName);
		} else {
			splitColumnPanel.update(trId, columnName);
		}
		setActiveWidget(splitColumnPanel);

	}
	
	public void openMergeColumnTab(TRId trId, String columnName) {
		Log.debug("Open Merge Column Tab");
		if (mergeColumnPanel == null) {
			addMergeColumnPanel(trId, columnName);
		} else {
			mergeColumnPanel.update(trId, columnName);
		}
		setActiveWidget(mergeColumnPanel);

	}

	
	
	public void openLabelColumnTab(TRId trId, String columnName) {
		Log.debug("Open Label Column Tab");
		if (labelColumnPanel == null) {
			addLabelColumnPanel(trId, columnName);
		} else {
			labelColumnPanel.update(trId, columnName);
		}
		setActiveWidget(labelColumnPanel);

	}
	
	public void openChangeTableTypeTab(TRId trId) {
		Log.debug("Open Change Table Type Tab");
		if (changeTableTypePanel == null) {
			addChangeTableTypePanel(trId);
		} else {
			changeTableTypePanel.update(trId);
		}
		setActiveWidget(changeTableTypePanel);

	}
	
	public void openValidationsTableTab(TRId trId) {
		Log.debug("Open Validations Table Tab: "+trId);
		if (validationsTablePanel == null) {
			addValidationsTablePanel(trId);
		} 
		setActiveWidget(validationsTablePanel);

	}
	
	public void openValidationsTasksTab(TRId trId) {
		Log.debug("Open Validations Tasks Tab: "+trId);
		if (validationsTasksPanel == null) {
			addValidationsTasksPanel(trId);
		} 
		setActiveWidget(validationsTasksPanel);

	}

	
	public void openDuplicatesRowsTab(TRId trId) {
		Log.debug("Open Duplicates Rows Tab");
		if (duplicatesRowsPanel == null) {
			addDuplicatesRowsPanel(trId);
		} else {
			duplicatesRowsPanel.update(trId);
		}
		setActiveWidget(duplicatesRowsPanel);

	}
	
	

	
	//Close
	public void closePropertiesTabs() {
		Log.debug("Close Properties Tab");
		if (trProperties != null) {
			remove(trProperties);
			trProperties = null;
		}

	}
	
	public void closeHistoryPanel() {
		Log.debug("Close History Tab");
		if (historyPanel != null) {
			remove(historyPanel);
			historyPanel = null;
		}

	}

	
	public void closeChangeColumnTypePanel() {
		Log.debug("Close ChangeColumnTypePanel Tab");
		if (changeColumnTypePanel != null) {
			remove(changeColumnTypePanel);
			changeColumnTypePanel = null;
		}
	}

	public void closeDeleteColumnPanel() {
		Log.debug("Close DeleteColumnPanel Tab");
		if (deleteColumnPanel != null) {
			remove(deleteColumnPanel);
			deleteColumnPanel = null;
		}
	}
	
	public void closeSplitColumnPanel() {
		Log.debug("Close SplitColumnPanel Tab");
		if (splitColumnPanel != null) {
			remove(splitColumnPanel);
			splitColumnPanel = null;
		}
	}
	
	public void closeMergeColumnPanel() {
		Log.debug("Close MergeColumnPanel Tab");
		if (mergeColumnPanel != null) {
			remove(mergeColumnPanel);
			mergeColumnPanel = null;
		}
	}
	
	
	
	public void closeAddColumnPanel() {
		Log.debug("Close AddColumnPanel Tab");
		if (addColumnPanel != null) {
			remove(addColumnPanel);
			addColumnPanel = null;
		}
	}
	

	public void closeLabelColumnPanel() {
		Log.debug("Close LabelColumnPanel Tab");
		if (labelColumnPanel != null) {
			remove(labelColumnPanel);
			labelColumnPanel = null;
		}
	}
	
	public void closeChangeTableTypePanel() {
		Log.debug("Close ChangeTableTypePanel Tab");
		if (changeTableTypePanel != null) {
			remove(changeTableTypePanel);
			changeTableTypePanel = null;
		}
	}
	
	public void closeValidationsTablePanel() {
		Log.debug("Close Validations Table Panel Tab");
		if (validationsTablePanel != null) {
			remove(validationsTablePanel);
			validationsTablePanel = null;
		}
	}
	
	public void closeValidationsTasksPanel() {
		Log.debug("Close Validations Tasks Panel Tab");
		if (validationsTasksPanel != null) {
			remove(validationsTasksPanel);
			validationsTasksPanel = null;
		}
	}
	
	
	public void closeDuplicatesRowsPanel() {
		Log.debug("Close DuplicatesRowsPanel Tab");
		if (duplicatesRowsPanel != null) {
			remove(duplicatesRowsPanel);
			duplicatesRowsPanel = null;
		}
	}
	

	
	public void updateTabs() {
		Log.debug("Update ToolBox Tabs");
		if (trProperties != null) {
			trProperties.update();
		}
		if (historyPanel != null) {
			historyPanel.update();
		}
		
		if (validationsTablePanel != null) {
			validationsTablePanel.update();
			
		}
		
		if (validationsTasksPanel != null) {
			validationsTasksPanel.update();
			
		}
		
		if (changeColumnTypePanel != null) {
			remove(changeColumnTypePanel);
			changeColumnTypePanel = null;
		}
		if (deleteColumnPanel != null) {
			remove(deleteColumnPanel);
			deleteColumnPanel = null;
		}
		
		if (splitColumnPanel != null) {
			remove(splitColumnPanel);
			splitColumnPanel = null;
		}
		
		if (mergeColumnPanel != null) {
			remove(mergeColumnPanel);
			mergeColumnPanel = null;
		}
		
		
		if (addColumnPanel != null) {
			remove(addColumnPanel);
			addColumnPanel = null;
		}
		
		if (labelColumnPanel != null) {
			remove(labelColumnPanel);
			labelColumnPanel = null;
		}
		if (changeTableTypePanel != null) {
			remove(changeTableTypePanel);
			changeTableTypePanel = null;
		}
		
		if (duplicatesRowsPanel != null) {
			remove(duplicatesRowsPanel);
			duplicatesRowsPanel = null;
		}
		
		

	}

	protected void addHelpPanel() {
		TabItemConfig propertiesItemConf = new TabItemConfig("Help", false);

		helpPanel = new HelpPanel("Help", eventBus);
		helpPanel.setHeaderVisible(false);
		add(helpPanel, propertiesItemConf);

	};

	protected void addTrProperties() {
		TabItemConfig propertiesItemConf = new TabItemConfig("Properties", true);

		trProperties = new TabularResourceProperties("TRProperties", eventBus);
		trProperties.setHeaderVisible(false);
		add(trProperties, propertiesItemConf);

		addBeforeCloseHandler(new BeforeCloseHandler<Widget>() {

			public void onBeforeClose(BeforeCloseEvent<Widget> event) {
				if (trProperties == event.getItem()) {
					remove(trProperties);
					trProperties = null;
				}
			}

		});
	};
	
	protected void addHistoryPanel() {
		TabItemConfig historyPanelItemConf = new TabItemConfig("History", true);

		historyPanel = new HistoryPanel(eventBus);
		add(historyPanel, historyPanelItemConf);
		addBeforeCloseHandler(new BeforeCloseHandler<Widget>() {

			public void onBeforeClose(BeforeCloseEvent<Widget> event) {
				if (historyPanel == event.getItem()) {
					remove(historyPanel);
					historyPanel = null;
				}
			}

		});
	};

	
	protected void addChangeColumnTypePanel(TRId trId, String columnName) {
		TabItemConfig changeColumnTypeItemConf = new TabItemConfig(
				"Column Type", true);

		changeColumnTypePanel = new ChangeColumnTypePanel(trId, columnName,
				eventBus);
		add(changeColumnTypePanel, changeColumnTypeItemConf);

		addBeforeCloseHandler(new BeforeCloseHandler<Widget>() {

			public void onBeforeClose(BeforeCloseEvent<Widget> event) {
				if (changeColumnTypePanel == event.getItem()) {
					remove(changeColumnTypePanel);
					changeColumnTypePanel = null;

				}

			}

		});
	};

	
	
	protected void addAddColumnPanel(TRId trId) {
		TabItemConfig addColumnItemConf = new TabItemConfig(
				"Add Column", true);

		addColumnPanel = new AddColumnPanel(trId,eventBus);
		add(addColumnPanel, addColumnItemConf);

		addBeforeCloseHandler(new BeforeCloseHandler<Widget>() {

			public void onBeforeClose(BeforeCloseEvent<Widget> event) {
				if (addColumnPanel == event.getItem()) {
					remove(addColumnPanel);
					addColumnPanel = null;

				}

			}

		});
	};

	

	protected void addDeleteColumnPanel(TRId trId, String columnName) {
		TabItemConfig deleteColumnItemConf = new TabItemConfig(
				"Column Delete", true);

		deleteColumnPanel = new DeleteColumnPanel(trId, columnName,
				eventBus);
		add(deleteColumnPanel, deleteColumnItemConf);

		addBeforeCloseHandler(new BeforeCloseHandler<Widget>() {

			public void onBeforeClose(BeforeCloseEvent<Widget> event) {
				if (deleteColumnPanel == event.getItem()) {
					remove(deleteColumnPanel);
					deleteColumnPanel = null;

				}

			}

		});
	};

	protected void addSplitColumnPanel(TRId trId, String columnName) {
		TabItemConfig splitColumnItemConf = new TabItemConfig(
				"Column Split", true);

		splitColumnPanel = new SplitColumnPanel(trId, columnName,
				eventBus);
		add(splitColumnPanel, splitColumnItemConf);

		addBeforeCloseHandler(new BeforeCloseHandler<Widget>() {

			public void onBeforeClose(BeforeCloseEvent<Widget> event) {
				if (splitColumnPanel == event.getItem()) {
					remove(splitColumnPanel);
					splitColumnPanel = null;

				}

			}

		});
	};
	
	
	protected void addMergeColumnPanel(TRId trId, String columnName) {
		TabItemConfig mergeColumnItemConf = new TabItemConfig(
				"Column Merge", true);

		mergeColumnPanel = new MergeColumnPanel(trId, columnName,
				eventBus);
		add(mergeColumnPanel, mergeColumnItemConf);

		addBeforeCloseHandler(new BeforeCloseHandler<Widget>() {

			public void onBeforeClose(BeforeCloseEvent<Widget> event) {
				if (mergeColumnPanel == event.getItem()) {
					remove(mergeColumnPanel);
					mergeColumnPanel = null;

				}

			}

		});
	};
	
	
	protected void addLabelColumnPanel(TRId trId, String columnName) {
		TabItemConfig labelColumnItemConf = new TabItemConfig(
				"Column Label", true);

		labelColumnPanel = new LabelColumnPanel(trId, columnName,
				eventBus);
		add(labelColumnPanel, labelColumnItemConf);

		addBeforeCloseHandler(new BeforeCloseHandler<Widget>() {

			public void onBeforeClose(BeforeCloseEvent<Widget> event) {
				if (labelColumnPanel == event.getItem()) {
					remove(labelColumnPanel);
					labelColumnPanel = null;

				}

			}

		});
	};
	
	protected void addChangeTableTypePanel(TRId trId) {
		TabItemConfig changeTableTypeItemConf = new TabItemConfig(
				"Table Type", true);

		changeTableTypePanel = new ChangeTableTypePanel(trId,
				eventBus);
		add(changeTableTypePanel, changeTableTypeItemConf);

		addBeforeCloseHandler(new BeforeCloseHandler<Widget>() {

			public void onBeforeClose(BeforeCloseEvent<Widget> event) {
				if (changeTableTypePanel == event.getItem()) {
					remove(changeTableTypePanel);
					changeTableTypePanel = null;

				}

			}

		});
	};
	
	
	protected void addValidationsTablePanel(TRId trId) {
		TabItemConfig validationsTableItemConf = new TabItemConfig(
				"Validations", true);

		validationsTablePanel = new ValidationsTablePanel(trId,
				eventBus);
		add(validationsTablePanel, validationsTableItemConf);

		addBeforeCloseHandler(new BeforeCloseHandler<Widget>() {

			public void onBeforeClose(BeforeCloseEvent<Widget> event) {
				if (validationsTablePanel == event.getItem()) {
					remove(validationsTablePanel);
					validationsTablePanel = null;

				}

			}

		});
	};
	
	protected void addValidationsTasksPanel(TRId trId) {
		TabItemConfig validationsTasksItemConf = new TabItemConfig(
				"Validations", true);

		validationsTasksPanel = new ValidationsTasksPanel(trId,
				eventBus);
		add(validationsTasksPanel, validationsTasksItemConf);

		addBeforeCloseHandler(new BeforeCloseHandler<Widget>() {

			public void onBeforeClose(BeforeCloseEvent<Widget> event) {
				if (validationsTasksPanel == event.getItem()) {
					remove(validationsTasksPanel);
					validationsTasksPanel = null;

				}

			}

		});
	};
	
	
	
	protected void addDuplicatesRowsPanel(TRId trId) {
		TabItemConfig duplicatesRowsDeleteItemConf = new TabItemConfig(
				"Duplicate", true);

		duplicatesRowsPanel = new DuplicatesRowsPanel(trId,
				eventBus);
		add(duplicatesRowsPanel, duplicatesRowsDeleteItemConf);

		addBeforeCloseHandler(new BeforeCloseHandler<Widget>() {

			public void onBeforeClose(BeforeCloseEvent<Widget> event) {
				if (duplicatesRowsPanel == event.getItem()) {
					remove(duplicatesRowsPanel);
					duplicatesRowsPanel = null;

				}

			}

		});
	};
	

	
	
	
	protected void addTdTaskPanel() {
		//TODO 
		// tdTaskController = TdTaskController.getInstance();
		// tdTaskController.bindCommonBus(eventBus);
		// tdTaskMainWindow = tdTaskController.getWindowTaskMonitor(); // This
		// is main panel

		taskPanel = new FramedPanel();
		taskPanel.setHeaderVisible(false);
		TextButton buttonTask = new TextButton("Tasks");
		buttonTask.addSelectHandler(new SelectEvent.SelectHandler() {

			public void onSelect(SelectEvent event) {
				// tdTaskMainWindow.show();

			}

		});

		taskPanel.add(buttonTask);

		TabItemConfig tdTasksItemConf = new TabItemConfig("Tasks", true);

		add(taskPanel, tdTasksItemConf);
		addBeforeCloseHandler(new BeforeCloseHandler<Widget>() {

			public void onBeforeClose(BeforeCloseEvent<Widget> event) {
				if (getWidgetCount() == 1) {
					toolBoxPanel.closePanelOnly();
					remove(taskPanel);
				}

			}

		});

	}

}
