/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.transect.server.readers;

import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portlets.user.transect.server.readers.entity.RuntimeProperty;
import org.gcube.portlets.user.transect.server.readers.entity.ServiceAccessPoint;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeResourceReader {
    public static final Logger logger = LoggerFactory.getLogger(RuntimeResourceReader.class);
    public List<ServiceAccessPoint> serviceAccessPoints;
    private String resourceName;
    private String scope;
    private String entryName;
    private HashMap<String, RuntimeProperty> runtimeProperties;

    public RuntimeResourceReader(String scope, String resourceName) throws Exception {
        this.scope = scope;
        this.resourceName = resourceName;
        this.readResource(scope, resourceName);
    }

    private void readResource(String scope, String resourceName) throws Exception {
        try {
            logger.info("Tentative read resource: " + resourceName + ", scope: " + scope);
            this.resourceName = resourceName;
            this.scope = scope;
            logger.info("Instancing scope: " + scope);
            ScopeProvider.instance.set(scope);
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
            query.addCondition("$resource/Profile/Name/string() eq '" + resourceName + "'");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
            List r = client.submit((Query)query);
            if (r == null || r.isEmpty()) {
                throw new Exception("Cannot retrieve the runtime resource: " + resourceName + " in scope: " + scope);
            }
            ServiceEndpoint se = (ServiceEndpoint)r.get(0);
            if (se.profile() == null) {
                throw new Exception("IS profile is null for resource: " + resourceName);
            }
            Group accessPoints = se.profile().accessPoints();
            if (accessPoints.size() == 0) {
                throw new Exception("Accesspoint in resource " + resourceName + " not found");
            }
            Iterator acIt = accessPoints.iterator();
            this.serviceAccessPoints = new ArrayList(accessPoints.size());
            while (acIt.hasNext()) {
                ServiceEndpoint.AccessPoint ap = (ServiceEndpoint.AccessPoint)acIt.next();
                Group properties = ap.properties();
                if (properties.size() == 0) {
                    logger.warn("Properties in resource " + resourceName + " not found");
                    continue;
                }
                this.runtimeProperties = new HashMap(properties.size());
                for (ServiceEndpoint.Property prop : properties) {
                    this.runtimeProperties.put(prop.name(), new RuntimeProperty(prop.name(), prop.value(), true));
                }
                String decryptedPassword = StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0]);
                this.serviceAccessPoints.add(new ServiceAccessPoint(ap.name(), ap.address(), ap.username(), decryptedPassword, this.runtimeProperties));
            }
        }
        catch (Exception e) {
            logger.error("Sorry, an error occurred on reading " + resourceName + " Runtime Reosurce", (Throwable)e);
            throw new Exception("Sorry, an error occurred on reading the resource " + resourceName + " Runtime Reosurce");
        }
    }

    public ServiceAccessPoint getServiceAccessPointForEntryName(String entryName) {
        for (ServiceAccessPoint serviceAccessPoint : this.serviceAccessPoints) {
            if (!serviceAccessPoint.getEntryName().equals(entryName)) continue;
            return serviceAccessPoint;
        }
        return null;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public String getScope() {
        return this.scope;
    }

    public List<ServiceAccessPoint> getServiceAccessPoints() {
        return this.serviceAccessPoints;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RuntimeResourceReader [serviceAccessPoints=");
        builder.append(this.serviceAccessPoints);
        builder.append(", resourceName=");
        builder.append(this.resourceName);
        builder.append(", scope=");
        builder.append(this.scope);
        builder.append(", entryName=");
        builder.append(this.entryName);
        builder.append(", runtimeProperties=");
        builder.append(this.runtimeProperties);
        builder.append("]");
        return builder.toString();
    }

    public static void main(String[] args) {
        try {
            RuntimeResourceReader rr = new RuntimeResourceReader("/gcube/devsec/devVRE", "TransectGeoDatabase");
            System.out.println(rr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

