/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlet.user.userstatisticsportlet.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.WebsiteLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portlet.user.userstatisticsportlet.client.UserStatisticsService;
import org.gcube.portlet.user.userstatisticsportlet.shared.PostsStatsBean;
import org.gcube.portlet.user.userstatisticsportlet.shared.UserInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class UserStatisticsServiceImpl
extends RemoteServiceServlet
implements UserStatisticsService {
    private static final Logger _log = LoggerFactory.getLogger(UserStatisticsServiceImpl.class);
    public static final String userid = "test.user";
    private static final String vreID = "/gcube/devsec/devVRE";
    private DatabookStore store;

    public void init() {
        _log.debug("Getting connection to Cassandra..");
        this.store = new DBCassandraAstyanaxImpl();
    }

    public void destroy() {
        _log.debug("Closing connection to Cassandra");
        this.store.closeConnection();
    }

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.warn("USER IS NULL setting test.user and Running OUTSIDE PORTAL");
            user = this.getDevelopmentUser();
            SessionManager.getInstance().getASLSession(sessionID, user).setScope("/gcube/devsec/devVRE");
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    private boolean isInfrastructureScope() {
        boolean toReturn = false;
        try {
            ScopeBean scope = new ScopeBean(this.getASLSession().getScope());
            toReturn = scope.is(ScopeBean.Type.INFRASTRUCTURE);
            return toReturn;
        }
        catch (NullPointerException e) {
            _log.error("NullPointerException in isInfrastructureScope returning false");
            return false;
        }
    }

    private boolean isWithinPortal() {
        try {
            UserLocalServiceUtil.getService();
            return true;
        }
        catch (BeanLocatorException ex) {
            _log.trace("Development Mode ON");
            return false;
        }
    }

    public String getDevelopmentUser() {
        String user = "test.user";
        return user;
    }

    public String getTotalSpaceInUse() {
        String storageInUse = null;
        ASLSession session = this.getASLSession();
        String userName = session.getUsername();
        if (userName.compareTo("test.user") == 0) {
            _log.debug("Found " + userName + " returning nothing");
            return null;
        }
        _log.debug("Getting " + userName + " amount of workspace in use.");
        try {
            long init = System.currentTimeMillis();
            Workspace workspace = HomeLibrary.getUserWorkspace((String)userName);
            long storage = workspace.getDiskUsage();
            storageInUse = UserStatisticsServiceImpl.formatFileSize((long)storage);
            long end = System.currentTimeMillis();
            _log.debug("[USER-STATISTICS] time taken to retrieve user space is " + (end - init) + "ms");
        }
        catch (Exception e) {
            _log.error("Unable to retrieve workspace information!");
        }
        return storageInUse;
    }

    public int getProfileStrength() {
        int profileStrenght = -1;
        ASLSession session = this.getASLSession();
        String userName = session.getUsername();
        if (userName.compareTo("test.user") == 0) {
            _log.debug("Found " + userName + " returning nothing");
            return profileStrenght;
        }
        if (this.isWithinPortal()) {
            try {
                boolean avatarPresent = session.getUserAvatarId() != null;
                long init = System.currentTimeMillis();
                User user = OrganizationsUtil.validateUser((String)userName);
                profileStrenght = UserStatisticsServiceImpl.evaluateProfileStrenght((User)user, (boolean)avatarPresent);
                long end = System.currentTimeMillis();
                _log.debug("[USER-STATISTICS] time taken to evaluate user profile strenght is " + (end - init) + "ms");
            }
            catch (Exception e) {
                _log.error("Profile strenght evaluation failed!!");
            }
        }
        return profileStrenght;
    }

    public UserInformation getUserSettings() {
        ASLSession session = this.getASLSession();
        String userName = session.getUsername();
        if (userName.compareTo("test.user") == 0) {
            _log.debug("Found " + userName + " returning nothing");
            return null;
        }
        if (this.isWithinPortal()) {
            boolean isInfrastructure = this.isInfrastructureScope();
            _log.debug("User scope is " + (isInfrastructure ? " the whole infrastucture " : " a VRE"));
            String thumbnailURL = session.getUserAvatarId();
            _log.debug(userName + " avatar has url " + thumbnailURL);
            String actualVre = null;
            if (!isInfrastructure) {
                String[] temp = session.getScope().split("/");
                actualVre = temp[temp.length - 1];
            }
            String accountURL = null;
            ThemeDisplay themeDisplay = (ThemeDisplay)this.getThreadLocalRequest().getSession().getAttribute("THEME_DISPLAY");
            accountURL = themeDisplay.getURLMyAccount().toString();
            _log.debug("Account url for " + userName + " is " + accountURL);
            return new UserInformation(isInfrastructure, thumbnailURL, userName, actualVre, accountURL);
        }
        return new UserInformation(false, null, userName, "/gcube/devsec/devVRE", null);
    }

    public PostsStatsBean getPostsStats() {
        ASLSession session = this.getASLSession();
        String userName = session.getUsername();
        if (userName.compareTo("test.user") == 0) {
            _log.debug("Found " + userName + " returning nothing");
            return null;
        }
        long totalFeeds = 0L;
        long totalLikes = 0L;
        long totalComments = 0L;
        boolean isInfrastructure = this.isInfrastructureScope();
        Date oneYearAgo = new Date();
        oneYearAgo.setYear(oneYearAgo.getYear() - 1);
        _log.debug("Reference time is " + oneYearAgo.toString());
        try {
            long init = System.currentTimeMillis();
            _log.debug("Getting " + userName + " feeds in the last year.");
            List userFeeds = this.store.getRecentFeedsByUserAndDate(userName, oneYearAgo.getTime());
            _log.debug("Evaluating number of comments and likes of " + userName + "'s feeds.");
            for (Feed feed : userFeeds) {
                try {
                    if (!isInfrastructure && !feed.getVreid().equals(session.getScope())) continue;
                    ++totalFeeds;
                    totalComments += (long)Integer.parseInt(feed.getCommentsNo());
                    totalLikes += (long)Integer.parseInt(feed.getLikesNo());
                }
                catch (NumberFormatException e) {
                    _log.error(e.toString());
                }
            }
            long end = System.currentTimeMillis();
            _log.debug("[USER-STATISTICS] time taken to retrieve and filter user feeds, get likes and replies got is " + (end - init) + "ms");
            _log.debug("Total number of feeds (after time filtering) of  " + userName + " is " + totalFeeds);
            _log.debug("Total number of likes (after time filtering) for " + userName + " is " + totalLikes);
            _log.debug("Total number of comments (after time filtering) for " + userName + " is " + totalComments);
        }
        catch (Exception e) {
            _log.error(e.toString());
            return null;
        }
        return new PostsStatsBean(totalFeeds, totalLikes, totalComments);
    }

    private static String formatFileSize(long size) {
        String formattedSize = null;
        double b = size;
        double k = (double)size / 1024.0;
        double m = (double)size / 1024.0 / 1024.0;
        double g = (double)size / 1024.0 / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        formattedSize = t >= 1.0 ? dec.format(t).concat(" TB") : (g >= 1.0 ? dec.format(g).concat(" GB") : (m >= 1.0 ? dec.format(m).concat(" MB") : (k >= 1.0 ? dec.format(k).concat(" KB") : dec.format(b).concat(" Bytes"))));
        return formattedSize;
    }

    private static int evaluateProfileStrenght(User user, boolean imageIsPresent) {
        int score = UserStatisticsServiceImpl.evaluateContactScore((User)user);
        return score += UserStatisticsServiceImpl.evaluateInformationScore((User)user, (boolean)imageIsPresent);
    }

    private static int evaluateInformationScore(User user, boolean imageIsPresent) {
        int score = 0;
        score += user.getJobTitle().compareTo("") != 0 ? 20 : 0;
        score += user.getOpenId().compareTo("") != 0 ? 20 : 0;
        String summary = UserStatisticsServiceImpl.getSummary((User)user);
        int lenght = summary.replace(" ", "").length();
        float partialScore = (float)lenght / 10.0f;
        score += partialScore > 20.0f ? 20 : (int)partialScore;
        if (imageIsPresent) {
            score += 5;
        }
        return score;
    }

    private static String getSummary(User user) {
        String toReturn = UserStatisticsServiceImpl.escapeHtml((String)user.getComments());
        toReturn = toReturn.replaceAll("(\r\n|\n)", " <br/> ");
        toReturn = toReturn.replaceAll("\\s\\s", "&nbsp;&nbsp;");
        return toReturn;
    }

    private static String escapeHtml(String html) {
        if (html == null) {
            return null;
        }
        return html.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    private static int evaluateContactScore(User user) {
        int score = 0;
        try {
            Contact contact = user.getContact();
            score += contact.getMySpaceSn().compareTo("") != 0 ? 5 : 0;
            score += contact.getTwitterSn().compareTo("") != 0 ? 5 : 0;
            score += contact.getFacebookSn().compareTo("") != 0 ? 5 : 0;
            score += contact.getSkypeSn().compareTo("") != 0 ? 5 : 0;
            score += contact.getJabberSn().compareTo("") != 0 ? 5 : 0;
            score += contact.getAimSn().compareTo("") != 0 ? 5 : 0;
            List websites = WebsiteLocalServiceUtil.getWebsites((long)user.getCompanyId(), (String)"com.liferay.portal.model.Contact", (long)contact.getContactId());
            score += websites.size() > 0 ? 5 : 0;
        }
        catch (Exception e) {
            _log.error("Contact profile score evaluation failed!!");
            score = 0;
        }
        return score;
    }
}

