/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlet.user.userstatisticsportlet.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.WebsiteLocalServiceUtil;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.List;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.portal.PortalContext;
import org.gcube.portal.custom.communitymanager.SiteManagerUtil;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portlet.user.userstatisticsportlet.client.UserStatisticsService;
import org.gcube.portlet.user.userstatisticsportlet.server.cache.UserInfrastructureSpaceCache;
import org.gcube.portlet.user.userstatisticsportlet.shared.PostsStatsBean;
import org.gcube.portlet.user.userstatisticsportlet.shared.UserInformation;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.util.ManagementUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class UserStatisticsServiceImpl
extends RemoteServiceServlet
implements UserStatisticsService {
    private static final Logger _log = LoggerFactory.getLogger(UserStatisticsServiceImpl.class);
    public static final String defaultUserId = "test.user";
    private static final String vreID = "/gcube/devsec/devVRE";
    private DatabookStore store;
    private static final String CUSTOM_FIELD_NAME_USER_STATISTICS_VISIBILITY = "show_user_statistics_other_people";

    public void init() {
        _log.debug("Getting connection to Cassandra..");
        this.store = new DBCassandraAstyanaxImpl();
        this.createUserCustomField("show_user_statistics_other_people", true);
    }

    public void destroy() {
        _log.info("Closing connection to Cassandra");
        this.store.closeConnection();
    }

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.warn("USER IS NULL setting test.user and Running OUTSIDE PORTAL");
            user = this.getDevelopmentUser();
            SessionManager.getInstance().getASLSession(sessionID, user).setScope("/gcube/devsec/devVRE");
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    private boolean isInfrastructureScope(String userid) {
        boolean toReturn = false;
        try {
            LiferayGroupManager manager = new LiferayGroupManager();
            long groupId = manager.getGroupIdFromInfrastructureScope(this.getASLSession().getScope());
            toReturn = manager.isVRE(groupId) == false || userid != null;
            return toReturn;
        }
        catch (Exception e) {
            _log.error("NullPointerException in isInfrastructureScope returning false");
            return false;
        }
    }

    private boolean isWithinPortal() {
        try {
            UserLocalServiceUtil.getService();
            return true;
        }
        catch (BeanLocatorException ex) {
            _log.trace("Development Mode ON");
            return false;
        }
    }

    public String getDevelopmentUser() {
        String user = "test.user";
        return user;
    }

    public String getTotalSpaceInUse(String userid) {
        String userName;
        String storageInUse = null;
        ASLSession session = this.getASLSession();
        String statisticsOfUsername = userName = session.getUsername();
        if (userid != null && !userid.equals(userName)) {
            statisticsOfUsername = userid;
        }
        if (userName.compareTo("test.user") == 0) {
            _log.debug("Found " + userName + " returning nothing");
            return null;
        }
        _log.debug("Getting " + statisticsOfUsername + " amount of workspace in use.");
        try {
            long init = System.currentTimeMillis();
            UserInfrastructureSpaceCache cacheWorkspace = UserInfrastructureSpaceCache.getCacheInstance();
            Long storageInUseLong = cacheWorkspace.get(statisticsOfUsername);
            if (storageInUseLong == null) {
                _log.debug("Information not available in the cache, asking workspace");
                Workspace workspace = HomeLibrary.getUserWorkspace((String)statisticsOfUsername);
                storageInUseLong = workspace.getDiskUsage();
                _log.debug("Put information in the cache");
                cacheWorkspace.insert(statisticsOfUsername, storageInUseLong);
            }
            storageInUse = UserStatisticsServiceImpl.formatFileSize((long)storageInUseLong);
            long end = System.currentTimeMillis();
            _log.debug("[USER-STATISTICS] time taken to retrieve user space is " + (end - init) + "ms");
        }
        catch (Exception e) {
            _log.error("Unable to retrieve workspace information!");
        }
        return storageInUse;
    }

    public int getProfileStrength(String userid) {
        String userName;
        int profileStrenght = -1;
        ASLSession session = this.getASLSession();
        String statisticsOfUsername = userName = session.getUsername();
        if (userid != null && !userid.equals(userName)) {
            statisticsOfUsername = userid;
        }
        if (userName.compareTo("test.user") == 0) {
            _log.debug("Found " + userName + " returning nothing");
            return profileStrenght;
        }
        if (this.isWithinPortal()) {
            try {
                long init = System.currentTimeMillis();
                boolean avatarPresent = new LiferayUserManager().getUserAvatarBytes(statisticsOfUsername) != null;
                User user = UserLocalServiceUtil.getUserByScreenName((long)SiteManagerUtil.getCompany().getCompanyId(), (String)statisticsOfUsername);
                profileStrenght = UserStatisticsServiceImpl.evaluateProfileStrenght((User)user, (boolean)avatarPresent);
                long end = System.currentTimeMillis();
                _log.debug("[USER-STATISTICS] time taken to evaluate user profile strenght is " + (end - init) + "ms");
            }
            catch (Exception e) {
                _log.error("Profile strenght evaluation failed!!" + e.toString(), (Throwable)e);
            }
        }
        return profileStrenght;
    }

    public UserInformation getUserSettings(String userid) {
        String userName;
        ASLSession session = this.getASLSession();
        String statisticsOfUsername = userName = session.getUsername();
        boolean isOwner = false;
        boolean isProfileShowable = true;
        if (userid == null || userid != null && userid.equals(userName)) {
            isOwner = true;
            isProfileShowable = this.checkUserPrivacyOption(userName);
        }
        if (userid != null && !userid.equals(userName)) {
            statisticsOfUsername = userid;
            isProfileShowable = this.checkUserPrivacyOption(statisticsOfUsername);
            _log.info("Is profile showable for user " + userid + " " + isProfileShowable);
        }
        if (userName.compareTo("test.user") == 0) {
            _log.debug("Found " + userName + " returning nothing");
            return null;
        }
        if (this.isWithinPortal()) {
            boolean isInfrastructure = this.isInfrastructureScope(userid);
            _log.debug("User scope is " + (isInfrastructure ? " the whole infrastucture " : " a VRE"));
            LiferayUserManager um = new LiferayUserManager();
            String thumbnailURL = null;
            try {
                thumbnailURL = um.getUserByUsername(statisticsOfUsername).getUserAvatarURL();
            }
            catch (UserManagementSystemException e) {
                _log.error("Unable to retrieve avatar url for user " + statisticsOfUsername, (Throwable)e);
            }
            catch (UserRetrievalFault e) {
                _log.error("Unable to retrieve avatar url for user " + statisticsOfUsername, (Throwable)e);
            }
            _log.debug(statisticsOfUsername + " avatar has url " + thumbnailURL);
            String actualVre = null;
            if (!isInfrastructure) {
                String[] temp = session.getScope().split("/");
                actualVre = temp[temp.length - 1];
            }
            String pageLanding = PortalContext.getConfiguration().getSiteLandingPagePath(this.getThreadLocalRequest());
            UserInformation bean = new UserInformation(isInfrastructure, thumbnailURL, userName, actualVre, isOwner, isProfileShowable);
            bean.setCurrentPageLanding(pageLanding);
            return bean;
        }
        return new UserInformation(true, null, userName, "/gcube/devsec/devVRE", true, true);
    }

    private boolean checkUserPrivacyOption(String username) {
        try {
            this.setPermissionChecker();
            CacheRegistryUtil.clear();
            User user = UserLocalServiceUtil.getUserByScreenName((long)ManagementUtils.getCompany().getCompanyId(), (String)username);
            if (!user.getExpandoBridge().hasAttribute("show_user_statistics_other_people")) {
                return true;
            }
            return (Boolean)user.getExpandoBridge().getAttribute("show_user_statistics_other_people");
        }
        catch (Exception e) {
            _log.error("Unable to retrieve user's privacy option for his statistics");
            return true;
        }
    }

    public PostsStatsBean getPostsStats(String userid) {
        String userName;
        ASLSession session = this.getASLSession();
        String statisticsOfUsername = userName = session.getUsername();
        if (userid != null && !userid.equals(userName)) {
            statisticsOfUsername = userid;
        }
        if (userName.compareTo("test.user") == 0) {
            _log.debug("Found " + userName + " returning nothing");
            return null;
        }
        long totalFeeds = 0L;
        long totalLikes = 0L;
        long totalComments = 0L;
        boolean isInfrastructure = this.isInfrastructureScope(userid);
        Calendar oneYearAgo = Calendar.getInstance();
        oneYearAgo.set(1, oneYearAgo.get(1) - 1);
        _log.debug("Reference time is " + oneYearAgo.getTime());
        try {
            long init = System.currentTimeMillis();
            _log.debug("Getting " + statisticsOfUsername + " feeds in the last year.");
            List userFeeds = this.store.getRecentFeedsByUserAndDate(statisticsOfUsername, oneYearAgo.getTime().getTime());
            _log.debug("Evaluating number of comments and likes of " + statisticsOfUsername + "'s feeds.");
            for (Feed feed : userFeeds) {
                try {
                    if (!isInfrastructure && !feed.getVreid().equals(session.getScope())) continue;
                    ++totalFeeds;
                    totalComments += (long)Integer.parseInt(feed.getCommentsNo());
                    totalLikes += (long)Integer.parseInt(feed.getLikesNo());
                }
                catch (NumberFormatException e) {
                    _log.error(e.toString());
                }
            }
            long end = System.currentTimeMillis();
            _log.debug("[USER-STATISTICS] time taken to retrieve and filter user feeds, get likes and replies got is " + (end - init) + "ms");
            _log.debug("Total number of feeds (after time filtering) of  " + statisticsOfUsername + " is " + totalFeeds);
            _log.debug("Total number of likes (after time filtering) for " + statisticsOfUsername + " is " + totalLikes);
            _log.debug("Total number of comments (after time filtering) for " + statisticsOfUsername + " is " + totalComments);
        }
        catch (Exception e) {
            _log.error(e.toString());
            return null;
        }
        return new PostsStatsBean(totalFeeds, totalLikes, totalComments);
    }

    public void setShowMyOwnStatisticsToOtherPeople(boolean show) {
        if (this.isWithinPortal()) {
            ASLSession session = this.getASLSession();
            String username = session.getUsername();
            if (username.compareTo("test.user") == 0) {
                _log.debug("Found " + username + " returning nothing");
                return;
            }
            try {
                this.setPermissionChecker();
                CacheRegistryUtil.clear();
                _log.debug("User " + username + (show ? " want to show " : " doesn't want to show ") + " his statistics");
                User user = UserLocalServiceUtil.getUserByScreenName((long)ManagementUtils.getCompany().getCompanyId(), (String)username);
                boolean hasAttribute = user.getExpandoBridge().hasAttribute("show_user_statistics_other_people");
                if (hasAttribute) {
                    _log.debug("Setting custom field value to " + show + " for user " + username);
                    user.getExpandoBridge().setAttribute("show_user_statistics_other_people", (Serializable)Boolean.valueOf(show));
                }
            }
            catch (Exception e) {
                _log.error("Unable to check user's privacy for his statistics", (Throwable)e);
            }
        }
    }

    private void createUserCustomField(String customFieldNameUserStatisticsVisibility, boolean startingValue) {
        this.setPermissionChecker();
        try {
            User defaultUser = UserLocalServiceUtil.getDefaultUser((long)ManagementUtils.getCompany().getCompanyId());
            boolean exists = defaultUser.getExpandoBridge().hasAttribute(customFieldNameUserStatisticsVisibility);
            if (exists) {
                _log.debug("Custom field already exists... There is no need to create it");
            } else {
                _log.debug("Creating custom field " + customFieldNameUserStatisticsVisibility + " with starting value " + startingValue);
                defaultUser.getExpandoBridge().addAttribute("show_user_statistics_other_people", 1, (Serializable)Boolean.valueOf(true));
            }
        }
        catch (Exception e) {
            _log.error("Unable to create custom field " + customFieldNameUserStatisticsVisibility);
        }
    }

    private static String formatFileSize(long size) {
        String formattedSize = null;
        double b = size;
        double k = (double)size / 1024.0;
        double m = (double)size / 1024.0 / 1024.0;
        double g = (double)size / 1024.0 / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        formattedSize = t >= 1.0 ? dec.format(t).concat(" TB") : (g >= 1.0 ? dec.format(g).concat(" GB") : (m >= 1.0 ? dec.format(m).concat(" MB") : (k >= 1.0 ? dec.format(k).concat(" KB") : dec.format(b).concat(" Bytes"))));
        return formattedSize;
    }

    private static int evaluateProfileStrenght(User user, boolean imageIsPresent) {
        int score = UserStatisticsServiceImpl.evaluateContactScore((User)user);
        return score += UserStatisticsServiceImpl.evaluateInformationScore((User)user, (boolean)imageIsPresent);
    }

    private static int evaluateInformationScore(User user, boolean imageIsPresent) {
        String summary;
        int score = 0;
        if (user.getJobTitle() != null) {
            score += !user.getJobTitle().isEmpty() ? 20 : 0;
        }
        if (user.getOpenId() != null) {
            score += !user.getOpenId().isEmpty() ? 20 : 0;
        }
        if ((summary = UserStatisticsServiceImpl.getSummary((User)user)) != null) {
            int lenght = summary.replace(" ", "").length();
            float partialScore = (float)lenght / 10.0f;
            score += partialScore > 20.0f ? 20 : (int)partialScore;
        }
        if (imageIsPresent) {
            score += 5;
        }
        return score;
    }

    private static String getSummary(User user) {
        if (user.getComments() != null) {
            String toReturn = UserStatisticsServiceImpl.escapeHtml((String)user.getComments());
            toReturn = toReturn.replaceAll("(\r\n|\n)", " <br/> ");
            toReturn = toReturn.replaceAll("\\s\\s", "&nbsp;&nbsp;");
            return toReturn;
        }
        return null;
    }

    private static String escapeHtml(String html) {
        if (html == null) {
            return null;
        }
        return html.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    private static int evaluateContactScore(User user) {
        int score = 0;
        try {
            List websites;
            Contact contact = user.getContact();
            if (contact.getMySpaceSn() != null) {
                score += !contact.getMySpaceSn().isEmpty() ? 5 : 0;
            }
            if (contact.getTwitterSn() != null) {
                score += !contact.getTwitterSn().isEmpty() ? 5 : 0;
            }
            if (contact.getFacebookSn() != null) {
                score += !contact.getFacebookSn().isEmpty() ? 5 : 0;
            }
            if (contact.getSkypeSn() != null) {
                score += !contact.getSkypeSn().isEmpty() ? 5 : 0;
            }
            if (contact.getJabberSn() != null) {
                score += !contact.getJabberSn().isEmpty() ? 5 : 0;
            }
            if (contact.getAimSn() != null) {
                score += !contact.getAimSn().isEmpty() ? 5 : 0;
            }
            score += (websites = WebsiteLocalServiceUtil.getWebsites((long)user.getCompanyId(), (String)"com.liferay.portal.model.Contact", (long)contact.getContactId())).size() > 0 ? 5 : 0;
        }
        catch (Exception e) {
            _log.error("Contact profile score evaluation failed!!");
            score = 0;
        }
        return score;
    }

    private void setPermissionChecker() {
        try {
            long adminId = LiferayUserManager.getAdmin().getUserId();
            PrincipalThreadLocal.setName((long)adminId);
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)UserLocalServiceUtil.getUser((long)adminId));
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        }
        catch (Exception e) {
            _log.error("Unable to set permission checker. Custom fields set/get operations are likely to fail...");
        }
    }
}

