/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlet.user.userstatisticsportlet.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.portal.PortalContext;
import org.gcube.portal.custom.communitymanager.SiteManagerUtil;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portlet.user.userstatisticsportlet.client.UserStatisticsService;
import org.gcube.portlet.user.userstatisticsportlet.server.ServerUtils;
import org.gcube.portlet.user.userstatisticsportlet.server.cache.UserInfrastructureSpaceCache;
import org.gcube.portlet.user.userstatisticsportlet.shared.PostsStatsBean;
import org.gcube.portlet.user.userstatisticsportlet.shared.UserInformation;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.util.ManagementUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserStatisticsServiceImpl
extends RemoteServiceServlet
implements UserStatisticsService {
    private static final Logger logger = LoggerFactory.getLogger(UserStatisticsServiceImpl.class);
    public static final String defaultUserId = "test.user";
    public static final String vreID = "/gcube/devsec/devVRE";
    private DatabookStore store;
    private static final String CUSTOM_FIELD_NAME_USER_STATISTICS_VISIBILITY = "show_user_statistics_other_people";

    public void init() {
        logger.debug("Getting connection to Cassandra..");
        this.store = new DBCassandraAstyanaxImpl();
        ServerUtils.createUserCustomField((String)CUSTOM_FIELD_NAME_USER_STATISTICS_VISIBILITY, (boolean)true);
    }

    public void destroy() {
        logger.info("Closing connection to Cassandra");
        this.store.closeConnection();
    }

    public String getTotalSpaceInUse(String userid) {
        String userName;
        String storageInUse = null;
        ASLSession session = ServerUtils.getASLSession((HttpSession)this.getThreadLocalRequest().getSession());
        String statisticsOfUsername = userName = session.getUsername();
        if (userid != null && !userid.equals(userName)) {
            statisticsOfUsername = userid;
        }
        if (userName.compareTo(defaultUserId) == 0) {
            logger.debug("Found " + userName + " returning nothing");
            return null;
        }
        logger.debug("Getting " + statisticsOfUsername + " amount of workspace in use.");
        try {
            long init = System.currentTimeMillis();
            UserInfrastructureSpaceCache cacheWorkspace = UserInfrastructureSpaceCache.getCacheInstance();
            Long storageInUseLong = cacheWorkspace.get(statisticsOfUsername);
            if (storageInUseLong == null) {
                logger.debug("Information not available in the cache, asking workspace");
                Workspace workspace = HomeLibrary.getUserWorkspace((String)statisticsOfUsername);
                storageInUseLong = workspace.getDiskUsage();
                logger.debug("Put information in the cache");
                cacheWorkspace.insert(statisticsOfUsername, storageInUseLong);
            }
            storageInUse = ServerUtils.formatFileSize((long)storageInUseLong);
            long end = System.currentTimeMillis();
            logger.debug("[USER-STATISTICS] time taken to retrieve user space is " + (end - init) + "ms");
        }
        catch (Exception e) {
            logger.error("Unable to retrieve workspace information!");
        }
        return storageInUse;
    }

    public int getProfileStrength(String userid) {
        String userName;
        int profileStrenght = -1;
        ASLSession session = ServerUtils.getASLSession((HttpSession)this.getThreadLocalRequest().getSession());
        String statisticsOfUsername = userName = session.getUsername();
        if (userid != null && !userid.equals(userName)) {
            statisticsOfUsername = userid;
        }
        if (userName.compareTo(defaultUserId) == 0) {
            logger.debug("Found " + userName + " returning nothing");
            return profileStrenght;
        }
        if (ServerUtils.isWithinPortal()) {
            try {
                long init = System.currentTimeMillis();
                boolean avatarPresent = new LiferayUserManager().getUserAvatarBytes(statisticsOfUsername) != null;
                User user = UserLocalServiceUtil.getUserByScreenName((long)SiteManagerUtil.getCompany().getCompanyId(), (String)statisticsOfUsername);
                profileStrenght = ServerUtils.evaluateProfileStrenght((User)user, (boolean)avatarPresent);
                long end = System.currentTimeMillis();
                logger.debug("[USER-STATISTICS] time taken to evaluate user profile strenght is " + (end - init) + "ms");
            }
            catch (Exception e) {
                logger.error("Profile strenght evaluation failed!!" + e.toString(), (Throwable)e);
            }
        }
        return profileStrenght;
    }

    public UserInformation getUserSettings(String userid) {
        String userName;
        ASLSession session = ServerUtils.getASLSession((HttpSession)this.getThreadLocalRequest().getSession());
        String statisticsOfUsername = userName = session.getUsername();
        boolean isOwner = false;
        boolean isProfileShowable = true;
        if (userid == null || userid != null && userid.equals(userName)) {
            isOwner = true;
            isProfileShowable = this.checkUserPrivacyOption(userName);
        }
        if (userid != null && !userid.equals(userName)) {
            statisticsOfUsername = userid;
            isProfileShowable = this.checkUserPrivacyOption(statisticsOfUsername);
            logger.info("Is profile showable for user " + userid + " " + isProfileShowable);
        }
        if (userName.compareTo(defaultUserId) == 0) {
            logger.debug("Found " + userName + " returning nothing");
            return null;
        }
        if (ServerUtils.isWithinPortal()) {
            boolean isInfrastructure = ServerUtils.isInfrastructureScope((String)userid, (HttpSession)this.getThreadLocalRequest().getSession());
            logger.debug("User scope is " + (isInfrastructure ? " the whole infrastucture " : " a VRE"));
            LiferayUserManager um = new LiferayUserManager();
            String thumbnailURL = null;
            try {
                thumbnailURL = um.getUserByUsername(statisticsOfUsername).getUserAvatarURL();
            }
            catch (UserManagementSystemException e) {
                logger.error("Unable to retrieve avatar url for user " + statisticsOfUsername, (Throwable)e);
            }
            catch (UserRetrievalFault e) {
                logger.error("Unable to retrieve avatar url for user " + statisticsOfUsername, (Throwable)e);
            }
            logger.debug(statisticsOfUsername + " avatar has url " + thumbnailURL);
            String actualVre = null;
            if (!isInfrastructure) {
                String[] temp = session.getScope().split("/");
                actualVre = temp[temp.length - 1];
            }
            String pageLanding = PortalContext.getConfiguration().getSiteLandingPagePath(this.getThreadLocalRequest());
            UserInformation bean = new UserInformation(isInfrastructure, thumbnailURL, userName, actualVre, isOwner, isProfileShowable);
            bean.setCurrentPageLanding(pageLanding);
            return bean;
        }
        return new UserInformation(true, null, userName, vreID, true, true);
    }

    private boolean checkUserPrivacyOption(String username) {
        try {
            ServerUtils.setPermissionChecker();
            CacheRegistryUtil.clear();
            User user = UserLocalServiceUtil.getUserByScreenName((long)ManagementUtils.getCompany().getCompanyId(), (String)username);
            if (!user.getExpandoBridge().hasAttribute(CUSTOM_FIELD_NAME_USER_STATISTICS_VISIBILITY)) {
                return true;
            }
            return (Boolean)user.getExpandoBridge().getAttribute(CUSTOM_FIELD_NAME_USER_STATISTICS_VISIBILITY);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve user's privacy option for his statistics");
            return true;
        }
    }

    public PostsStatsBean getPostsStats(String userid) {
        String userName;
        ASLSession session = ServerUtils.getASLSession((HttpSession)this.getThreadLocalRequest().getSession());
        String statisticsOfUsername = userName = session.getUsername();
        if (userid != null && !userid.equals(userName)) {
            statisticsOfUsername = userid;
        }
        if (userName.compareTo(defaultUserId) == 0) {
            logger.debug("Found " + userName + " returning nothing");
            return null;
        }
        long feedsMade = 0L;
        long likesGot = 0L;
        long commentsGot = 0L;
        long commentsMade = 0L;
        long likesMade = 0L;
        boolean isInfrastructure = ServerUtils.isInfrastructureScope((String)userid, (HttpSession)this.getThreadLocalRequest().getSession());
        Calendar oneYearAgo = Calendar.getInstance();
        oneYearAgo.set(1, oneYearAgo.get(1) - 1);
        logger.debug("Reference time is " + oneYearAgo.getTime());
        try {
            long init = System.currentTimeMillis();
            logger.debug("Getting " + statisticsOfUsername + " feeds in the last year.");
            List userFeeds = this.store.getRecentFeedsByUserAndDate(statisticsOfUsername, oneYearAgo.getTime().getTime());
            logger.debug("Evaluating number of comments and likes of " + statisticsOfUsername + "'s feeds.");
            for (Object feed : userFeeds) {
                try {
                    if (!isInfrastructure && !feed.getVreid().equals(session.getScope())) continue;
                    ++feedsMade;
                    commentsGot += (long)Integer.parseInt(feed.getCommentsNo());
                    likesGot += (long)Integer.parseInt(feed.getLikesNo());
                }
                catch (NumberFormatException e) {
                    logger.error(e.toString());
                }
            }
            List recentLikedFeeds = this.store.getRecentLikedFeedsByUserAndDate(statisticsOfUsername, oneYearAgo.getTime().getTime());
            for (Feed feed : recentLikedFeeds) {
                if (!isInfrastructure && !feed.getVreid().equals(session.getScope())) continue;
                ++likesMade;
            }
            List recentComments = this.store.getRecentCommentsByUserAndDate(statisticsOfUsername, oneYearAgo.getTime().getTime());
            HashMap<String, Feed> parentFeeds = new HashMap<String, Feed>();
            for (Comment comment : recentComments) {
                Feed parentFeed = null;
                if (!parentFeeds.containsKey(comment.getFeedid())) {
                    parentFeed = this.store.readFeed(comment.getFeedid());
                    parentFeeds.put(comment.getFeedid(), parentFeed);
                }
                parentFeed = (Feed)parentFeeds.get(comment.getFeedid());
                if (!isInfrastructure && !parentFeed.getVreid().equals(session.getScope())) continue;
                ++commentsMade;
            }
            long end = System.currentTimeMillis();
            logger.debug("[USER-STATISTICS] time taken to retrieve statistics is " + (end - init) + " ms");
            logger.debug("Total number of feeds made (after time filtering) of  " + statisticsOfUsername + " is " + feedsMade);
            logger.debug("Total number of likes got (after time filtering) for " + statisticsOfUsername + " is " + likesGot);
            logger.debug("Total number of comments got (after time filtering) for " + statisticsOfUsername + " is " + commentsGot);
            logger.debug("Total number of likes made (after time filtering) for " + statisticsOfUsername + " is " + likesMade);
            logger.debug("Total number of comments made (after time filtering) for " + statisticsOfUsername + " is " + commentsMade);
        }
        catch (Exception e) {
            logger.error(e.toString());
            return null;
        }
        return new PostsStatsBean(feedsMade, likesGot, commentsGot, commentsMade, likesMade);
    }

    public void setShowMyOwnStatisticsToOtherPeople(boolean show) {
        if (ServerUtils.isWithinPortal()) {
            ASLSession session = ServerUtils.getASLSession((HttpSession)this.getThreadLocalRequest().getSession());
            String username = session.getUsername();
            if (username.compareTo(defaultUserId) == 0) {
                logger.debug("Found " + username + " returning nothing");
                return;
            }
            try {
                ServerUtils.setPermissionChecker();
                CacheRegistryUtil.clear();
                logger.debug("User " + username + (show ? " want to show " : " doesn't want to show ") + " his statistics");
                User user = UserLocalServiceUtil.getUserByScreenName((long)ManagementUtils.getCompany().getCompanyId(), (String)username);
                boolean hasAttribute = user.getExpandoBridge().hasAttribute(CUSTOM_FIELD_NAME_USER_STATISTICS_VISIBILITY);
                if (hasAttribute) {
                    logger.debug("Setting custom field value to " + show + " for user " + username);
                    user.getExpandoBridge().setAttribute(CUSTOM_FIELD_NAME_USER_STATISTICS_VISIBILITY, (Serializable)Boolean.valueOf(show));
                }
            }
            catch (Exception e) {
                logger.error("Unable to check user's privacy for his statistics", (Throwable)e);
            }
        }
    }
}

