package org.gcube.portlets.widgets.ckandatapublisherwidget.client.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.gcube.portlets.widgets.ckandatapublisherwidget.client.CKanPublisherService;
import org.gcube.portlets.widgets.ckandatapublisherwidget.client.CKanPublisherServiceAsync;
import org.gcube.portlets.widgets.ckandatapublisherwidget.client.events.CloseCreationFormEvent;
import org.gcube.portlets.widgets.ckandatapublisherwidget.client.events.CloseCreationFormEventHandler;
import org.gcube.portlets.widgets.ckandatapublisherwidget.client.events.DeleteCustomFieldEvent;
import org.gcube.portlets.widgets.ckandatapublisherwidget.client.events.DeleteCustomFieldEventHandler;
import org.gcube.portlets.widgets.ckandatapublisherwidget.client.ui.dataset.resources.AddResourceContainer;
import org.gcube.portlets.widgets.ckandatapublisherwidget.client.ui.dataset.resources.AddResourceToDataset;
import org.gcube.portlets.widgets.ckandatapublisherwidget.client.ui.dataset.resources.AddedResourcesSummary;
import org.gcube.portlets.widgets.ckandatapublisherwidget.client.ui.dataset.resources.ResourcesTable;
import org.gcube.portlets.widgets.ckandatapublisherwidget.client.ui.dataset.resources.TagsPanel;
import org.gcube.portlets.widgets.ckandatapublisherwidget.client.ui.utils.InfoIconsLabels;
import org.gcube.portlets.widgets.ckandatapublisherwidget.shared.DatasetMetadataBean;
import org.gcube.portlets.widgets.ckandatapublisherwidget.shared.LicensesBean;
import org.gcube.portlets.widgets.ckandatapublisherwidget.shared.MetaDataProfileBean;
import org.gcube.portlets.widgets.ckandatapublisherwidget.shared.MetadataFieldWrapper;
import org.gcube.portlets.widgets.ckandatapublisherwidget.shared.OrganizationBean;

import com.github.gwtbootstrap.client.ui.AlertBlock;
import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.Form;
import com.github.gwtbootstrap.client.ui.Icon;
import com.github.gwtbootstrap.client.ui.ListBox;
import com.github.gwtbootstrap.client.ui.Paragraph;
import com.github.gwtbootstrap.client.ui.Popover;
import com.github.gwtbootstrap.client.ui.Tab;
import com.github.gwtbootstrap.client.ui.TabPanel;
import com.github.gwtbootstrap.client.ui.TextArea;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.AlertType;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.github.gwtbootstrap.client.ui.resources.Bootstrap.Tabs;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * Create metadata form for ckan product.
 * @author Costantino Perciante at ISTI-CNR (costantino.perciante@isti.cnr.it)
 */
public class CreateDatasetForm extends Composite{

	private static EditMetadataFormUiBinder uiBinder = GWT
			.create(EditMetadataFormUiBinder.class);

	interface EditMetadataFormUiBinder extends
	UiBinder<Widget, CreateDatasetForm> {
	}

	@UiField HTMLPanel createDatasetMainPanel;
	@UiField TextBox titleTextBox;
	@UiField TextArea descriptionTextarea;
	@UiField ListBox licenseListbox;
	@UiField ListBox visibilityListbox;
	@UiField ListBox organizationsListbox;
	@UiField TextBox versionTextbox;
	@UiField TextBox authorTextbox;
	@UiField TextBox authorEmailTextbox;
	@UiField TextBox maintainerTextbox;
	@UiField TextBox maintainerEmailTextbox;
	@UiField ControlGroup customFields;
	@UiField Button addCustomFieldButton;
	@UiField Button createButton;
	@UiField Button resetButton;
	@UiField AlertBlock infoBlock;
	@UiField AlertBlock alertNoResources;
	@UiField AlertBlock onContinueAlertBlock;
	@UiField AlertBlock onCreateAlertBlock;
	@UiField VerticalPanel metadataFieldsPanel;
	@UiField ListBox metadataProfilesFormatListbox;
	@UiField Form formFirstStep;
	@UiField Form formSecondStep;
	@UiField Form formThirdStep;
	@UiField Button continueButton;
	@UiField Button goBackButtonSecondStep;
	@UiField Paragraph selectedProfile;
	@UiField Button goToDatasetButton;
	@UiField FlowPanel goToDatasetButtonPanel;
	@UiField Button addResourcesButton;
	@UiField SimplePanel workspaceResourcesContainer;
	@UiField Button continueThirdStep;
	@UiField Button goBackButtonFirstStep;
	@UiField Anchor licenseUrlAnchor;
	@UiField Paragraph unavailableUrl;
	@UiField TagsPanel tagsPanel;

	// info panels
	@UiField Icon infoIconLicenses;
	@UiField FocusPanel focusPanelLicenses;
	@UiField Popover popoverLicenses;
	@UiField Icon infoIconVisibility;
	@UiField FocusPanel focusPanelVisibility;
	@UiField Popover popoverVisibility;
	@UiField Icon infoIconAuthor;
	@UiField FocusPanel focusPanelAuthor;
	@UiField Popover popoverAuthor;
	@UiField Icon infoIconMaintainerEmail;
	@UiField FocusPanel focusPanelMaintainerEmail;
	@UiField Popover popoverMaintainerEmail;
	@UiField Icon infoIconAuthorEmail;
	@UiField FocusPanel focusPanelAuthorEmail;
	@UiField Popover popoverAuthorEmail;
	@UiField Icon infoIconProfiles;
	@UiField FocusPanel focusPanelProfiles;
	@UiField Popover popoverProfiles;
	@UiField Icon infoIconMaintainer;
	@UiField FocusPanel focusPanelMaintainer;
	@UiField Popover popoverMaintainer;
	@UiField Icon infoIconCustomFields;
	@UiField FocusPanel focusPanelCustomFields;
	@UiField Popover popoverCustomFields;
	@UiField Icon infoIconResources;
	@UiField FocusPanel focusPanelResources;
	@UiField Popover popoverResources;
	@UiField Icon infoIconTitle;
	@UiField FocusPanel focusPanelTitle;
	@UiField Popover popoverTitle;
	@UiField ControlGroup metadataProfilesControlGroup;
	@UiField ControlGroup productTitleGroup;
	@UiField ControlGroup maintainerControlGroup;
	@UiField ControlGroup versionControlGroup;
	@UiField ControlGroup organizationsGroup;

	// Create a remote service proxy to talk to the server-side ckan service.
	private final CKanPublisherServiceAsync ckanServices = GWT.create(CKanPublisherService.class);

	private static final String REGEX_TITLE_PRODUCT_SUBWORD = "[^a-zA-Z0-9_.-]";
	private static final String REGEX_MAIL = "\\b[\\w.%-]+@[-.\\w]+\\.[A-Za-z]{2,4}\\b";
	private static final String NONE_PROFILE = "none";

	// error/info messages
	protected static final String ERROR_PRODUCT_CREATION = "There was an error while trying to publish your product, sorry.. Retry later";
	protected static final String PRODUCT_CREATED_OK = "Product correctly created!";
	private static final String TRYING_TO_CREATE_PRODUCT = "Trying to create product, please wait";

	// tab panel 
	private TabPanel tabPanel; 

	// add resource form
	private AddResourceToDataset resourceForm;

	// the licenses
	private LicensesBean licenseBean;

	// event bus
	private HandlerManager eventBus;

	// added custom field entries 
	private List<CustomFieldEntry> customFieldEntriesList = new ArrayList<CustomFieldEntry>();

	// dataset metadata bean
	private DatasetMetadataBean receivedBean;

	// the owner
	private String owner;

	// workspace request?
	private boolean isWorkspaceRequest = false;

	// the list of MetaDataFieldSkeleton added
	private List<MetaDataFieldSkeleton> listOfMetadataFields = new ArrayList<MetaDataFieldSkeleton>();

	// resource table
	private ResourcesTable resourcesTable;

	// List of opened popup'ids
	private List<String> popupOpenedIds = new ArrayList<String>();

	// map of organization name title
	private Map<String, String> nameTitleOrganizationMap = new HashMap<String, String>();

	/**
	 * Invoked in the most general case
	 * @param eventBus the event bus
	 */
	public CreateDatasetForm(HandlerManager eventBus) {

		createDatasetFormBody(false, null, eventBus);

	}

	/**
	 * Invoked when the workspace is used
	 * @param idFolderWorkspace
	 * @param eventBus the event bus
	 */
	public CreateDatasetForm(String idFolderWorkspace, HandlerManager eventBus) {

		createDatasetFormBody(true, idFolderWorkspace, eventBus);

	}

	/**
	 * Bind on events
	 */
	private void bind() {

		// when a custom field is removed, remove it from the list
		eventBus.addHandler(DeleteCustomFieldEvent.TYPE, new DeleteCustomFieldEventHandler() {

			@Override
			public void onRemoveEntry(DeleteCustomFieldEvent event) {

				customFieldEntriesList.remove(event.getRemovedEntry());
				customFields.remove(event.getRemovedEntry());

			}
		});

		// on close form
		eventBus.addHandler(CloseCreationFormEvent.TYPE, new CloseCreationFormEventHandler() {

			@Override
			public void onClose(CloseCreationFormEvent event) {

				InfoIconsLabels.closeDialogBox(popupOpenedIds);

			}

		});

	}

	/**
	 * The real constructor
	 * @param isWorkspaceRequest
	 * @param idFolderWorkspace
	 * @param owner
	 * @param eventBus
	 */
	private void createDatasetFormBody(final boolean isWorkspaceRequest, String idFolderWorkspace, final HandlerManager eventBus){

		initWidget(uiBinder.createAndBindUi(this));

		// save event bus
		this.eventBus = eventBus;

		// workspace request
		this.isWorkspaceRequest = isWorkspaceRequest;

		// bind on events
		bind();

		// prepare info icons
		prepareInfoIcons();

		// disable continue button
		continueButton.setEnabled(false);
		resetButton.setEnabled(false);

		// set info block
		setAlertBlock("Retrieving information, please wait...", AlertType.INFO, true);

		// get back the licenses and the metadata information
		ckanServices.getDatasetBean(idFolderWorkspace, new AsyncCallback<DatasetMetadataBean>() {

			@Override
			public void onFailure(Throwable caught) {

				setAlertBlock("Error while retrieving information, try to refresh the page", AlertType.ERROR, true);

			}

			@Override
			public void onSuccess(final DatasetMetadataBean bean) {

				if(bean == null){

					setAlertBlock("Error while retrieving information, try to refresh the page", AlertType.ERROR, true);
				}
				else{

					// save it
					receivedBean = bean;

					// fill the form
					titleTextBox.setText(bean.getTitle());
					descriptionTextarea.setText(bean.getDescription());
					versionTextbox.setText(String.valueOf(bean.getVersion()));
					authorTextbox.setText(bean.getAuthorSurname() + " " + bean.getAuthorName());
					authorEmailTextbox.setText(bean.getAuthorEmail());
					maintainerTextbox.setText(bean.getAuthorSurname() + " " + bean.getAuthorName());
					maintainerEmailTextbox.setText(bean.getMaintainerEmail());

					// retrieve custom fields
					Map<String, String> customFieldsMap = bean.getCustomFields();	

					if(customFieldsMap != null){

						// get the keys and put them as tags
						Iterator<Entry<String, String>> iteratorOverCustomField = customFieldsMap.entrySet().iterator();

						while (iteratorOverCustomField.hasNext()) {
							Map.Entry<String, String> entry = (Map.Entry<String, String>) iteratorOverCustomField
									.next();

							// these are fixed key, variable value custom fields
							CustomFieldEntry toAdd = new CustomFieldEntry(eventBus, entry.getKey(), entry.getValue(), false);
							customFieldEntriesList.add(toAdd);
							customFields.add(toAdd);

							// add as tag
							tagsPanel.addTagElement(entry.getKey());

						}
					}

					if(isWorkspaceRequest){

						resourcesTable = new ResourcesTable(bean.getResources());

						// if there are not resources, for now just checked it ( and hide so that the step will be skipped) TODO
						if(bean.getResources() == null || bean.getResources().isEmpty()){

							alertNoResources.setType(AlertType.WARNING);
							alertNoResources.setVisible(true);

						}

					}

					// set organizations
					List<OrganizationBean> organizations = bean.getOrganizationList();

					for (OrganizationBean organization : organizations) {
						organizationsListbox.addItem(organization.getTitle());
						nameTitleOrganizationMap.put(organization.getTitle(), organization.getName());
					}

					// force the selection of the first one, and retrieve the list of profiles 
					organizationsListbox.setSelectedIndex(0);

					// add change handler to dinamycally retrieve the list of profiles
					organizationsListbox.addChangeHandler(new ChangeHandler() {

						@Override
						public void onChange(ChangeEvent event) {
							event.preventDefault();
							organizationsListboxChangeHandlerBody();

						}
					});

					// try to retrieve the profiles
					setAlertBlock("Retrieving profiles, please wait...", AlertType.INFO, true);

					// get the name of the organization from the title
					String orgName = nameTitleOrganizationMap.get(organizationsListbox.getSelectedItemText());

					// perform remote request of profiles for the selected organization
					ckanServices.getProfiles(orgName, new AsyncCallback<List<MetaDataProfileBean>>() {

						@Override
						public void onFailure(Throwable caught) {

							setAlertBlock("Error while retrieving profiles, try to refresh the page", AlertType.ERROR, true);

						}

						@Override
						public void onSuccess(List<MetaDataProfileBean> result) {

							if(result == null){

								setAlertBlock("Error while retrieving profiles, try to refresh the page", AlertType.ERROR, true);

							}
							else{

								receivedBean.setMetadataList(result);
								prepareMetadataList(receivedBean);
								organizationsListbox.setEnabled(true);
								metadataProfilesFormatListbox.setEnabled(true);

								// try to retrieve the licenses
								setAlertBlock("Retrieving licenses, please wait...", AlertType.INFO, true);
								ckanServices.getLicenses(new AsyncCallback<LicensesBean>() {

									@Override
									public void onFailure(Throwable caught){

										setAlertBlock("Error while retrieving licenses, try to refresh the page", AlertType.ERROR, true);

									}

									@Override
									public void onSuccess(LicensesBean lBean) {

										if(lBean != null && !lBean.getLicenseTitles().isEmpty()){

											licenseBean = lBean;

											// sort the list
											List<String> listOfNames = new ArrayList<String>();
											Collections.copy(listOfNames, licenseBean.getLicenseTitles());
											Collections.sort(listOfNames);

											// fill the listbox
											for(int i = 0; i < listOfNames.size(); i++){
												licenseListbox.addItem(listOfNames.get(i));
											}

											// set the url of the license, if any
											showLicenseUrl();

											// everything went ok
											setAlertBlock("", AlertType.ERROR, false);
											continueButton.setEnabled(true);
											resetButton.setEnabled(true);

										}else{

											setAlertBlock("Error while retrieving licenses, try to refresh the page", AlertType.ERROR, true);

										}
									}
								});
							}
						}
					});
				}
			}
		});

	}

	/**
	 * When the organization name is changed we need to retrieve the list of profiles
	 */
	private void organizationsListboxChangeHandlerBody() {

		// remove any other product profiles
		int presentItems = metadataProfilesFormatListbox.getItemCount();
		for (int i = presentItems - 1; i >= 0; i--) {
			metadataProfilesFormatListbox.removeItem(i);
		}

		// add "none" item again
		metadataProfilesFormatListbox.addItem(NONE_PROFILE);

		// select "none"
		metadataProfilesFormatListbox.setSelectedIndex(0);

		// get the name of the organization from the title
		String selectedOrganizationTitle = organizationsListbox.getSelectedItemText();	
		String orgName = nameTitleOrganizationMap.get(selectedOrganizationTitle);

		// try to retrieve the profiles
		setAlertBlock("Retrieving profiles, please wait...", AlertType.INFO, true);

		// disable the list of organizations name so that the user doesn't change it again
		organizationsListbox.setEnabled(false);
		metadataProfilesFormatListbox.setEnabled(false);

		// perform remote request of profiles for the selected organization
		ckanServices.getProfiles(orgName, new AsyncCallback<List<MetaDataProfileBean>>() {

			@Override
			public void onSuccess(List<MetaDataProfileBean> result) {

				if(result != null){

					receivedBean.setMetadataList(result);
					prepareMetadataList(receivedBean);
					organizationsListbox.setEnabled(true);
					metadataProfilesFormatListbox.setEnabled(true);

					// everything went ok
					setAlertBlock("", AlertType.DEFAULT, false);

				}else
					setAlertBlock("Error while retrieving profiles, sorry", AlertType.ERROR, true);

			}

			@Override
			public void onFailure(Throwable caught) {

				setAlertBlock("Error while retrieving profiles, sorry", AlertType.ERROR, true);

			}
		});

	}

	/**
	 * Add the items to the listbox and put data into the metadataPanel
	 * @param receivedBean
	 */
	private void prepareMetadataList(final DatasetMetadataBean receivedBean) {

		List<MetaDataProfileBean> beans = receivedBean.getMetadataList();

		if(beans != null && !beans.isEmpty()){
			for(MetaDataProfileBean metadataBean: beans){

				metadataProfilesFormatListbox.addItem(metadataBean.getType().getName());		

				// add handler on select
				metadataProfilesFormatListbox.addChangeHandler(new ChangeHandler() {

					@Override
					public void onChange(ChangeEvent event) {

						String selectedItem = metadataProfilesFormatListbox.getSelectedItemText();

						if(selectedItem.equals(NONE_PROFILE)){
							// hide the panel
							metadataFieldsPanel.clear();
							metadataFieldsPanel.setVisible(false);
							receivedBean.setChosenProfile(null);
						}else{
							receivedBean.setChosenProfile(selectedItem);
							metadataFieldsPanel.clear();
							addFields(selectedItem);
						}
					}
				});
			}
			metadataProfilesControlGroup.setVisible(true);
		}else{ 
			// just hide this listbox
			metadataProfilesControlGroup.setVisible(false);
			metadataFieldsPanel.clear();
			listOfMetadataFields.clear();
			receivedBean.setChosenProfile(null);
		}
	}

	/**
	 * Add fields of the selected metadata profile to the widget
	 * @param selectedItem
	 */
	protected void addFields(String selectedItem) {

		for(MetaDataProfileBean bean: receivedBean.getMetadataList()){

			if(bean.getType().getName().equals(selectedItem)){

				// prepare the data
				List<MetadataFieldWrapper> fields = bean.getMetadataFields();

				// clear old data
				listOfMetadataFields.clear();

				for (MetadataFieldWrapper field : fields) {
					MetaDataFieldSkeleton fieldWidget;
					try {
						fieldWidget = new MetaDataFieldSkeleton(field, eventBus);
						metadataFieldsPanel.add(fieldWidget);
						listOfMetadataFields.add(fieldWidget);
					} catch (Exception e) {
						GWT.log("Unable to build such widget", e);
					}
				}
				metadataFieldsPanel.setVisible(true);		
			}
		}
	}

	@UiHandler("addCustomFieldButton")
	void addCustomFieldEvent(ClickEvent e){

		CustomFieldEntry toAdd = new CustomFieldEntry(eventBus, "", "", true);
		customFieldEntriesList.add(toAdd);
		customFields.add(toAdd);

	}

	@UiHandler("continueButton")
	void onContinueButton(ClickEvent e){

		// validate data
		final String errorMsg = validateDataOnContinue();

		if(errorMsg != null){

			alertOnContinue("Please check inserted data [" + errorMsg + "]", AlertType.ERROR);
			return;

		}else{

			// better check for title (only if the dataset was not created.. if it is the case, fields are not frozen)
			if(!titleTextBox.isEnabled())
				actionsAfterOnContinue();
			else{
				alertOnContinue("Checking if a product with such title already exists, please wait...", AlertType.INFO);

				ckanServices.datasetIdAlreadyExists(titleTextBox.getText(), new AsyncCallback<Boolean>() {

					@Override
					public void onSuccess(Boolean result) {

						if(result){

							alertOnContinue("Sorry but a product with such title already exists, try to change it", AlertType.WARNING);

						}else{

							actionsAfterOnContinue();

						}
					}

					@Override
					public void onFailure(Throwable caught) {

						alertOnContinue("Sorry but there was a problem while checking if the inserted data are correct", AlertType.ERROR);

					}
				});
			}
		}
	}

	/**
	 * After onContinue ...
	 */
	private void actionsAfterOnContinue(){

		// check what to do 
		if(isWorkspaceRequest){

			// we need to show the page to handle resources one by one from the workspace
			formFirstStep.setVisible(false);
			boolean resourcesPresent = receivedBean.getResources() != null && receivedBean.getResources().size() > 0 ? true : false;
			formSecondStep.setVisible(resourcesPresent);
			formThirdStep.setVisible(!resourcesPresent);

			// add the resources to the container panel
			if(workspaceResourcesContainer.getWidget() == null)
				workspaceResourcesContainer.add(resourcesTable);

		}else{

			// this is not a workspace request
			formFirstStep.setVisible(false);
			formThirdStep.setVisible(true);

		}

		if(metadataProfilesFormatListbox.getSelectedItemText().equals(NONE_PROFILE))
			selectedProfile.setText("");
		else
			selectedProfile.setText("Selected Profile is " + metadataProfilesFormatListbox.getSelectedItemText());

	}


	@UiHandler("goBackButtonFirstStep")
	void onGoBackButtonFirstStep(ClickEvent e){

		// swap forms
		formFirstStep.setVisible(true);
		formSecondStep.setVisible(false);
		formThirdStep.setVisible(false);

	}


	@UiHandler("goBackButtonSecondStep")
	void onGoBackButton(ClickEvent e){

		// swap forms
		if(isWorkspaceRequest){
			boolean resourcesPresent = receivedBean.getResources() != null && receivedBean.getResources().size() > 0 ? true : false;
			formFirstStep.setVisible(!resourcesPresent);
			formSecondStep.setVisible(resourcesPresent);
		}else{
			formFirstStep.setVisible(true);
			formSecondStep.setVisible(false);
		}
		formThirdStep.setVisible(false);

	}

	@UiHandler("continueThirdStep")
	void onContinueThirdStep(ClickEvent e){

		// swap forms
		formSecondStep.setVisible(false);
		formThirdStep.setVisible(true);

	}


	@UiHandler("createButton")
	void createDatasetEvent(ClickEvent e){

		String errorMessage = areProfileDataValid();

		if(errorMessage != null){

			alertOnCreate("Please check the inserted values and the mandatory fields [" + errorMessage +"]", AlertType.ERROR, true);

		}
		else{

			String title = titleTextBox.getValue().trim();
			String description = descriptionTextarea.getText().trim();
			String selectedLicense = licenseListbox.getSelectedItemText();
			String visibility = visibilityListbox.getSelectedItemText();
			long version = Long.valueOf(versionTextbox.getValue().trim());
			String author = authorTextbox.getValue();
			String authorEmail = authorEmailTextbox.getValue();
			String maintainer = maintainerTextbox.getValue().trim();
			String maintainerEmail = maintainerEmailTextbox.getValue().trim();
			String chosenOrganizationTitle = organizationsListbox.getSelectedItemText();

			//we need to retrieve the organization's name from this title
			List<OrganizationBean> orgs = receivedBean.getOrganizationList();
			String chosenOrganization = null;
			for (OrganizationBean organizationBean : orgs) {
				if(chosenOrganizationTitle.equals(organizationBean.getTitle())){
					chosenOrganization = organizationBean.getName();
					break;
				}
			}

			// fill the bean
			receivedBean.setAuthorFullName(author);
			receivedBean.setAuthorEmail(authorEmail);
			receivedBean.setDescription(description);
			receivedBean.setLicense(selectedLicense);
			receivedBean.setMaintainer(maintainer);
			receivedBean.setMaintainerEmail(maintainerEmail);
			receivedBean.setVersion(version);
			receivedBean.setVisibility(visibility.equals("Public"));
			receivedBean.setTitle(title);
			receivedBean.setTags(tagsPanel.getTags());
			receivedBean.setSelectedOrganization(chosenOrganization);

			Map<String, String> customFieldsMap = new HashMap<String, String>();

			// prepare custom fields
			for (MetaDataFieldSkeleton field : listOfMetadataFields) {

				String value = field.getFieldCurrentValue();

				if(!value.isEmpty())
					customFieldsMap.put(field.getFieldName(), field.getFieldCurrentValue());

			}

			for(CustomFieldEntry customEntry : customFieldEntriesList){

				String key = customEntry.getKey();
				String value = customEntry.getValue();
				if(value != null && !value.isEmpty())
					customFieldsMap.put(key, value);

			}

			receivedBean.setCustomFields(customFieldsMap);

			// alert 
			alertOnCreate(TRYING_TO_CREATE_PRODUCT, AlertType.INFO, false);

			// invoke the create method
			createButton.setEnabled(false);
			goBackButtonSecondStep.setEnabled(false);

			ckanServices.createCKanDataset(receivedBean, new AsyncCallback<DatasetMetadataBean>() {

				@Override
				public void onSuccess(final DatasetMetadataBean createdDatasetBean) {

					if(createdDatasetBean != null){

						alertOnCreate(PRODUCT_CREATED_OK, AlertType.SUCCESS, false);

						// disable dataset fields
						disableDatasetFields();

						// disable reset
						resetButton.setEnabled(false);

						// show the go to dataset button
						final String datasetUrl = createdDatasetBean.getSource();
						goToDatasetButtonPanel.setVisible(true);
						goToDatasetButton.setVisible(true);
						goToDatasetButton.setText(datasetUrl);
						goToDatasetButton.addClickHandler(new ClickHandler() {

							@Override
							public void onClick(ClickEvent event) {
								Window.open(datasetUrl, "_blank", "");
								//Window.Location.assign(datasetUrl);
							}
						});

						// if we are in the "general case" we need to show a form for adding resources
						if(isWorkspaceRequest){
							// leave to back button, but remove create and add go to dataset
							createButton.removeFromParent();

							// set go to dataset as primary
							goToDatasetButton.setType(ButtonType.PRIMARY);

						}else{

							// remove create button
							createButton.removeFromParent();

							// show the add resources button
							addResourcesButton.setVisible(true);

							addResourcesButton.addClickHandler(new ClickHandler() {

								@Override
								public void onClick(ClickEvent event) {

									// remove content of the main panel
									createDatasetMainPanel.clear();

									// TabPanel
									tabPanel = new TabPanel(Tabs.ABOVE);
									tabPanel.setWidth("100%");

									// add the form
									resourceForm = new AddResourceToDataset(eventBus, createdDatasetBean.getId(), createdDatasetBean.getSelectedOrganization(), owner, datasetUrl);

									// tab for the form
									Tab formContainer = new Tab();
									formContainer.add(resourceForm);
									formContainer.setHeading("Add New Resource");
									tabPanel.add(formContainer);

									// tab for the added resources
									Tab addedResources = new Tab();
									addedResources.add(new AddedResourcesSummary(eventBus));
									addedResources.setHeading("Added Resource");
									tabPanel.add(addedResources);

									// add tabs to resources panel
									tabPanel.selectTab(0);

									// form container
									AddResourceContainer container = new AddResourceContainer(datasetUrl);
									container.add(tabPanel);

									// add the new content of the main panel
									createDatasetMainPanel.add(container);
								}
							});	
						}

					}else{
						alertOnCreate(ERROR_PRODUCT_CREATION, AlertType.ERROR, true);
					}

				}

				@Override
				public void onFailure(Throwable caught) {
					alertOnCreate(ERROR_PRODUCT_CREATION, AlertType.ERROR, true);
				}
			});
		}
	}

	/**
	 * Prepare the info icons of all core metadata info
	 */
	private void prepareInfoIcons() {

		// tags
		tagsPanel.prepareIcon(popupOpenedIds);

		// licenses
		InfoIconsLabels.preparePopupPanelAndPopover(
				InfoIconsLabels.LICENSES_INFO_ID_POPUP,
				InfoIconsLabels.LICENSES_INFO_TEXT,
				InfoIconsLabels.LICENSES_INFO_CAPTION,
				infoIconLicenses,
				popoverLicenses,
				focusPanelLicenses,
				popupOpenedIds
				);

		// visibility
		InfoIconsLabels.preparePopupPanelAndPopover(
				InfoIconsLabels.VISIBILITY_INFO_ID_POPUP,
				InfoIconsLabels.VISIBILITY_INFO_TEXT,
				InfoIconsLabels.VISIBILITY_INFO_CAPTION,
				infoIconVisibility,
				popoverVisibility,
				focusPanelVisibility,
				popupOpenedIds
				);

		// author
		InfoIconsLabels.preparePopupPanelAndPopover(
				InfoIconsLabels.AUTHOR_INFO_ID_POPUP,
				InfoIconsLabels.AUTHOR_INFO_TEXT,
				InfoIconsLabels.AUTHOR_INFO_CAPTION,
				infoIconAuthor,
				popoverAuthor,
				focusPanelAuthor,
				popupOpenedIds
				);

		// author's email
		InfoIconsLabels.preparePopupPanelAndPopover(
				InfoIconsLabels.AUTHOR_EMAIL_INFO_ID_POPUP,
				InfoIconsLabels.AUTHOR_EMAIL_INFO_TEXT,
				InfoIconsLabels.AUTHOR_EMAIL_INFO_CAPTION,
				infoIconAuthorEmail,
				popoverAuthorEmail,
				focusPanelAuthorEmail,
				popupOpenedIds
				);

		// maintainer
		InfoIconsLabels.preparePopupPanelAndPopover(
				InfoIconsLabels.MAINTAINER_INFO_ID_POPUP,
				InfoIconsLabels.MAINTAINER_INFO_TEXT,
				InfoIconsLabels.MAINTAINER_INFO_CAPTION,
				infoIconMaintainer,
				popoverMaintainer,
				focusPanelMaintainer,
				popupOpenedIds
				);

		// maintainer's email
		InfoIconsLabels.preparePopupPanelAndPopover(
				InfoIconsLabels.MAINTAINER_EMAIL_INFO_ID_POPUP,
				InfoIconsLabels.MAINTAINER_EMAIL_INFO_TEXT,
				InfoIconsLabels.MAINTAINER_EMAIL_INFO_CAPTION,
				infoIconMaintainerEmail,
				popoverMaintainerEmail,
				focusPanelMaintainerEmail,
				popupOpenedIds
				);

		// profiles
		InfoIconsLabels.preparePopupPanelAndPopover(
				InfoIconsLabels.PROFILES_INFO_ID_POPUP,
				InfoIconsLabels.PROFILES_INFO_TEXT,
				InfoIconsLabels.PROFILES_INFO_CAPTION,
				infoIconProfiles,
				popoverProfiles,
				focusPanelProfiles,
				popupOpenedIds
				);

		// custom fields
		InfoIconsLabels.preparePopupPanelAndPopover(
				InfoIconsLabels.CUSTOM_FIELDS_INFO_ID_POPUP,
				InfoIconsLabels.CUSTOM_FIELDS_INFO_TEXT,
				InfoIconsLabels.CUSTOM_FIELDS_INFO_CAPTION,
				infoIconCustomFields,
				popoverCustomFields,
				focusPanelCustomFields,
				popupOpenedIds
				);

		// resources field
		InfoIconsLabels.preparePopupPanelAndPopover(
				InfoIconsLabels.RESOURCES_INFO_ID_POPUP,
				InfoIconsLabels.RESOURCES_INFO_TEXT,
				InfoIconsLabels.RESOURCES_INFO_CAPTION,
				infoIconResources,
				popoverResources,
				focusPanelResources,
				popupOpenedIds
				);

		// title
		InfoIconsLabels.preparePopupPanelAndPopover(
				InfoIconsLabels.TITLE_INFO_ID_POPUP,
				InfoIconsLabels.TITLE_INFO_TEXT,
				InfoIconsLabels.TITLE_INFO_CAPTION,
				infoIconTitle,
				popoverTitle,
				focusPanelTitle,
				popupOpenedIds
				);
	}

	/**
	 * Test if profile data are valid
	 * @return
	 */
	private String areProfileDataValid() {

		for (MetaDataFieldSkeleton field : listOfMetadataFields) {

			field.removeError();

			String error = field.isFieldValueValid();
			if(error != null){
				field.showError();
				return field.getFieldName() + " is not valid. Suggestion: " + error;
			}
		}

		return null;
	}

	/**
	 * On continue show alert box and enable buttons
	 * @param text
	 * @param type
	 */
	private void alertOnContinue(String text, AlertType type){

		onContinueAlertBlock.setText(text);
		onContinueAlertBlock.setType(type);
		onContinueAlertBlock.setVisible(true);
		continueButton.setEnabled(true);
		resetButton.setEnabled(true);

		// hide after some seconds
		Timer t = new Timer() {

			@Override
			public void run() {

				onContinueAlertBlock.setVisible(false);

			}
		};

		t.schedule(4000);
	}

	/**
	 * On continue show alert box and enable buttons
	 * @param text
	 * @param type
	 */
	private void alertOnCreate(String text, AlertType type, boolean hideAfterAWhile){

		onCreateAlertBlock.setText(text);
		onCreateAlertBlock.setType(type);
		onCreateAlertBlock.setVisible(true);
		createButton.setEnabled(true);
		goBackButtonSecondStep.setEnabled(true);

		if(hideAfterAWhile){
			// hide after some seconds
			Timer t = new Timer() {

				@Override
				public void run() {

					onCreateAlertBlock.setVisible(false);

				}
			};
			t.schedule(10000);
		}
	}

	/**
	 * Validate data
	 * @return true on success, false otherwise
	 */
	private String validateDataOnContinue() {

		// remove errors
		productTitleGroup.setType(ControlGroupType.NONE);
		maintainerControlGroup.setType(ControlGroupType.NONE);
		versionControlGroup.setType(ControlGroupType.NONE);
		metadataProfilesControlGroup.setType(ControlGroupType.NONE);
		organizationsGroup.setType(ControlGroupType.NONE);

		String title = titleTextBox.getText().trim();
		if(title.isEmpty()){
			productTitleGroup.setType(ControlGroupType.ERROR);
			return "Missing title";
		}

		// better check for the title		
		String[] splittedTitle = title.split(" "); 

		for (String word : splittedTitle) {
			String replaced = word.replaceAll(REGEX_TITLE_PRODUCT_SUBWORD, "");
			if(!replaced.equals(word)){
				productTitleGroup.setType(ControlGroupType.ERROR);
				return  "Please note not all characters are allowed for the title";
			}
		}

		// email reg expression
		String maintainerMail = maintainerEmailTextbox.getText();
		if(!maintainerMail.isEmpty() && !maintainerMail.matches(REGEX_MAIL)){
			maintainerControlGroup.setType(ControlGroupType.ERROR);
			return "Not valid maintainer email";
		}

		// check if version is a number
		try{
			int number = Integer.valueOf(versionTextbox.getText().trim());
			if(number <= 0)
				throw new Exception();
		}catch(Exception e){
			versionControlGroup.setType(ControlGroupType.ERROR);
			return "Version must be a natural number greater than zero";
		}

		// check if metadata profile is different from none and its mandatory fields have been fulfilled
		if(checkSelectedMetaDataProfile()){
			metadataProfilesControlGroup.setType(ControlGroupType.ERROR);
			return "You must select a metadata profile different frome none";
		}

		if(organizationsListbox.getSelectedItemText() == null){
			organizationsGroup.setType(ControlGroupType.ERROR);
			return "You must select an organization in which you want to publish";
		}

		return null;
	}

	/**
	 * Checks if a metadata profile has been chosen and its fields have been fulfilled
	 * @return
	 */
	private boolean checkSelectedMetaDataProfile() {
		return metadataProfilesFormatListbox.getSelectedItemText().equals(NONE_PROFILE) && (metadataProfilesFormatListbox.getItemCount() != 1);
	}

	@UiHandler("resetButton")
	void resetFormEvent(ClickEvent e){

		// reset main fields
		titleTextBox.setText("");
		descriptionTextarea.setText("");
		versionTextbox.setText("");
		maintainerTextbox.setText("");
		maintainerEmailTextbox.setText("");
		tagsPanel.removeTags();

		// delete custom fields
		for (CustomFieldEntry customField : customFieldEntriesList) {
			customField.removeFromParent();
		}
		customFieldEntriesList.clear();

	}

	/**
	 * Disable dataset editable fields once the dataset has been
	 * Successfully created.
	 */
	protected void disableDatasetFields() {

		titleTextBox.setEnabled(false);
		descriptionTextarea.setEnabled(false);
		versionTextbox.setEnabled(false);
		maintainerTextbox.setEnabled(false);
		maintainerEmailTextbox.setEnabled(false);
		visibilityListbox.setEnabled(false);
		tagsPanel.freeze();
		licenseListbox.setEnabled(false);
		organizationsListbox.setEnabled(false);
		addCustomFieldButton.setEnabled(false);
		metadataProfilesFormatListbox.setEnabled(false);

		for(CustomFieldEntry ce: customFieldEntriesList)
			ce.freeze();

		// disable profile fields
		for (MetaDataFieldSkeleton field : listOfMetadataFields) {

			field.freeze();

		}

		// freeze table of resources
		if(resourcesTable != null)
			resourcesTable.freezeTable();
	}

	/**
	 * change alert block behavior.
	 * @param textToShow
	 * @param type
	 * @param visible
	 */
	private void setAlertBlock(String textToShow, AlertType type, boolean visible){

		infoBlock.setText(textToShow);
		infoBlock.setType(type);
		infoBlock.setVisible(visible);

	}

	@UiHandler("licenseListbox")
	void onSelectedLicenseChange(ChangeEvent c){

		showLicenseUrl();
	}

	/**
	 * The body of the onSelectedLicenseChange
	 */
	private void showLicenseUrl(){

		List<String> titles = licenseBean.getLicenseTitles();
		String selectedLicense = licenseListbox.getSelectedItemText();
		GWT.log("Selected license is " + selectedLicense);
		for (int i = 0; i < titles.size(); i++) {
			if(selectedLicense.equals(titles.get(i))){

				if(licenseBean.getLicenseUrls().get(i).isEmpty())
					break;

				GWT.log("URL is " + licenseBean.getLicenseUrls().get(i));

				licenseUrlAnchor.setText(licenseBean.getLicenseUrls().get(i));
				licenseUrlAnchor.setHref(licenseBean.getLicenseUrls().get(i));
				licenseUrlAnchor.setVisible(true);
				unavailableUrl.setVisible(false);
				return;
			}
		}
		licenseUrlAnchor.setVisible(false);
		unavailableUrl.setVisible(true);

	}

}
