/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.widgets.wsthreddssync;

import java.util.ArrayList;
import java.util.List;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.storagehubwrapper.server.StorageHubWrapper;
import org.gcube.common.storagehubwrapper.server.tohl.Workspace;
import org.gcube.common.storagehubwrapper.shared.tohl.WorkspaceItem;
import org.gcube.common.storagehubwrapper.shared.tohl.exceptions.InternalErrorException;
import org.gcube.common.storagehubwrapper.shared.tohl.exceptions.ItemNotFoundException;
import org.gcube.portlets.widgets.wsthreddssync.server.SyncronizeWithThredds;

public class UnSyncThreddsFolders {
    public static String DEFAULT_SCOPE = "/gcube";
    public static String TEST_USER = "francesco.mangiacrapa";
    public static String TEST_USER_TOKEN = "0e2c7963-8d3e-4ea6-a56d-ffda530dd0fa-98187548";
    private static List<String> lstUnSynchedItem = new ArrayList<String>();
    private static List<String> lstUnSynchedFailedItem = new ArrayList<String>();
    private static List<String> lstErrorItem = new ArrayList<String>();
    private static long totalAttempts = 0L;
    static String scope = "/gcube/devsec";
    static String token = "TOKEN";
    public static SyncronizeWithThredds syncService = new SyncronizeWithThredds();

    public static Workspace getWorkspace() throws Exception {
        ScopeProvider.instance.set(scope);
        StorageHubWrapper shWrapper = new StorageHubWrapper(scope, token, false, false, true);
        return shWrapper.getWorkspace();
    }

    public static void main(String[] args) throws Exception {
        Workspace ws = UnSyncThreddsFolders.getWorkspace();
        UnSyncThreddsFolders.unsycFirstLevel(ws, ws.getRoot().getId(), false);
        System.out.println("UnSync completed");
        System.out.println("\nUnsync attempted: " + totalAttempts);
        System.out.println("\nTotal failed unsync: " + lstUnSynchedFailedItem.size());
        for (String string : args) {
            System.out.println("Failed unsync: " + string);
        }
        System.out.println("\nUnsynched " + lstUnSynchedItem.size() + " item/s");
        for (String string : lstUnSynchedItem) {
            System.out.println("Unsynched id: " + string);
        }
        System.out.println("\nErros on " + lstErrorItem.size() + " item/s");
        for (String string : lstErrorItem) {
            System.out.println("Error on id: " + string);
        }
    }

    public static void unsycFirstLevel(Workspace ws, String itemId, boolean depthUnsync) throws Exception {
        try {
            WorkspaceItem item = ws.getItem(itemId);
            if (item.isFolder()) {
                List children = ws.getChildren(item.getId());
                for (WorkspaceItem workspaceItem : children) {
                    if (depthUnsync) {
                        UnSyncThreddsFolders.unsycFirstLevel(ws, workspaceItem.getId(), depthUnsync);
                    }
                    UnSyncThreddsFolders.unsynFolder(workspaceItem);
                }
            }
        }
        catch (ItemNotFoundException e) {
            e.printStackTrace();
            lstErrorItem.add(itemId);
        }
        catch (InternalErrorException e) {
            e.printStackTrace();
            lstErrorItem.add(itemId);
        }
    }

    public static void unsynFolder(WorkspaceItem workspaceItem) {
        if (workspaceItem == null) {
            return;
        }
        try {
            boolean synched = syncService.isItemSynched(workspaceItem.getId(), DEFAULT_SCOPE, TEST_USER);
            System.out.println("Is the workspace item: " + workspaceItem.getId() + " synched? " + synched + ", Is folder? " + workspaceItem.isFolder());
            if (synched && workspaceItem.isFolder()) {
                ScopeProvider.instance.set(DEFAULT_SCOPE);
                SecurityTokenProvider.instance.set(TEST_USER_TOKEN);
                Workspace ws = UnSyncThreddsFolders.getWorkspace();
                UnSyncThreddsFolders.cleanItem(workspaceItem, ws);
                ++totalAttempts;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            lstErrorItem.add(workspaceItem.getId());
        }
    }

    static void cleanItem(WorkspaceItem item, Workspace ws) throws Exception {
    }
}

