/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resource.management.quota.manager.persistence.entities.converters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

@Converter
public class StringListConverter
implements AttributeConverter<List<String>, String> {
    public String convertToDatabaseColumn(List<String> list) {
        if (list != null && list.size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (String value : list) {
                builder.append(value).append(",||,");
            }
            return builder.substring(builder.length() - 4, builder.length());
        }
        return "";
    }

    public List<String> convertToEntityAttribute(String dbEntry) {
        if (dbEntry != null && !dbEntry.isEmpty()) {
            return Arrays.asList(dbEntry.split(",\\|\\|,"));
        }
        return new ArrayList<String>(0);
    }
}

