/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.vremanagement.softwaregateway.client.SGAccessLibrary;
import org.gcube.vremanagement.softwaregateway.client.fws.Types;
import org.gcube.vremanagement.softwaregateway.client.proxies.Proxies;

public class GetSALocationClient {
    public static void main(String[] args) {
        SGAccessLibrary library;
        for (int i = 0; i < args.length; ++i) {
            System.out.println("param N." + i + ": " + args[i]);
        }
        if (args.length != 7) {
            System.out.println("Usage:");
            System.out.println("\tjava  GetSALocationClient   SoftwareGatewayEPR  scope  ServiceName   ServiceClass   ServiceVersion   PackageName   PackageVersion\n\n");
            System.out.println("Example:");
            System.out.println("\tjava  GetSALocationClient  http://node2.d.d4science.research-infrastructures.eu:9001/wsrf/services/gcube/vremanagement/softwaregateway/Access  /gcube/devsec sn sc sv pn pv  \n\n");
            return;
        }
        ScopeProvider.instance.set(args[1]);
        try {
            library = (SGAccessLibrary)Proxies.accessService().at(new URI(args[0])).withTimeout(1, TimeUnit.MINUTES).build();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return;
        }
        String serviceClass = args[2];
        String serviceName = args[3];
        String serviceVersion = args[4];
        String packageName = args[5];
        String packageVersion = args[6];
        Types.SACoordinates saCoordinates = new Types.SACoordinates();
        saCoordinates.pn = packageName;
        saCoordinates.pv = packageVersion;
        saCoordinates.sc = serviceClass;
        saCoordinates.sn = serviceName;
        saCoordinates.sv = serviceVersion;
        String url = null;
        url = library.getSALocation(saCoordinates);
        System.out.println("Remote url: \n" + url);
    }
}

