/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.vremanagement.softwaregateway.client.SGRegistrationLibrary;
import org.gcube.vremanagement.softwaregateway.client.proxies.Proxies;

public class RegisterProfileClient {
    public static void main(String[] args) throws Exception {
        SGRegistrationLibrary library;
        for (int i = 0; i < args.length; ++i) {
            System.out.println("param N." + i + ": " + args[i]);
        }
        if (args.length != 3) {
            System.out.println("Usage:");
            System.out.println("\tjava  RegisterProfileClient   SoftwareGatewayEPR  scope  AbsolutePathsOfFileProfile\n\n");
            System.out.println("Example:");
            System.out.println("\tjava  RegisterProfileClient  http://node2.d.d4science.research-infrastructures.eu:9001/wsrf/services/gcube/vremanagement/softwaregateway/Registration  /gcube/devsec /home/gcube/profile.xml \n\n");
            return;
        }
        ScopeProvider.instance.set(args[1]);
        try {
            library = (SGRegistrationLibrary)Proxies.registrationService().at(new URI(args[0])).withTimeout(1, TimeUnit.MINUTES).build();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return;
        }
        String path = args[2];
        File profileFile = new File(path);
        FileInputStream is = new FileInputStream(profileFile);
        String profile = RegisterProfileClient.getStringFromInputStream(is);
        System.out.println("profile string: " + profile);
        String report = library.register(profile);
        System.out.println("Report.xml:");
        System.out.println(report);
        RegisterProfileClient.writoToFile(report, "report.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writoToFile(String report, String fileName) {
        FileOutputStream fop = null;
        try {
            File file = new File(fileName);
            fop = new FileOutputStream(file);
            if (!file.exists()) {
                file.createNewFile();
            }
            byte[] contentInBytes = report.getBytes();
            fop.write(contentInBytes);
            fop.flush();
            fop.close();
            System.out.println("Done");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fop != null) {
                    fop.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStringFromInputStream(InputStream is) {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }
}

