/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resources.federation.fhnmanager.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.resources.federation.fhnmanager.api.type.VMProvider;
import org.gcube.vomanagement.occi.FHNConnector;
import org.gcube.vomanagement.occi.OcciConnector;
import org.gcube.vomanagement.occi.exceptions.UnsupportedCredentialsTypeException;
import org.gcube.vomanagement.occi.utils.ScriptUtil;
import org.gcube.vomanagement.occi.utils.X509CredentialManager;

public class ConnectorFactory {
    private Map<String, FHNConnector> connectors = new HashMap();

    public FHNConnector getConnector(VMProvider vmp) {
        String vmpId = vmp.getId();
        if (!this.connectors.containsKey(vmpId)) {
            this.connectors.put(vmpId, this.createConnector(vmp));
        }
        return (FHNConnector)this.connectors.get(vmpId);
    }

    public String adaptIS(String a) {
        String ab = a.replace(" ", "\u00e9");
        return ab;
    }

    public String adaptCert(String b) {
        String bc = b.replace("\u00e9", "\n");
        return bc;
    }

    public String removeHeader(String c) {
        String cd = c.replace("-----BEGIN\nCERTIFICATE-----", "-----BEGIN CERTIFICATE-----");
        String ce = cd.replace("-----END\nCERTIFICATE-----", "-----END CERTIFICATE-----");
        String cf = ce.replace("-----BEGIN\nPRIVATE\nKEY-----", "-----BEGIN PRIVATE KEY-----");
        String cg = cf.replace("-----END\nPRIVATE\nKEY-----", "-----END PRIVATE KEY-----");
        return cg;
    }

    public String generateSecondLevelProxy(String path, String vo) {
        return X509CredentialManager.createProxy((String)path, (String)"", (String)vo);
    }

    public FHNConnector createConnector(VMProvider vmp) {
        try {
            String certPath = StringEncrypter.getEncrypter().decrypt(vmp.getCredentials().getEncodedCredentails(), new Key[0]);
            certPath = this.adaptIS(certPath);
            certPath = this.adaptCert(certPath);
            certPath = this.removeHeader(certPath);
            File f = new File("/tmp/x509up_u1000");
            if (!f.exists()) {
                f.createNewFile();
                f.setReadable(false, false);
                f.setWritable(false, false);
                f.setExecutable(false, false);
                f.setReadable(true, true);
                f.setWritable(true, true);
            }
            FileWriter fw = new FileWriter(f.getPath());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(certPath);
            bw.flush();
            bw.close();
            String c = this.generateSecondLevelProxy(f.getPath(), vmp.getCredentials().getVo());
            File d = new File(c);
            vmp.getCredentials().setEncodedCredentails(ScriptUtil.getScriptFromFile((File)d));
            d.delete();
            f.delete();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        OcciConnector connector = null;
        try {
            connector = new OcciConnector(vmp);
            connector.setTrustStore("/etc/grid-security/certificates");
        }
        catch (UnsupportedCredentialsTypeException e) {
            e.printStackTrace();
        }
        return connector;
    }
}

